# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# ldap_utils.py
#
# Librairie pour la gestion des requetes LDAP
#
###########################################################################

from scribe.eolegroup import Group
from scribe.eoleldap import LdapEntry
from scribe.eoleuser import User
from scribe.station import Station

FORCE_IN_REF_ETAB = ['eleves', 'professeurs', 'administratifs']

###########
# Groupes #
###########
def _get_etab_from_user(user):
    if user is not None:
        return User().get_etab(user)

def get_groupes(gtype='', banned=True, user=None):
    """
    renvoie les groupes selon certains critères
    """
    banned_groups = ['DomainAdmins', 'DomainComputers', 'DomainUsers',
                     'PrinterAdmins', 'PrintOperators']
    grp = Group()
    etab = _get_etab_from_user(user)
    liste_group = grp.get_groups(gtype, etab=etab)
    if banned:
        for banned_group in banned_groups:
            if banned_group in liste_group:
                liste_group.remove(banned_group)
    liste_group.sort()
    return liste_group

def get_classes(user=None):
    """
    renvoie la liste des classes
    """
    return get_groupes('classe', user=user)

def get_niveau(user=None):
    """
    renvoie la liste des niveaux
    """
    return get_groupes('niveau', user=user)

def get_classes_et_groupes(user=None):
    """
    renvoie la liste des classes et des groupes de travail
    """
    res = get_classes(user=user)
    res.extend(get_groupes('groupe', user=user))
    return res

def get_membres(groupe, etab=None, user=None):
    """
    renvoie la liste des membres d'un groupe
    """
    if user != None:
        etab = _get_etab_from_user(user)
    if groupe in FORCE_IN_REF_ETAB or etab == groupe:
        etab = None
    entry = LdapEntry()
    return entry.get_members(groupe, etab)

def get_membres_croise(groupes, user=None):
    """
    renvoie les membres de groupe qui sont aussi dans rgroupe
    """
    if user != None:
        etab = _get_etab_from_user(user)
        #hack pour le support multi-etab
        #cherche a avoir tous les eleves, retourne tous les eleves de
        #l'etablissement
        if groupes == ['eleves', 'eleves'] or groupes == ['eleves']:
            groupes = [etab, 'eleves']
        elif groupes == ['professeurs']:
            groupes = [etab, 'professeurs']
    else:
        etab = None
    membres = get_membres(groupes[0], etab=etab)
    for grp in groupes[1:]:
        mem = get_membres(grp, etab=etab)
        membres = list(set(membres).intersection(set(mem)))
    return membres

def get_nb_membres(groupe, user=None):
    """
    renvoie le nombre d'inscrit à un ou plusieurs groupes
    """
    if type(groupe) == list or type(groupe) == tuple:
        return len(get_membres_croise(groupe, user=user))
    else:
        return len(get_membres(groupe, user=user))

################
# utilisateurs #
################
def get_user_groups(user):
    """
    renvoie la liste des groupes de l'utilisateur
    """
    # FIXME : autres attributs dans la méthode
    usr = User()
    return usr.get_user_groups(user)

# FIXME : utilisé ?
#def get_user_shares(user):

# FIXME : utilisé ?
#def get_user_homedrive(user):

def get_simple_attr(user, attr):
    """
    renvoie un attribut utilisateur mono-valué
    """
    usr = User()
    try:
        return usr.get_attr(user, attr)[0]
    except:
        raise Exception('Utilisateur %s non trouvé' % user)

def get_user_sid(user):
    """
    renvoie le SID de l'utilisateur
    """
    return get_simple_attr(user, 'sambaSID')

def get_user_long_name(user):
    """
    renvoie le nom complet d'un utilisateur
    """
    return get_simple_attr(user, 'displayName')

def is_prof(user):
    """
    vérifie que l'utilisateur est un professeur
    """
    return 'professeurs' in get_user_groups(user)

def is_eleve(user):
    """
    vérifie que l'utilisateur est un élève
    """
    return 'eleves' in get_user_groups(user)

############
# partages #
############
# FIXME : utilisé ?
#def get_shares():

############
# Machines #
############
def get_machines():
    """
    renvoie la liste des stations
    """
    return Station().get_workstations()

