# _*_ coding: iso-8859-1 _*_
#Boa:FramePanel:Observation

import wx
import os
import sys

from win32api import GetComputerName

import fonctions
import option

from pbgest import CliPB
C = CliPB()
getrootobject, disconnect = C.getrootobject, C.disconnect

from process import killProcName, isrunning
from lance_cmd import lancecmd
import vncuser


[wxID_OBSERVATION, wxID_OBSERVATIONBTNCONTROLE, wxID_OBSERVATIONBTNDIFFUSION, 
 wxID_OBSERVATIONBTNSTOPDIFF, wxID_OBSERVATIONCHECKBOXACT, 
 wxID_OBSERVATIONCHECKLISTBOXDIFF, wxID_OBSERVATIONCHOICECLASSE, 
 wxID_OBSERVATIONCHOICEDIFFGRP, wxID_OBSERVATIONCHOICEELEVE, 
 wxID_OBSERVATIONSTATICBOX1, wxID_OBSERVATIONSTATICBOX2, 
 wxID_OBSERVATIONSTATICRED, wxID_OBSERVATIONSTATICTEXT1, 
 wxID_OBSERVATIONSTATICTEXT2, wxID_OBSERVATIONSTATICTEXT3, 
] = [wx.NewId() for _init_ctrls in range(15)]

class Observation(wx.Panel):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Panel.__init__(self, id=wxID_OBSERVATION, name='Observation',
              parent=prnt, pos=wx.Point(210, 293), size=wx.Size(738, 418),
              style=wx.TAB_TRAVERSAL)
        self.SetClientSize(wx.Size(730, 384))
        self.SetBackgroundColour(wx.Colour(255, 255, 209))

        self.staticText1 = wx.StaticText(id=wxID_OBSERVATIONSTATICTEXT1,
              label='Liste des groupes', name='staticText1', parent=self,
              pos=wx.Point(94, 56), size=wx.Size(100, 16), style=0)
        self.staticText1.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))

        self.staticText2 = wx.StaticText(id=wxID_OBSERVATIONSTATICTEXT2,
              label='El\xe8ves du groupe', name='staticText2', parent=self,
              pos=wx.Point(94, 140), size=wx.Size(98, 16), style=0)
        self.staticText2.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))

        self.staticRed = wx.StaticText(id=wxID_OBSERVATIONSTATICRED, label=' ',
              name='staticRed', parent=self, pos=wx.Point(30, 310),
              size=wx.Size(5, 19), style=0)
        self.staticRed.SetFont(wx.Font(12, wx.SWISS, wx.NORMAL, wx.BOLD, False,
              'Tahoma'))
        self.staticRed.SetForegroundColour(wx.Colour(249, 0, 0))

        self.choiceClasse = wx.Choice(choices=[],
              id=wxID_OBSERVATIONCHOICECLASSE, name='choiceClasse', parent=self,
              pos=wx.Point(48, 90), size=wx.Size(188, 24), style=0)
        self.choiceClasse.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.choiceClasse.Bind(wx.EVT_CHOICE, self.OnChoiceClasseChoice,
              id=wxID_OBSERVATIONCHOICECLASSE)

        self.choiceEleve = wx.Choice(choices=[], id=wxID_OBSERVATIONCHOICEELEVE,
              name='choiceEleve', parent=self, pos=wx.Point(48, 174),
              size=wx.Size(188, 24), style=0)
        self.choiceEleve.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.choiceEleve.Bind(wx.EVT_CHOICE, self.OnChoiceEleveChoice,
              id=wxID_OBSERVATIONCHOICEELEVE)

        self.checkBoxAct = wx.CheckBox(id=wxID_OBSERVATIONCHECKBOXACT,
              label='Clavier/Souris actifs', name='checkBoxAct', parent=self,
              pos=wx.Point(76, 226), size=wx.Size(144, 13), style=0)
        self.checkBoxAct.SetValue(False)
        self.checkBoxAct.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))

        self.btnControle = wx.Button(id=wxID_OBSERVATIONBTNCONTROLE,
              label='Observer', name='btnControle', parent=self,
              pos=wx.Point(88, 264), size=wx.Size(104, 24), style=0)
        self.btnControle.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.btnControle.Bind(wx.EVT_BUTTON, self.OnBtnControleButton,
              id=wxID_OBSERVATIONBTNCONTROLE)

        self.staticBox1 = wx.StaticBox(id=wxID_OBSERVATIONSTATICBOX1,
              label='Observation', name='staticBox1', parent=self,
              pos=wx.Point(16, 32), size=wx.Size(256, 312), style=0)

        self.staticBox2 = wx.StaticBox(id=wxID_OBSERVATIONSTATICBOX2,
              label='Diffusion', name='staticBox2', parent=self,
              pos=wx.Point(296, 32), size=wx.Size(416, 312), style=0)

        self.choiceDiffGrp = wx.Choice(choices=[],
              id=wxID_OBSERVATIONCHOICEDIFFGRP, name='choiceDiffGrp',
              parent=self, pos=wx.Point(312, 90), size=wx.Size(160, 24),
              style=0)
        self.choiceDiffGrp.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.choiceDiffGrp.Bind(wx.EVT_CHOICE, self.OnChoiceDiffGrpChoice,
              id=wxID_OBSERVATIONCHOICEDIFFGRP)

        self.checkListBoxDiff = wx.CheckListBox(choices=[],
              id=wxID_OBSERVATIONCHECKLISTBOXDIFF, name='checkListBoxDiff',
              parent=self, pos=wx.Point(488, 56), size=wx.Size(208, 264),
              style=0)

        self.btnDiffusion = wx.Button(id=wxID_OBSERVATIONBTNDIFFUSION,
              label='Diffuser mon \xe9cran', name='btnDiffusion', parent=self,
              pos=wx.Point(328, 174), size=wx.Size(112, 26), style=0)
        self.btnDiffusion.Bind(wx.EVT_BUTTON, self.OnBtnDiffusionButton,
              id=wxID_OBSERVATIONBTNDIFFUSION)

        self.staticText3 = wx.StaticText(id=wxID_OBSERVATIONSTATICTEXT3,
              label='Liste des groupes', name='staticText3', parent=self,
              pos=wx.Point(338, 56), size=wx.Size(100, 16), style=0)
        self.staticText3.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))

        self.btnStopDiff = wx.Button(id=wxID_OBSERVATIONBTNSTOPDIFF,
              label='Cesser la diffusion', name='btnStopDiff', parent=self,
              pos=wx.Point(328, 210), size=wx.Size(112, 26), style=0)
        self.btnStopDiff.Bind(wx.EVT_BUTTON, self.OnBtnStopDiffButton,
              id=wxID_OBSERVATIONBTNSTOPDIFF)

    def __init__(self, parent, id, pos, size, style, name):
        self._init_ctrls(parent)
        try: self.vnc_path = os.path.join(option.get_inst_path(), 'ultravnc')
        except: raise Exception('Cl "inst_path" introuvable')
        self.vnc = vncuser.VncUser(self.vnc_path)
        self.vnc_exe = os.path.join(self.vnc_path, 'winvnc.exe')
        try:
            self.init_forms__()
            self.init_opts_()
        except Exception, e:
            fonctions.red_alert('%s'%e)
            sys.exit()

    def init_opts_(self):
        """
        """
        self.viewonly = option.get_vnc_viewonly()
        if self.viewonly == 'controle': self.checkBoxAct.Enable()
        elif self.viewonly == 'desactive':
            self.choiceClasse.Disable()
            self.checkBoxAct.Disable()
            message = u"L'observation est dsactive"
            self.staticRed.SetLabel(message)
        
    def init_forms__(self):
        """vide et dsactive le comboBox "eleves", dsactive le bouton
        et teste le mode de controle
        """
        self.checkBoxAct.Disable()
        self.btnControle.Disable()
        self.choiceEleve.SetLabel('')
        self.choiceEleve.Disable()
        self.choiceEleve.Clear()
        self.choiceClasse.Clear()
        self.checkListBoxDiff.Clear()
        self.choiceDiffGrp.Clear()

###############
# Observation #
###############    
    def OnChoiceClasseChoice(self, event):
        self.init_liste_eleves(self.choiceClasse.GetStringSelection())
        self.btnControle.Disable()

    def OnChoiceEleveChoice(self, event):
        self.btnControle.Enable()

    def OnBtnControleButton(self, event):
        eleve = self.choiceEleve.GetStringSelection()
        try:
            self.eleve_ip = self.dico_eleves[eleve]['ip']
            self.eleve_os = self.dico_eleves[eleve]['os']
        except:
            msg = "Aucun lve dfini"
            raise(msg)
        self.lance_vnc()
        
    def init_groupes(self, parent):
        """Appel  la mthode "remote_classes_et_groupes"
        """
        self.parent = parent
        self.statusBar1 = parent.statusBar1
        self.stop_listen()
        self.start_listen()
        # rcupration de la liste sur le serveur
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("classes_et_groupes"))
        d.addCallback(self.return_groupes)
        d.addErrback(self.serv_err, ('Erreur lors de la rcupration de la liste des classes'))
  
    def return_groupes(self, liste_groupes):
        """Affiche la liste des classes dans le premier comboBox
        """
        disconnect()
        if liste_groupes is None :
            fonctions.red_alert('Erreur lors de la rcupration de la liste des groupes 2')
            return
        liste_groupes.append('eleves')
        self.choiceClasse.AppendItems(liste_groupes)
        liste_groupes.append('professeurs')
        self.choiceDiffGrp.AppendItems(liste_groupes)

    def init_liste_eleves(self, groupe):
        """dclench lorsqu'un groupe a t slectionn
        """
        # viter le 1er clic
        if groupe == "":
            return
        # rcupration de la liste des connectes sur le serveur
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("connectes", [groupe, 'eleves'])) # n'afficher que les lves du groupe
        d.addErrback(self.serv_err, 'Erreur lors de la rcupration de la liste des connects')
        d.addCallback(self.return_eleves)

    def return_eleves(self, liste):
        """affiche le retour de la fonction "remote_connectes(classe)"
        ou un message en cas d'erreur
        """
        disconnect()
        self.choiceEleve.Clear()
        self.choiceEleve.Disable()
        self.eleves = []
        self.dico_eleves = {}
        try:
            for i in liste:
                user, groupe, machine, os, ip = i
                item = '%s - %s'%(user, machine)
                self.eleves.append(item)
                self.dico_eleves[item] = dict(ip = ip)
                self.dico_eleves[item]['os'] = os
            if len(liste) == 0:
                self.choiceEleve.AppendItems([u'Aucun lve trouv'])
                self.statusBar1.SetStatusText(u'Aucun lve trouv')
                self.choiceEleve.SetSelection(0)
            else:
                self.choiceEleve.AppendItems(self.eleves)
                self.statusBar1.SetStatusText('Pr\xeat', 0)
                self.choiceEleve.Enable()
        except:
            self.choiceEleve.AppendItems([u'Erreur'])
            self.statusBar1.SetStatusText(u'Erreur')
            self.choiceEleve.SetSelection(0)

    def lance_vnc(self):
        """si le poste local est XP et distant XP :
            local => listen ; distant => connect <local>
        si XP => 9x ou 9x => XP : ancien systme (vncviewer <distant> avec service actif sur distant)
            local => vncviewer <distant>
        """
        self.btnControle.Disable()
        self.statusBar1.SetStatusText('Connexion en cours ...', 0)
        self.vnc.start_listen()
        # appel  la mthode remote_observe
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("observe", self.eleve_ip, self.checkBoxAct.IsChecked()))
        d.addErrback(self.serv_err, "Erreur lors de l'observation")
        d.addCallback(self.ret_observe)
            
    def ret_observe(self, ret):
        disconnect()
        self.statusBar1.SetStatusText('Pr\xeat', 0)
        return True
    
#############
# Diffusion #
#############
    def OnChoiceDiffGrpChoice(self, event):
        self.init_liste_diff_eleves(self.choiceDiffGrp.GetStringSelection())

    def OnBtnDiffusionButton(self, event):
        self.diff_eleves_ips = []
        eleves = self.checkListBoxDiff.GetItems()
        for eleve in eleves:
            if self.checkListBoxDiff.IsChecked(eleves.index(eleve)):
                ip, os = self.dico_diff_eleves[eleve]['ip'], self.dico_diff_eleves[eleve]['os']
                self.diff_eleves_ips.append(ip)
        if self.diff_eleves_ips != []: self.lance_diff()

    def OnBtnStopDiffButton(self, event):
        killProcName('winvnc.exe')

    def init_liste_diff_eleves(self, groupe):
        # viter le 1er clic
        if groupe == "":
            return
        # rcupration de la liste des connectes sur le serveur
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("connectes", (groupe)))
        d.addErrback(self.serv_err, 'Erreur lors de la rcupration de la liste des connects')
        d.addCallback(self.return_diff_eleves)

    def return_diff_eleves(self, liste):
        disconnect()
        self.checkListBoxDiff.Clear()
        self.diff_eleves = []
        self.dico_diff_eleves = {}
        try:
            for i in liste:
                user, groupe, machine, os, ip = i
                if machine.lower() == GetComputerName().lower(): continue
                item = '%s - %s'%(user, machine)
                self.diff_eleves.append(item)
                self.dico_diff_eleves[item] = dict(ip = ip)
                self.dico_diff_eleves[item]['os'] = os
            if len(liste) == 0:
                self.checkListBoxDiff.AppendItems([u'Aucun lve trouv'])
                self.statusBar1.SetStatusText(u'Aucun lve trouv')
                self.btnDiffusion.Disable()
            else:
                self.checkListBoxDiff.AppendItems(self.diff_eleves)
                self.statusBar1.SetStatusText('Pr\xeat', 0)
                self.btnDiffusion.Enable()
        except:
            self.checkListBoxDiff.AppendItems([u'Erreur'])
            self.statusBar1.SetStatusText(u'Erreur')
            self.btnDiffusion.Disable()
    
    def lance_diff(self):
        self.statusBar1.SetStatusText('Activation de la diffusion ...', 0)
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("diffusion", self.diff_eleves_ips))
        d.addErrback(self.serv_err, 'Erreur lors de la diffusion')
        d.addCallback(self.ret_diff)

    def ret_diff(self, ret):
        disconnect()
        self.statusBar1.SetStatusText('Diffusion en cours ...', 0)
        if not isrunning('winvnc.exe'):
            lancecmd(self.vnc_exe, nowait=True, waitinput=True)
        for ip in self.diff_eleves_ips:
            self.statusBar1.SetStatusText('Diffusion sur %s'%ip, 0)
            lancecmd('%s -connect %s'%(self.vnc_exe, ip), nowait=True)
        self.statusBar1.SetStatusText('Pr\xeat', 0)
        
##################
# Mise en coute #
##################
    def start_listen(self):
        self.statusBar1.SetStatusText('Mise en coute ...')
        self.vnc.start_listen()
        self.statusBar1.SetStatusText('Pr\xeat', 0)

    def stop_listen(self):
        """Arrte VNC Viewer et VNC Server"""
        try:
            self.statusBar1.SetStatusText('Fermeture des connexions ...')
            killProcName('vncviewer.exe')
            killProcName('winvnc.exe')
        except: pass

    def serv_err(self, ret, err):
        self.statusBar1.SetStatusText(u'Erreur')
        disconnect()
        err = 'Observation : %s'%err
        self.parent.serv_err(ret, err)
        self.statusBar1.SetStatusText(u'Prt')

