#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_


import win32api as wa
import win32con as wc
import win32ui as wu
import win32gui as wg

import os
import logging

import reg, option
from render_image import renderImage, convert_to_bmp

from twisted.internet import reactor

##################
## Fond d'ecran ##
##################
def del_backgrnd(outbg):
    if os.path.isfile(outbg): os.unlink(outbg)
    
def apply_wallpaper(sid):
    # Fonction dediee pour re-ecrire la cle indiquant le fond d'ecran
    # et a l'appliquer
    bgkey = r'%s\Control Panel\Desktop'%sid
    outbg = os.path.join(wa.GetTempPath(), 'cliscribe_bg.bmp')
    reg.addreg('HKEY_USERS', bgkey, reg._winreg.REG_SZ, 'Wallpaper', outbg)
    bg = reg.get_option(bgkey, 'Wallpaper', 'HKEY_USERS')
    logging.debug("Fond d'ecran detecte \"%s\""%bg)
    wg.SystemParametersInfo(wc.SPI_SETDESKWALLPAPER, bg, wc.SPIF_SENDCHANGE)

def set_backgrnd(sid, message): #, outbg):
    """<message> est une liste, ecrit 1 item par ligne
    en haut a droite sur le fond d'ecran de <sid>
    """
    bginfo = option.get_esu_show_username()
    bgkey = r'%s\Control Panel\Desktop'%sid
    bg = reg.get_option(bgkey, 'Wallpaper', 'HKEY_USERS')
    outbg = os.path.join(wa.GetTempPath(), 'cliscribe_bg.bmp')
    if bg: logging.debug('Utilisation de "%s"'%bg)
    else:
        logging.debug("Aucun fond d'ecran")
        if bginfo != 1:
            return
    if bginfo != 1:
        logging.info("Application du fond d'ecran sans informations utilisateur")
        convert_to_bmp(bg, outbg)
    else:
        # Creation de %TMP%\cliscribe_bg.bmp
        logging.info("Generation du fond d'ecran avec informations utilisateur")
        logging.debug("Mise en place du fond d'ecran sid=%s message=%s"%(sid, message))
        logging.debug('RenderImage args : %s'%[bg, outbg, get_format(sid), message, get_backgrnd_color(), get_resolution()])
        renderImage(bg, outbg, get_format(sid), message, get_backgrnd_color(), get_resolution())
    apply_wallpaper(sid)
    # fonction appelee deux fois a plusieurs secondes d'interval car
    # le profil windows a tendance a ecraser la valeur du fond d'ecran
    reactor.callLater(20, apply_wallpaper, sid)


def test_backgrnd(inbg, outbg, message):
    """<message> est une liste, ecrit 1 item par ligne
    en haut a droite sur le fond d'ecran de <sid>
    """
    logging.debug('Utilisation de "%s"'%inbg)
    renderImage(inbg, outbg, 'etendre', message,) # get_backgrnd_color(), get_resolution())
##    reg.addreg('HKEY_USERS', bgkey, reg._winreg.REG_SZ, 'Wallpaper', outbg)
##    apply_wallpaper(sid)

def get_resolution():
    """renvoie la resolution de l'affichage
    """
    hor = wu.GetDeviceCaps(wg.GetDC(0), wc.HORZRES)
    ver = wu.GetDeviceCaps(wg.GetDC(0), wc.VERTRES)
    return (hor, ver)

def get_backgrnd_color():
    """Retourne le code couleur du fond sans image
    """
    c = '%06X'%wa.GetSysColor(wc.COLOR_DESKTOP)
    return '#%s%s%s'%(c[4:6], c[2:4], c[0:2])

def get_format(sid):
    """retourne le mode d'affichage du BG
    """
    bgkey = r'%s\Control Panel\Desktop'%sid
    style = reg.get_option(bgkey, 'WallpaperStyle', 'HKEY_USERS')
    tile = reg.get_option(bgkey, 'TileWallpaper', 'HKEY_USERS')
    if tile == '1': return "mosaique"
    if style == '0': return "centre"
    return "etendre"
