# _*_ coding: iso-8859-1 _*_
#!/usr/bin/env python

import urllib2, md5, tempfile, logging, os, time
import option


SERVEUR = option.get_ip_scribe()
PORT = int(option.get_port_scribe_update())

def get_file(fich, dstdir=None):
    """tlcharge "fich" et "fich.MD5SUM" sur SERVEUR
    calcul le checksum de fich et le compare  celui contenu dans "fich.MD5SUM"
    """
    logging.debug('Demande de telechargement de %s'%fich)
    if not dstdir:
        dstdir = tempfile.mkdtemp()
    dest = os.path.join(dstdir, fich)
    dest5 = '%s.MD5SUM'%dest
    for i in [dest, dest5]:
        if os.path.exists(i):
            os.remove(i)
    dirn = os.path.dirname(dest)
    if not os.path.isdir(dirn):
        os.makedirs(dirn)
    url = 'http://%s:%s/%s'%(SERVEUR, PORT, fich)
    url5 = '%s.MD5SUM'%url
    try:
        attempts = option.get_download_attempts()
        if attempts: attempts = int(attempts)
        else: attempts = 30
        if attempts < 1: raise Exception('download_attempts doit tre suprieur ou gal  "1"')
    except Exception, e:
        logging.error(e)
        attempts = 30
    logging.info(u'Telechargement de %s dans "%s" (%s tentatives)'%(url, dstdir, attempts))
    for i in range(attempts):
        try:
            fc = urllib2.urlopen(url).read()
            break
        except Exception, e:
            logging.debug('Passage %s'%(i+1))
            if i == (attempts - 1):
                logging.error(e)
                return
            time.sleep(1) # attendre
    fh = file(dest, 'wb')
    fh.write(fc)
    fh.close()
    # le md5sum
    logging.debug(u'Telechargement de %s'%url5)
    for i in range(attempts):
        try:
            fc5 = urllib2.urlopen(url5).read()
            break
        except Exception, e:
            logging.error(e)
            if i == (attempts - 1):
                return
            time.sleep(2) # attendre
    file(dest5, 'wb').write(fc5)
    if not check_sum(dest, dest5): return False
    return dest

def check_sum(fich, sumfich):
    """rcupre le checksum contenu dans sumfich,
    calcule le checksum de fich
    et compare les deux
    """
    orig_sum = file(sumfich, 'r').readlines()[0].strip().split()[0].strip()
    dest_sum = md5.md5(file(fich, 'rb').read()).hexdigest().strip()
    if orig_sum == dest_sum:
        logging.debug('checksum OK %s'%orig_sum)
        return True
    else:
        logging.error('checksum ERROR : %s=%s, %s=%s'%(sumfich, orig_sum, fich, dest_sum))
        return False
