# _*_ coding: iso-8859-1 _*_
#!/usr/bin/python

import re, os

STRING_REGEX = r'"(?:[^"\\]|\\")*"'
regex = r"user_pref\s*\((%s)\s*,\s*(%s|[^ )]+)\s*\)" % (
    STRING_REGEX, STRING_REGEX)
USER_PREF_REGEX = re.compile(regex, re.MULTILINE)

class FirefoxPrefsJS:
    def __init__(self, filename):
        """
        Charge les prferrences depuis un fichier "prefs.js" s'il existe
        """
        self.filename = filename
        self.prefs = {}
        if os.path.isfile(filename):
            prefs = open(filename).read()
            for key, value in USER_PREF_REGEX.findall(prefs):
                self.prefs[key] = value

    def __setitem__(self, key, value):
        """
        Modifie la valeur d'une prferrence o key est une cl sans
        guillemets, ex: "browser.download.lastDir"
        """
        key = '"%s"' % key
        self.prefs[key] = value

    def __delitem__(self, key):
        """
        Supprime une entre o key est une cl sans
        guillemets, ex: "browser.download.lastDir".

        Ne gnre pas d'erreur si la cl n'existait pas.
        """
        key = '"%s"' % key
        try:
            del self.prefs[key]
        except KeyError:
            pass

    def save(self, filename=None):
        """
        Sauvegarde la confirmation dans le fichier spcifi.
        crit des lignes de la forme:
           user_pref("cle", valeur);
        """
        if filename is None: filename = self.filename
        content = []
        for key, value in self.prefs.iteritems():
            content.append("user_pref(%s, %s);" % (key, value))
        open(filename, 'w').write("\n".join(content))

def main():
    prefs = FirefoxPrefsJS("prefs.js")
    prefs["browser.download.lastDir"] = '"/tmp/download"'
    del prefs["accessibility.typeaheadfind.flashBar"]
    del prefs["accessibility.typeaheadfind.flashBar"]
    prefs.save("new-prefk.js")

if __name__ == "__main__":
    main()

