# _*_ coding: iso-8859-1 _*_
import logging
from twisted.internet import threads

from messagebox import gmessage

from pbgest import CliPB
C = CliPB()
getrootobject, disconnect = C.getrootobject, C.disconnect

import option

from perms import AjouterPrivilege, add_to_local_group, del_domusers_from_group
from wintime import settime
from os_type import type_os
##from lance_cmd import lancecmd
from replace_win_vars import convert, get_vars_from_dict

##import win32api as wa
##import win32con as wc
##import os
import reg

## Deconnexion de l'utilisateur
# Accs  l'environnement utilisateur
class userconnect:
    def lance_userlogoff(self, force=True):
        d = getrootobject(ip='127.0.0.1', port=option.get_port_utilisateur())
        d.addCallback(lambda object: object.callRemote('logoff', force))
        d.addCallback(disconnect)
        return d

logoff_user = userconnect().lance_userlogoff

"""
Par le service :
- rcupration des variables d'environnement de l'utilisateur via "remote_get_env_vars"
- registre (nettoyage, nouvelles rgles)
- dconnexion (l'option dconnexion est renseigne par les rgles
               on doit donc d'abord renseigner le registre pour
               savoir si l'utilisateur doit tre dconnect)
- synchro horaire
- privilege
- ACLs fichier / registre

Par l'utilisateur :
- fond d'cran (affichage du nom d'utilisateur)
- imprimantes
- ini
- js
"""

class dlogon:
    def __init__(self, ldict, inst_path, nom_scribe):
        """ldict est le dictionnaire renvoy par controlevnc/esu.py
        il contient 3 dictionnaires :
        * les donnes Esu-machine "machine_dict"
        * et Esu-utilisateur "user_dict" dfinies dans la Console Esu
        * les variables dfinies dans la Console Esu et dans l'annuaire LDAP "esu_dict"
        """
        self.ldict = ldict
        self.inst_path = inst_path
        self.nom_scribe = nom_scribe

    def logon(self):
        """Rcupre les variables environnement de l'utilisateur (os.environ)
        """
        d = getrootobject(ip='127.0.0.1', port=option.get_port_utilisateur())
        d.addCallback(lambda object: object.callRemote('get_env_vars'))
        d.addCallback(self.return_vars)
        d.addErrback(return_err)
        return d

    def return_vars(self, varsd):
        """Retour de l'appel  la liste des variables environnement de l'utilisateur
        """
        disconnect()
        # sparation des diffrents dictionnaire (user, machine et esu)
        self.create_dicts(varsd)
        # registre machine
        reg.clean_machine_reg()
        applique_machine_reg(self.machine_dict['reg'])
        # l'utilisateur n'est pas gere par Esu
        if not self.esu_dict['ESU_GU']:
            logging.info("L'utilisateur ***%s*** n'est pas gere dans le groupe de machines ***%s***"
                         %(self.esu_dict['USERNAME'], self.esu_dict['ESU_GM']))
            return logoff()
        # registre utilisateur
        reg.clean_user_reg(self.esu_dict['SID'])
        applique_user_reg(self.user_dict['reg'], self.esu_dict['SID'])
        # Dsactiver le Fast User switching sous vista, fait aussi au dmarrage du service
        if type_os == 'Vista':
            reg.addreg('HKEY_LOCAL_MACHINE', r'Software\Microsoft\Windows\CurrentVersion\Policies\System', 'REG_DWORD', 'HideFastUserSwitching', '1')
        # synchro horaire
        timesync()
        # privileges
        privilege(self.esu_dict['ESU_GU'], self.user_dict['privileges'], self.nom_scribe)
        privilege('DomainUsers', self.machine_dict['privileges'], self.nom_scribe)
        # Gestionnaires
        gestionnaires(self.esu_dict['GESTIONNAIRES'], self.esu_dict['ESU_DOMAINE'])
        # appel utilisateur
        return appel_user(self.esu_dict, self.user_dict)

    def create_dicts(self, varsd):
        """Renseigne les variables et spare les 3 dictionnaires
        """
        self.esu_dict = self.ldict['esu_dict']
        # aux variables utilisateurs on ajoute celles d'Esu/LDAP
        varsd.update(self.esu_dict)
        logging.debug('Variables 1 %s'%varsd)
        # lecture des variables windows re-dfinies dans Esu
        varsd.update(get_vars_from_dict(self.ldict['user_dict']['reg']))
        varsd.update(get_vars_from_dict(self.ldict['machine_dict']['reg']))
        logging.debug('Variables 2 %s'%varsd)
        self.user_dict = convert(self.ldict['user_dict'], varsd)
        self.machine_dict = convert(self.ldict['machine_dict'], varsd)

######################################
## Fonctions d'ouverture de session ##
######################################
def applique_machine_reg(regliste):
    logging.info('Application de cles de registre machine')
    reg.put_regs(regliste)
    logging.info('Cles de registre machine appliquees')

def applique_user_reg(regliste, sid):
    logging.info('Application de cles de registre utilisateur')
    reg.put_regs(regliste, sid)
    logging.info('Cles de registre utilisateur appliquees')
    
## Dconnexion de l'utilisateur
def logoff():
    if str(reg.get_option(r'SOFTWARE\CRDP Bretagne\ESU', 'DisconnectBadUsers')) == '1':
        logging.info("Deconnexion de l'utilisateur")
        return logoff_user()

def timesync():
    time_server = reg.get_option(r'SOFTWARE\CRDP Bretagne\ESU', 'TimeServer')
    if time_server:
        logging.info('Synchronisation horaire sur "%s"'%time_server)
        settime(time_server)

def privilege(username, privileges, nom_scribe):
    """privileges = tuple() => (nom_prive, value)
    ne gre pas SUPPR (vraiment utile ?)
    """
    for priv, value in privileges:
        if value == 'ADD':
            logging.info('Application du privilege "%s"'%priv)
            AjouterPrivilege(username, priv, nom_scribe)

def gestionnaires(users, dom_name):
    users.append('domainadmins')
    del_domusers_from_group('Administrateurs', dom_name, users)
##    if not users:
##        logging.debug('Aucun gestionnaire Esu %s'%users)
##        return
    logging.info("Ajout de %s au groupe 'Administrateurs' de la machine"%users)
    for user in users:
        u = '%s\\%s'%(dom_name, user)
        add_to_local_group(u, 'Administrateurs')

def put_acl(username, acls):
    logging.info("TODO Application d'ACLs")
    pass

##############################################
## appel utilisateur                        ##
## configuration firefox, fond d'cran, etc.##
##############################################
def appel_user(esu_dict, user_dict):
    logging.info('Appel de remote_logon (utilisateur)')
    d = getrootobject(ip='127.0.0.1', port=option.get_port_utilisateur())
    d.addCallback(lambda object: object.callRemote('logon', esu_dict, user_dict))
    d.addCallback(lambda echo: logging.debug('retour remote_logon utilisateur %s'%echo)) # sur Scribe on appelle remot_vnc; remote_bloc...
    d.addCallback(lambda _: disconnect(True))
    d.addErrback(return_err)
    return d

## En cas d'erreurs... ##
def return_err(o=''): #, *args):
    """Fonction d'erreur, peut servir  un ErrBack
    """
    disconnect()
    try:
        message = '%s'%o.value
        if option.get_log_level() <= 10:
            message = ' %s'%o.getTraceback()
##            message += ' %s'%o.getBriefTraceback()
    except: message = '%s'%o
    logging.error('Erreur : %s %s'%([o,], message))
    a = threads.deferToThread(mbox, 'Erreur : %s %s'%([o,], message), 'error')

def mbox(message, style):
    gmessage(message, "Gestionnaire session utilisateur (service Scribe)", style)

def logon(logon_dict, inst_path, nom_scribe):
    l = dlogon(logon_dict, inst_path, nom_scribe)
    return l.logon()
