# _*_ coding: iso-8859-1 _*_
# Change les ACLs d'un fichier/dossier (non rcursivement, TODO utiliser "AddAccessAllowedAceEx" pour a)
import win32security as wsec
import win32file as wf
import win32api as wa
import win32net as wn
import ntsecuritycon as ntsec
import logging
import traceback

# Privilges #
def AdjustPrivilege(privileges):
    """Active les privilges lists dans privileges
    """
    if type(privileges) == str: privileges = [privileges]
    for priv in privileges:
        # Get the process token.
        flags = ntsec.TOKEN_ADJUST_PRIVILEGES | ntsec.TOKEN_QUERY
        htoken = wsec.OpenProcessToken(wa.GetCurrentProcess(), flags)
        # Get the ID for the privilege.
        pr_id = wsec.LookupPrivilegeValue(None, priv)
        # Now obtain the privilege for this process.
        newPrivileges = [(pr_id, ntsec.SE_PRIVILEGE_ENABLED)]
        # and make the adjustment.
        wsec.AdjustTokenPrivileges(htoken, 0, newPrivileges)
        htoken.Close()

def AjouterPrivilege(username, privilege, scribe):
    """Ajoute le privilgre <privilege>  <username>
    <scribe> est le nom SMB de Scribe
    """
    policy_handle = wsec.LsaOpenPolicy(None, wsec.POLICY_ALL_ACCESS)
    sid_obj, domain, tmp = wsec.LookupAccountName(scribe, username)
    wsec.LsaAddAccountRights(policy_handle, sid_obj, (privilege,))
    wsec.LsaClose(policy_handle)
    
# ACLs #
def set_acl(obj, domain=None, scribe=''):
    """Met l'ACL "contrle total" sur obj
    non rcursivement pour "DomainUsers"
    """
    # Le SID de DomainUsers
    if domain: dusers = r'%s\DomainUsers'%domain
    else: dusers = 'DomainUsers'
    logging.debug("Mise en place d'ACLs pour %s sur %s"%(dusers, obj))
    try:
        try:
            domainusers_sid = wsec.LookupAccountName(scribe, dusers)
        except:
            logging.debug('Erreur LookupAccountName')
            return
        domainusers_sid = domainusers_sid[0]
        # rcupration du descripteur (vive le franais) de scu
        info = wsec.DACL_SECURITY_INFORMATION
        sd = wsec.GetFileSecurity(obj, info)
        # les ACLs
        acl = sd.GetSecurityDescriptorDacl()
        # ajout de l'ACL Accs complet pour DomainUSers
        acl.AddAccessAllowedAceEx(wsec.ACL_REVISION_DS, wsec.OBJECT_INHERIT_ACE, wf.FILE_ALL_ACCESS, domainusers_sid)
        # maj du Security Descriptor
        sd.SetSecurityDescriptorDacl(1, acl, 0)
        # application sur l'objet
        wsec.SetFileSecurity(obj, info, sd)
        logging.debug("Mise en place d'ACLs reussie")
    except Exception, e:
        logging.error("Erreur d'application des ACLs %s"%([obj, dusers, e]))
        logging.debug('Erreur %s'%traceback.format_exc())

# Utilisateurs et groupes #
def add_to_local_group(user, group):
    """Ajoute l'utilisateur <user> dans le groupe <group> local de la machine
    """
    try:
        u = [{'domainandname': user}]
        members = [str(i['domainandname'].lower()) for i in wn.NetLocalGroupGetMembers(None, group, 3)[0]]
        if str(user.lower()) in members:
            logging.debug("L'utilisateur %s fait deja parti du groupe %s"%(user, group))
            return
        logging.debug('Ajout de %s au groupe %s'%(user, group))
        return wn.NetLocalGroupAddMembers(None, group, 3, u)
    except Exception, e:
        logging.error("Erreur d'ajout au groupe %s"%([user, group, e]))
        logging.debug('Erreur %s'%traceback.format_exc())

def del_domusers_from_group(group, dom_name, exusers=[]):
    """Supprime les utilisateurs du domaine <dom_name>
    du groupe <group> local de la machine
    """
    logging.info('Suppression des utilisateurs du domaine %s du groupe %s'%(dom_name, group))
    try:
        members = [str(i['domainandname'].lower()) for i in wn.NetLocalGroupGetMembers(None, group, 3)[0]]
        logging.debug('%s'%members)
        for m in members:
            if '\\' not in m: continue # on a un utilisateur de la forme S-1-5-21-2893502560-455340565-390427172-25051
            dom, user = m.split('\\')
            if dom.strip().lower() != dom_name.strip().lower(): continue
            if user.strip().lower() in exusers: continue
            logging.debug('Suppression de %s du groupe %s'%(m, group))
            wn.NetLocalGroupDelMembers(None, group, [m])
    except Exception, e:
        logging.error("Erreur d'ajout au groupe %s"%([group, e]))
        logging.debug('Erreur %s'%traceback.format_exc())

