# _*_ coding: iso-8859-1 _*_
###########################################
## Gnration du service client SCRIBE   ##
## pour la gestion du poste              ##
## licence GPL Eole                      ##
###########################################

import os
import time
import traceback
# pour utilisation en non-compil
##os.environ['path']='%s;%s'%(os.environ['path'], os.path.join(os.path.abspath('.'), 'dlls'))

# Initialisation du parefeu (dsactive pour XPSP2 et paramtre pour Vista)
# Le parefeu doit tre initialis avant tout
##from eole.winfw import fw
from eole.winfw import WinFw
from eole import option, download, win32_64, iphelp
# Rgles de base pour autoriser le service  sortir
def preinit_fw():
    """Pour viter les variables globales
    ouvre les parefeu pour permettre le tlchargement du fichier de rgles
    liste_fwregles.eol"""
    rules = ['WinNT|Win2K3|Win2K|WinXP|Vista:: "Scribe" ;; proto = "tcp" ;; ip_src = "me" ;; ip_dst = "any" ;; action = "allow"',
             'WinNT|Win2K3|Win2K|WinXP|Vista:: "Scribe" ;; proto = "udp" ;; ip_src = "any" ;; ip_dst = "any" ;; action = "allow"',
             'Vista:: "Scribe" ;; proto = "any" ;; program="%EOLEPATH%\cliscribe\servscribe.exe" ;; ip_src = "me" ;; ip_dst = "any" ;; action = "allow"']
    fw.init_fw()
    fw.addrules(rules)

fw = WinFw()
preinit_fw()

def init_fw():
    """Initialise pour de bon le parefeu avec les rgles Scribe
    """
    # Tlchargement sur le serveur des rgles  appliquer
    init_f = download.get_file('liste_fwregles.eol')
    ##init_f = os.path.join(option.get_inst_path(), 'cliscribe', 'liste_fwregles.eol')
    fw.init_fw(init_f)
    #fw.addrules_from_file(init_f)

import shutil
from twisted.spread import pb
from twisted.internet import reactor, threads

import win32api as wa
import win32con as wc
import ntsecuritycon as ntsec

import logging

from eole import reg
from eole.vnc import Vnc
from eole.log import LOGON_LOG
from eole.os_type import type_os
from eole.perms import set_acl, AdjustPrivilege
from eole.process import killProcName
from eole.lance_cmd import lancecmd
from eole.replace_win_vars import convert
from eole import lecteur
from eole import logon_service
from eole import versioneole

from eole.pbgest import CliPB
C = CliPB()
getrootobject, disconnect = C.getrootobject, C.disconnect


# utilisation du reacteur Windoz
reactortype = "win32"

# dfinition du service
nom = "servscribe"
libelle = "Service Scribe"
version = versioneole.CLISCRIBE_VERSION


class servFactory(pb.PBServerFactory):
    def buildProtocol(self, addr):
        #il s'agit d'une liste, il faut faire un "eval"
        if str(addr.host) not in option.get_ip_access_list():
            logging.error('Connexion non autorisee de %s'%addr.host)
            return None
        return pb.PBServerFactory.buildProtocol(self, addr)

class Echoer(pb.Root):
    """Classe contenant toutes les fonctions distantes
       que le serveur Scribe peut appeler
    """

    def __init__(self, parent):
        """initialisation de la classe PB qui coute sur le port 8788
        """
#        self.log = parent.log
        self.serveur = parent.serveur
        self.nom_scribe = option.get_nom_scribe()
        self.user_port = int(option.get_port_utilisateur())
        # repertoire d'installation
        self.inst_path = option.get_inst_path()
        # repertoire d'installation vnc
        self.vnc_path = os.path.join(self.inst_path, 'ultravnc')
        # Variables d'environnement
        self.tmpdir = parent.tmpdir
        self.windir = parent.windir
        self.vnc = Vnc(self.vnc_path)
        self.nodrives, self.noview = None, None
        AdjustPrivilege([ntsec.SE_SHUTDOWN_NAME, ntsec.SE_BACKUP_NAME])

    #######################
    # Fonctions distantes #
    #######################
    def remote_bonjour(self, old=""):
        """fonction de test, old sert  pouvoir passer un argument supplmentaire (utilisation dans un callback)
        """
        logging.info("Appel de la fonction remote_bonjour, old=%s"%old)
        return "** %s %s **"%(libelle, version)


    def remote_logon(self, logon_dict):
        """fonction appele lors de l'ouverture de session
        """
        e = logon_dict['esu_dict']
        msg = 'User=%s, ESU_GU=%s, Machine=%s, ESU_GM=%s'%(e['USERNAME'], e['ESU_GU'], wa.GetComputerName(), e['ESU_GM'])
        logging.info("""
############# SESSION #############""") # pour la lecture
        logging.info('Ouverture de session %s'%msg)
        return logon_service.logon(logon_dict, self.inst_path, self.nom_scribe)

    def remote_regedit(self, reg_liste):
        """Fonction appliquant les cls de registres dfinies dans regliste
           regliste = [{'type_variable' : CHAINE/DWORD, 'chemin' : y, 'variable' : z, 'valeur' : }, ...]
           EX. : reg_liste = { hkey : 'HKEY_...', <=  valer
                              keypath : 'Software\\Eole',
                              keyname : 'test_key',
                              keytype : 'REG_DWORD, <=  valer
                              value : 'SUPPR'} <= supprime la cl
        """
        logging.info('Appel de la fonction remote_regedit "%s"'%reg_liste)
        try: return reg.put_regs(reg_liste)
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

    def remote_execute(self, command, hide=False, nowait=True, waitinput=False, user=False):
        """excution  distance d'une ou d'une liste de commande(s)
        hide = cache, nowait = n'attend pas la sortie,
        waitinput = attend que le programme attende une entre (notepad par ex.)
        user = lancer la commande dans l'environnement utilisateur
        """
        # replacer WINDIR par self.windir
        logging.debug('Commande = %s'%command)
        try:
            if type(command) == str or type(command) == unicode: command = [command]
            if user:
                d = getrootobject(ip='127.0.0.1', port=option.get_port_utilisateur())
                d.addCallback(lambda object: object.callRemote('execute', command, hide, nowait, waitinput))
                disconnect()
                return d
            command = convert(command)
            for cmd in command:
##                Ne fonctionne pas quand il y a des arguments
##                if not os.path.isfile(cmd):
##                    logging.error('Fichier "%s" introuvable'%cmd)
##                    continue
                logging.info('Execution distante de : "%s"'%cmd)
                with win32_64.disable_file_system_redirection():
                    ret = lancecmd(cmd, hide, nowait, waitinput)
                logging.debug('Code retour : %s'%ret)
            return True
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

    def remote_killproc(self, progname):
        """Tue le programme progname
        """
        logging.info('Appel de la fonction remote_killproc "%s"'%progname)
        try: return killProcName(progname)
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())


    def remote_winvnc(self, action, val=None, conf=None, restart=False):
        """gestion VNC, actions possibles:
            - start_listen  - connect
            - stop              - stop_listen   - disconnect
            - setinputs (gestion clavier/souris)
        """
        logging.info('Appel de la fonction remote_winvnc "%s"; val="%s" ; conf="%s"; restart="%s"'%(action, val, conf, restart))
        d = None
        try:
            if action.lower() == 'start': d = self.vnc.start()
            elif action.lower() == 'stop': d = self.vnc.stop()
            elif action.lower() == 'connect': d = self.vnc.connect(val)
            elif action.lower() == 'disconnect': d = self.vnc.disconnect()
            elif action.lower() == 'start_listen': d = self.vnc.start_listen(val, conf)
            elif action.lower() == 'stop_listen': d = self.vnc.stop_listen()
            elif action.lower() == 'setinputs': d = self.vnc.setinputs(val, restart)
            elif action.lower() == 'set_type': d = self.vnc.set_type(val)
            else : logging.error('Action "%s" inconue'%action.lower())
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())
        logging.debug('Action %s terminee'%action)
        return d


    def remote_shutdown(self, reboot=0, force=True):
        """Extinction distante 0=teindre, 1=reboot, 2=fermeture de session
        """
        logging.info('Appel de la fonction remote_shutdown "(reboot=%s, force=%s)"'%(reboot, force))
        #modification des privilges
        try:
            if int(reboot) == 2:
                return logon_service.logoff_user(force)
            elif int(reboot) == 0:
                opts = wc.EWX_POWEROFF
            elif int(reboot) == 1:
                opts = wc.EWX_REBOOT
            if force:
                opts = opts | wc.EWX_FORCE
            wa.ExitWindowsEx(opts, 0)
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())
        return True

    def remote_fw(self, cmd):
        """
        * INIT
        * ADD|DEL:rule
        rule='Nom;; ip_src=AA;; ip_dst=BB;; action=CC;; proto=DD;; port_dst=EE;; program=FF'
            ip_src/dst = me|any|<ip>
            action=allow|block
            proto=tcp|udp|icmp|any
        * SETMODE:in=allow|block;;out=allow|block
        * ACTIVATE:True|False
        """
        logging.debug('cmd=%s'%cmd)
        if type(cmd) == str or type(cmd) == unicode: cmd = [cmd]
        # Creation d'un obj Rule  partir de la commande
        try:
            for c in cmd:
                action = c.split('::')[0].strip()
                if action == 'INIT':
                    fw.init_fw()
                else: rule = c.split('::')[1].strip()
                if action == 'ADD':
                    fw.addrule(rule)
                if action == 'DEL':
                    fw.delrule(rule)
                if action == 'SETMODE':
                    inputfw = rule.split(';;')[0].strip()
                    outputfw = rule.split(';;')[1].strip()
                    fw.setmode(inputfw, outputfw)
                if action == 'ACTIVATE':
                    activate = eval(rule.strip().capitalize())
                    fw.activate(activate)
            return True
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

    def remote_bloc(self, partmod, sid, logon=False):
        """Blocage de poste, mode partage (blocage internet fait par remote_execute(ipfw ...)
        connexion  utilisateur.exe qui va monter \\scribe\perso\devoirs et redmarrer explorer.exe
        pour prendre en compte les modif regedit.
        partmod = (1, [liste de lettres  NE PAS masquer: 'a','b','c',...])
        partmod = {masquelettre = None/[...],
                   mount_dev = True/False,
                  }
        """
        logging.info(u'Appel de la fonction remote_bloc : partmod=%s, sid=%s, logon=%s'%(partmod, sid, logon))
        try:
            d = getrootobject(ip='127.0.0.1', port=self.user_port)
            if int(partmod[0]) == 3: #masque lecteurs et monte "devoirs"
                self.mask_part(sid, logon=logon, nohide=partmod[1])
                d.addCallback(lambda object: object.callRemote("mount_devoir"))
            elif int(partmod[0]) == 2: #masque lecteurs et NE monte PAS "devoirs" (le dmonte si besoin)
                self.mask_part(sid, logon=logon, nohide=partmod[1])
                d.addCallback(lambda object: object.callRemote("umount_devoir"))
            elif int(partmod[0]) == 1: #mode normal + "devoirs"
                self.mask_part(sid, logon=logon, unmask=True)
                d.addCallback(lambda object: object.callRemote("mount_devoir"))
            elif int(partmod[0]) == 0: #mode normal
                self.mask_part(sid, unmask=True, logon=logon)
                d.addCallback(lambda object: object.callRemote("umount_devoir"))
            if not logon:
                d = getrootobject(ip='127.0.0.1', port=self.user_port)
                d.addCallback(lambda object: object.callRemote("restart_explorer"))
            d.addCallback(disconnect)
            return d
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())


    ######################
    # Fonctions internes #
    ######################
    def mask_part(self, sid, unmask=False, logon=False, nohide=None):
        """Masque tous les lecteurs sauf Y:"devoir" 50331647
        Exemple : nohide = ['a', 'b', 'g', 'u']
        """
        kpath = r'%s\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer'%sid
        try: nodrives = int(reg.get_option(kpath, 'NoDrives', 'HKEY_USERS'))
        except: nodrives = 0
        try: noview = int(reg.get_option(kpath, 'NoViewOnDrive', 'HKEY_USERS'))
        except: noview = 0
        logging.debug('self.nodrives=%s, self.noview=%s, unmask=%s, logon=%s, nodrives=%s, noview=%s, nohide=%s'%
                     (self.nodrives, self.noview, unmask, logon, nodrives, noview, nohide))
        # sauvegarde le configuration d'origine des lecteurs
        if logon: self.nodrives, self.noview = nodrives, noview
        if unmask: # dsactivation
            if self.nodrives is not None: nodrives, noview = self.nodrives, self.noview
        else: # activation mode devoir
            try:
                nohide.append('y')
                nohide = lecteur.gen_inv_nb(nohide)
            except: nohide = 50331647
            nodrives, noview = nohide, nohide
        logging.debug('self.nodrives=%s, self.noview=%s, nodrives=%s, noview=%s, nohide=%s'%(self.nodrives, self.noview, nodrives, noview, nohide))
        reg.addreg('HKEY_USERS', kpath, reg._winreg.REG_DWORD, 'NoDrives', nodrives)
        reg.addreg('HKEY_USERS', kpath, reg._winreg.REG_DWORD, 'NoViewOnDrive', noview)
        return True

class gestServ:
    def __init__(self, installSignalHandlers=0, parent=None):
        self.installSignalHandlers = installSignalHandlers
        self.parent = parent
        # l'adresse du Scribe
        self.serveur = option.get_ip_scribe()
        self.serveur_port = int(option.get_port_scribe())
        self.port = int(option.get_port_client())
        self.scribe_dom = option.get_nom_domaine().lower()
        self.scribe_name = option.get_nom_scribe().lower()
        # Variables d'environnement
        self.tmpdir = os.path.join(os.environ['TEMP'], 'Eole')
        init_tmpdir(self.tmpdir)
        self.windir = os.environ['WINDIR']
        self.ip, self.mac = None, None
        try:
            tmout = option.get_network_timeout()
            if tmout: tmout = int(tmout)
            else: tmout  = 30
            if tmout < 1: raise Exception('network_timeout doit tre suprieur ou gal  "1"')
        except Exception, e:
            logging.error(e)
            tmout = 30
        logging.info('Network timeout %s'%tmout)
        for i in range(tmout):
            try:
                self.ip, self.mac = iphelp.get_route_ip(self.serveur)
                break
            except Exception, e:
                logging.debug('Essai %s'%(i+1))
                if i == (tmout - 1):
                    logging.error(e)
                    logging.debug('Erreur : %s'%traceback.format_exc())
                    self.ip, self.mac = None, None
                time.sleep(1) # attendre

    #Fonctions de dmarrage et d'arrt du service
    def servstart(self):
        # affichage du dmarrage
        computer_name = wa.GetComputerName()
        logging.info("Le service Scribe demarre : ip Scribe=%s ; port Scribe=%s ; port local=%s ; windir=%s ; tmpdir=%s ; poste=%s ; os=%s ; ip=%s ; MAC=%s ; version=%s"
                                                %(self.serveur, self.serveur_port, self.port, self.windir, self.tmpdir, computer_name, type_os, self.ip, self.mac, version))

        # Donner les droits d'criture  tout le monde sur LOGON_LOG
        try:
            if not os.path.isfile(LOGON_LOG): file(LOGON_LOG, 'w').write('')
            b = threads.deferToThread(set_acl, LOGON_LOG, self.scribe_dom, self.scribe_name)
        except: pass
##        c = threads.deferToThread(init_fw)
        # Initialisation du parefeu
        init_fw()
        # r-crire les cls indispensables
        force_reg()
        d = self.call_service_start(computer_name, type_os, self.mac)
        #dmarrage du serveur local quelque soit la rponse du callRemote
        d.addErrback(self.servlisten)
        d.addCallback(self.servlisten)
        reactor.run(installSignalHandlers=self.installSignalHandlers)

    def servlisten(self, retval):
        logging.info('retval : %s'%retval)
        try: nbtstat(self.serveur) # recherche du domaine
        except Exception, e:
            logging.error('%s'%e)
        # chargement des menus par dfaut
        try: reg.load_default_menus()
        except Exception, e:
            logging.error('%s'%e)
        # Dire que le service est dmarr
        if self.parent: self.parent.IsStarted()
        fac = servFactory(Echoer(self), unsafeTracebacks=True)
        reactor.listenTCP(self.port, fac)

    def call_service_start(self, computer_name, type_os, mac):
        # relancer l'appel dans 10 minutes
        self.call_later_id = reactor.callLater(600, self.call_service_start, computer_name, type_os, mac)
        # connection au serveur
        d = getrootobject()
        #appel  la mthode "remote_service_start"
        # (enregistrement de la station comme allume)
        d.addCallback(lambda object: object.callRemote("service_start", computer_name, type_os, mac))
        d.addCallbacks(disconnect, disconnect)
        return d


    def servstop(self):
        """Fonction d'arrt du service Scribe
        """
        # annulation du CallLater
        self.call_later_id.cancel()
        # remise  l'origine des menu dmarrer et bureau communs
        # pour l'ouverture de sessions locales
        reg.load_default_menus()
        # connection au serveur
        factory = pb.PBClientFactory()
        reactor.connectTCP(self.serveur, 8789, factory)
        d = factory.getRootObject()
        #appel  la mthode "remote_service_stop"
        d.addCallback(lambda object: object.callRemote("service_stop"))
        #arrt du racteur  la rponse
        d.addErrback(lambda _: reactor.stop())
        d.addCallback(lambda _: reactor.stop())

def nbtstat(ip):
    cmd = 'nbtstat -R'
    with win32_64.disable_file_system_redirection():
        lancecmd(cmd, nowait=False, hide=True)
    cmd = 'nbtstat -A %s'%ip
    with win32_64.disable_file_system_redirection():
        lancecmd(cmd, nowait=False, hide=True)

def init_tmpdir(tmpdir):
    """supprime self.tmpdir s'il existe
    le re-cre
    """
    if os.path.exists(tmpdir):
        shutil.rmtree(tmpdir)
    os.makedirs(tmpdir)

def force_reg():
    """re-Applique les cls ncessaire au bon fonctionnement
    au dmarrage du service
    """
    # Dsactiver le Fast User switching sous vista
    if type_os == 'Vista':
        reg.addreg('HKEY_LOCAL_MACHINE', r'Software\Microsoft\Windows\CurrentVersion\Policies\System', 'REG_DWORD', 'HideFastUserSwitching', '1')
    #R-cris la cl HKLM\Soft\Micro\Win NT\Winlogon:Userinit
    exe = '%s\cliscribe\logon.exe,'%option.get_inst_path()
    reg.addreg('HKEY_LOCAL_MACHINE', r'SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon', 'REG_SZ', 'Userinit', exe)
    reg.addreg('HKEY_LOCAL_MACHINE', r'SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon', 'REG_DWORD', 'SyncForegroundPolicy', '1')
    reg.addreg('HKEY_LOCAL_MACHINE', r'SOFTWARE\Policies\Microsoft\Windows NT\CurrentVersion\Winlogon', 'REG_DWORD', 'SyncForegroundPolicy', '1')

