# _*_ coding: iso-8859-1 _*_
#!/usr/bin/env python

import sys
from eole import option
# ne pas gnrer de *.exe.log
if option.get_log_level() > 10:
    sys.stderr = sys.stdout

# lorsque compile en .exe les accents posent probleme
if hasattr(sys, 'setdefaultencoding'):
    import locale
    loc = locale.getdefaultlocale()
    if loc[1]:
        encoding = loc[1]
        sys.setdefaultencoding(encoding)

import os, time, logging, traceback

from twisted.spread import pb
from twisted.internet import reactor

import win32api as wa
import win32gui
import win32con
import win32security as ws

from eole.replace_win_vars import convert
from eole.lance_cmd import lancecmd
from eole.process import killProcName, isrunning
from eole.lecteur import connect, disconnect
from eole.reg import get_option
from eole.vncuser import VncUser
from eole import win32_64

from eole import logon_user
from eole import log

class servFactory(pb.PBServerFactory):
    def buildProtocol(self, addr):
        #il s'agit d'une liste, il faut faire un "eval"
        ip_list = option.get_ip_access_list()
        ip_list.append('127.0.0.1')
        if str(addr.host) not in ip_list:
            logging.info('Connexion non autorisee de "%s"'%addr.host)
            return None
        return pb.PBServerFactory.buildProtocol(self, addr)

class Echoer(pb.Root):
    def __init__(self):
        self.username = wa.GetUserName()
        self.sid = getsid(self.username)
        # repertoire d'installation vnc
        self.vnc_path = os.path.join(option.get_inst_path(), 'ultravnc')
        self.vncuser = VncUser(self.vnc_path)

    def remote_uservnc(self, action, val=None):
        """gestion VNC, actions possibles:
            - start_listen / stop_listen
            - connect / disconnect
        """
        logging.info('"%s"; val="%s"'%(action, val))
        try:
            if action.lower() == 'start': self.vncuser.start()
            if action.lower() == 'stop': self.vncuser.stop()
            if action.lower() == 'connect': self.vncuser.connect(ip=val)
            if action.lower() == 'disconnect': self.vncuser.disconnect()
            if action.lower() == 'start_listen': self.vncuser.start_listen(args=val)
            if action.lower() == 'stop_listen': self.vncuser.stop_listen()
            logging.debug('Action %s terminee'%action)
            return True
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

    def remote_get_env_vars(self):
        logging.info("Recuperation des variables d'environnement")
        env = os.environ.copy()
        # Hack pour windows 2000 qui ne trouve pas la variable
        # %appdata%  l'ouverture de session ...
        if not env.has_key('APPDATA'):
            env['APPDATA'] = get_option(r'Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders',
                                         'AppData', 'HKEY_CURRENT_USER')
        return env

    def remote_execute(self, cmd, hide=False, nowait=False, waitinput=False):
        try:
            if type(cmd) == str or type(cmd) == unicode: cmd = [cmd]
            cmd = convert(cmd)
            for c in cmd:
                if not os.path.isfile(c):
                    logging.error('Fichier "%s" introuvable'%c)
                    continue
                with win32_64.disable_file_system_redirection():
                    ret = lancecmd(c, hide, nowait, waitinput)
                logging.info('Execution distante de : "%s", code retour : %s'%(c, ret))
            return True
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

    def remote_restart_explorer(self):
        """redemarre explorer.exe
        sous XP un kill provoque (en principe) une relance automatique
        """
        logging.info('Redemarrage explorer.exe')
        try:
            if isrunning('explorer.exe'):
                killProcName('explorer.exe')
                time.sleep(3)
                if not isrunning('explorer.exe'):
                    wa.WinExec('explorer.exe')
            # laisser le temps au bureau de s'afficher avant
            # de le rafraichir sinon a ne fonctionne pas a tous les coups
            reactor.callLater(20, self.update_env)
            return True
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

    
    def update_env(self):
        """R-actualise le fond du bureau
        """
        win32gui.SendMessageTimeout(win32con.HWND_BROADCAST, win32con.WM_SETTINGCHANGE,
                                    0, "Environment", win32con.SMTO_ABORTIFHUNG, 5000)
        return wa.WinExec('rundll32 user32,UpdatePerUserSystemParameters ,1 ,True')
        
    def remote_mount_devoir(self): #, partage):
        """Monte le partage \\scribe\devoirs
        """
        logging.info('Montage du partage "devoirs"')
        try:
            partage = r'\\%s\devoirs'%(option.get_nom_scribe())
            #if not os.path.exists(partage): os.makedirs(partage)
            connect('Y:', partage)
            return True
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

    def remote_umount_devoir(self): #, partage):
        """demonte Y:
        """
        logging.info('Demontage de Y:')
        try: return disconnect('Y:')
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

    def remote_logoff(self, force=True):
        opts = win32con.EWX_LOGOFF
        if force:
            opts = opts | win32con.EWX_FORCE
        try:
            logging.info("Deconnexion de l'utilisateur (force=%s)"%force)
            return wa.ExitWindowsEx(opts, 0)
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())
        
    def remote_logon(self, esu_dict, user_dict):
        """fonction appele lors de l'ouverture de session
        """
        logging.info('Appel de la fonction remote_logon')
        try:
            logon_user.logon(esu_dict, user_dict)
            reactor.callLater(10, self.update_env)
            return True
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())

def getsid(user):
    return ws.ConvertSidToStringSid(ws.LookupAccountName(None, user)[0])
    
def lance():
    try:
        killProcName('utilisateur.exe', own=False)
        # attendre que le port se libre
        time.sleep(2)
    except: pass
    logger = log.utilisateur_log()
    # le serveur en coute
    port = int(option.get_port_utilisateur())
    fac = servFactory(Echoer(), unsafeTracebacks=True)
#    logging.info('Demarrage de utilisateur.exe')
    logger.info('Demarrage de utilisateur.exe')
    reactor.listenTCP(port, fac)

def main():
    lance()
    reactor.run()
    
if __name__ == '__main__':
    main()
