# -*- coding: utf-8 -*-

"""Fonctions relatives à l’ajustement du partitionnement au moment de l’instance
"""


def calc_free_PE(mode_zephir='non'):
    if mode_zephir == 'non':
        from pyeole.process import system_out
        try:
            cmd = ['vgs', '-o', 'vg_free_count', '--noheadings']
            _, vg_free_pe, _ = system_out(cmd)
            return int(vg_free_pe)
        except (OSError, ValueError):
            return 0
    else:
        return 0


def check_free_space(value, values):
    if None not in values:
        if sum(values) > 100:
            raise ValueError(u'Percentage sum exceeds 100: {}'.format(sum(values)))


def is_lv_name(data, mode_zephir='non'):
    if mode_zephir == 'non':
        from pyeole.process import system_out
        cmd = ['lvs', '-o', 'lv_name', '--noheadings']
        _, lv_names, _ = system_out(cmd)
        lv_names = lv_names.split()
        if data not in lv_names:
            raise ValueError(u'Les lv dispos sont: {}'.format(', '.join(lv_names)))
    else:
        from warnings import warn_explicit
        from tiramisu.error import ValueWarning
        warn_explicit(ValueWarning(u'Impossible de vérifier l’existence du volume logique en mode Zéphir', None),
                      ValueWarning,
                      'is_lv_name',
                      0)


def is_fs_type(data, mode_zephir='non'):
    if mode_zephir == 'non':
        import re
        from pyeole.process import system_out
        mkfs_cmds = re.compile(r'mkfs\.(.*)')
        cmd = ['ls', '/sbin/']
        _, cmds, _ = system_out(cmd)
        fs_types = mkfs_cmds.findall(cmds)
        if data not in fs_types:
            raise ValueError(u'Les fs supportés sont : {}'.format(', '.join(fs_types)))
    else:
        from warnings import warn_explicit
        from tiramisu.error import ValueWarning
        warn_explicit(ValueWarning(u'Impossible de vérifier si le système de fichiers est supporté en mode Zéphir', None),
                      ValueWarning,
                      'is_fs_type',
                      0)


def enable_lv_creation(mode_zephir='non'):
    if mode_zephir == 'non':
        import os
        minimum_PE = 100
        free_PE = calc_free_PE()
        is_instanciated = os.path.isfile('/etc/eole/.instance')
        if free_PE < minimum_PE or is_instanciated:
            return u'non'
        elif free_PE > minimum_PE and not is_instanciated:
            return u'oui'
    else:
        return 'oui'
