#!/usr/bin/python

import os
import sys
# Workarround creole in LXC
if os.path.isdir('/usr/share/eole/fichier/creole'):
    sys.path.append('/usr/share/eole/fichier')

from creole import parsedico
from pyeole.debsums import EoleDebsumsReport
from pyeole.debsums import NoEoleDebsumsReportError
from pyeole.debsums import EoleDebsumsReportParseError

from datetime import datetime

REPORT_FILE = 'var/log/eole-debsums/report.log'
LXC_ROOTDIR = '/opt/lxc'

def main():
    """
    Aggregate reports of all containers and print it on stdout.
    """
    d = parsedico.parse_dico()
    report_files = [ ('root', os.path.join('/', REPORT_FILE)) ]
    if 'mode_conteneur_actif' in d and d['mode_conteneur_actif'] == 'oui' \
            and os.path.isdir(LXC_ROOTDIR):
        for entry in sorted(os.listdir(LXC_ROOTDIR)):
            lxc_path = os.path.join(LXC_ROOTDIR, entry)
            if os.path.isdir(lxc_path):
                report_files.append( (entry, os.path.join(lxc_path, 'rootfs', REPORT_FILE)) )

    for r in report_files:
        container = r[0]
        filename = r[1]
        header = """Container: {0}""".format(container)
        print header
        print "=" * len(header)
        try:
            m_date = datetime.fromtimestamp( os.stat(filename).st_mtime )
            print "\nFilename: {0}".format(filename)
            print "Last update: {0}\n".format(m_date.strftime('%Y-%m-%d %H:%M:%S'))
            report = EoleDebsumsReport(filename=filename)
            for pkg in report:
                print "{0}:".format(pkg)
                for filename in report[pkg]:
                    print " " * 4 + filename
                print ''
        except (OSError, NoEoleDebsumsReportError, EoleDebsumsReportParseError), e:
            print "\n{0}\n".format(e)

if __name__ == "__main__":
    sys.exit(main())
