#!/bin/bash

set -e

DEBSUMS=/usr/bin/debsums
IGNORE_D=/etc/eole/debsums-ignore.d

LOGDIR=/var/log/eole-debsums
COMPLETE_LIST=${LOGDIR}/all.log
LOGFILE=${LOGDIR}/debsums.log
REPORT=${LOGDIR}/report.log

LOGROTATE=logrotate
ROTATECONF=/etc/logrotate.d/eole-debsums

DPKG=/usr/bin/dpkg

unset LANG LC_MESSAGES
export LANG=C 

test -x $DEBSUMS || exit 127
test -x $DPKG || exit 127

test -d "${LOGDIR}" || mkdir -p ${LOGDIR}

die() { echo "$@"; exit 1; }

if [ -s "${LOGFILE}" ] || [ -s "${REPORT}" ]
then
    test -x ${LOGROTATE} && test -f ${ROTATECONF} && ${LOGROTATE} -f ${ROTATECONF}
    echo -n > ${LOGFILE}
    echo -n > ${REPORT}
    rm -f ${LOGDIR}/*.ignored
fi

# See ionice(1)
if [ -x /usr/bin/ionice ] &&
    /usr/bin/ionice -c3 true 2>/dev/null; then
    IONICE="/usr/bin/ionice -c3"
fi

echo "List modified files…"
$IONICE $DEBSUMS -c > "${COMPLETE_LIST}" 2>&1 || true

TEMPFILE=$(mktemp -t eole-debsums-XXXXXX)

if [ ! -w "${TEMPFILE}" ]
then
    echo "Unable to write to ${TEMPFILE}"
    exit 1
fi

touch "${REPORT}"

cp "${COMPLETE_LIST}" "${LOGFILE}"
for ignore_file in ${IGNORE_D}/*.conf
do
    echo "Filter files listed by ${ignore_file}…"

    grep -v -f "${ignore_file}" -e 'no md5sums' "${LOGFILE}" > "${TEMPFILE}" || true

    # Do not stop if nothing happen
    IGNORED_F="${LOGDIR}/$(basename -s .conf ${ignore_file}).ignored"
    grep -f "${ignore_file}" "${COMPLETE_LIST}" > "${IGNORED_F}" || true

    cp "${TEMPFILE}" "${LOGFILE}"
done

while read line
do
    if echo "${line}" | grep -q '^debsums: missing file'
    then
        line=$(echo "${line}" | cut -d' ' -f4)
    fi
    dpkg -S ${line} | tee -a ${REPORT}
done < ${LOGFILE}

for ignored_list in ${LOGDIR}/*.ignored
do
    TEMPFILE=$(mktemp -t eole-debsums-XXXXXX)

    while read line
    do
        if echo "${line}" | grep -q '^debsums: missing file'
        then
            line=$(echo "${line}" | cut -d' ' -f4)
        fi
        dpkg -S ${line} >> "${TEMPFILE}"
    done < ${ignored_list}

    mv "${TEMPFILE}" "${ignored_list}"
done

rm -f ${TEMPFILE}
exit 0
