# coding: utf-8
from json import dumps as _dumps, loads as _loads
from os.path import isfile as _isfile
from csv import reader as _reader
import ipaddress as _ipaddress
from creole.loader import creole_loader as _creole_loader

try:
    from .action import submit as _submit
    from ..dhcp import upsert_reserved as _upsert_reserved, get_subnets as _get_subnets
except:
    # Test mode (see test_conversion)
    from generic_form import submit as _submit

# EAD2 DHCP reservation file ('#' separated csv format)
_EAD_DHCP = "/var/lib/eole/config/dhcp.conf"


def _convert_ead2_ead3(res):
    if res["message"]["type"] == "info" and _isfile(_EAD_DHCP):
        reserved = []
        with open(_EAD_DHCP, 'r') as csvfile:
            resa = _reader(csvfile, delimiter='#')
            for row in resa:
                # Replace IP inside a named range by the name of the range
                ip_or_range = _replace_ip_by_rangename(row[1])
                resv = dict(hostname=row[0], macaddress=row[2])
                resv.update(ip_or_range)
                reserved.append(resv)

        # salt-call ead.dhcp_upsert_reserved --output=json reserved="<reserved>" save_when_error="True"
        # upsert_reserved(reserved, hosts_range=None, prefix=None, save_when_error=False, del_reservations=False, *args, **kwargs)
        res2 = _upsert_reserved(reserved, save_when_error=True, del_reservations=True)
        # FIXME : prendre en compte les retours d'erreurs

def _replace_ip_by_rangename(ip_to_test):
    try:
        ipaddr = _ipaddress.ip_address(ip_to_test)
    except:
        return dict(ip=ip_to_test)
    subnets = _get_subnets()["subnets"]
    for subnet in subnets:
        for ip_range in subnet["ranges"]:
            if ip_range["restricted"] or ip_range["static"]:
                if _validate_iprange(ipaddr, ip_range["low"], ip_range["high"]):
                    return dict(rangename=ip_range["name"])
    return dict(ip=ip_to_test)

def submit(*args, **kwargs):
    # Convert and add EAD2 reservation in EAD3
    #~ _dumps({'message': {'type': 'error', 'text': 'La tâche de redémarrage déjà planifiée est incompatible.'}}).encode()

    res = _loads(_submit(*args, **kwargs))
    #{"message": {"text": "Les modifications sont appliqu\u00e9es", "type": "info"}, "updates": []}
    cfg = _creole_loader(load_extra=True)
    if cfg.dhcpactivation.dhcp_activation.dhcp_activation_ead3 == "oui":
        _convert_ead2_ead3(res)

    return _dumps(res).encode()

def _validate_iprange(ipaddr, startip, endip):
    """range ip calculation with _ipaddress
    """
    startip = _ipaddress.IPv4Address(startip)
    endip = _ipaddress.IPv4Address(endip)
    for iprange in _ipaddress.summarize_address_range(startip, endip + 1):
        if ipaddr == iprange.network_address:
            return True
    return False
