# -*- coding: utf-8 -*-

from ConfigParser import ConfigParser
from os.path import isfile
from pyeole.service import manage_services as pyeolemanage, ServiceError

CONFIG_FILE = '/var/lib/eole/config/ead3.cfg'
ALL_LABEL = 'Tous'

def load_services():
    if not isfile(CONFIG_FILE):
        return {'message': {'text': 'Fichier de config introuvable', 'type': 'error'}}
    
    cfg = ConfigParser(allow_no_value=True)
    cfg.read(CONFIG_FILE)
    services_name = cfg.get('eole', 'services_name').split()
    services_container = cfg.get('eole', 'services_container').split()
    services_warn = cfg.get('eole', 'services_warn').split()            # Services that make an alert on reboot/stop
    services_non_stop = cfg.get('eole', 'services_non_stop').split()    # Services that can not be stopped
    datas = {}
    for i, serv in enumerate(services_name):
        datas[services_name[i]] = {"name": services_name[i], "container": services_container[i], "nonstop": (services_name[i] in services_non_stop), "warning": (services_name[i] in services_warn)}
    return datas

def service_action(service, container, action):
    """
    effectue l'action (stop/restart) pour un service
    """
    try:
        pyeolemanage(action, service, container=container)
    except ServiceError:
        return 1
    return 0

def get_services(*args, **kwargs):
    serv_list = load_services().values()
    sorted(serv_list, key=lambda k: k['name'])
    serv_list.insert(0, {"name": ALL_LABEL, "container": "root", "nonstop": True, "warning": True})
    return serv_list

def manage_service(*args, **kwargs):
    service = kwargs['service_name']
    action = kwargs['action_type']
    if service == ALL_LABEL:
        cfg = ConfigParser(allow_no_value=True)
        cfg.read(CONFIG_FILE)
        services_excluded = cfg.get('eole', 'services_excluded').split()    # Services that can not be restarted with all others
        datas = load_services()

        try:
            #Format supported : pyeolemanage('restart', exclude=(('root', 'network'), ('root', 'ead-server'), ('root', 'ead-web')))
            pyeolemanage('restart', exclude=tuple((datas.get(serv,{}).get('container', 'root'), serv) for serv in services_excluded))
            #~ exclude = tuple((datas.get(serv,{}).get('container', 'root'), serv) for serv in services_excluded)
            #~ return {'message': {'text': 'Exclude : {}'.format(exclude), 'type': 'error'}}
        except ServiceError:
            return 1
        return 0
        
    else:
        try:
            datas = load_services()[service]
        except KeyError:
            return {'message': {'text': 'Unkown service : {}'.format(service), 'type': 'error'}}

        if service_action(service, datas["container"], action) > 0:
            return {'message': {'text': 'Error for service {0} ({1})'.format(service, action), 'type': 'error'}}
        else:
            txt = "redémarré" if action=="restart" else "stoppé"
            return {'message': {'text': 'Service {0} {1}'.format(service, txt), 'type': action}}

__all__ = ('manage_service', 'get_services')
