<?php
/*---------------------------------------------------------------
		ecoStations.php
-----------------------------------------------------------------
	
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon   
---------------------------------------------------------------*/
include ('./inc/f_session_scribe.inc.php');
//initialisation de la Session et recup de l'uid
recupUid();

//verifie si l'utilisateur connecté est du login ou du groupe mis dans la liste (ELEVES, PROFS, etc...)
verifAccesPage("admin");

include ('./inc/f_scribe.inc.php');
include ('./inc/f_ldap_scribe.inc.php');

$titrePage="EcoStations";

$ficConf='config/confEcoStations.inc.php';
$ficL1='config/liste1.txt';
$ficL2='config/liste2.txt';
$ficEcoStations='config/ecoStations.txt';

include ('./f_ecoStations.inc.php');


//----------------- fonctions à prévoir de déplacer dans f_ecoStations.inc.php une fois au point !!! --------
//...

//print_r($_POST);
//------------------- Controler ----------------------
$compoGrp=false;
$msgErreur='';
$mode='rien';
$onglet='tab-hor1';
$ligneCron="";

if (isset($_POST['savHor'])) {
	$mode='sauveHor';
} else if (isset($_POST['savListe1'])) {
	$mode='sauveL1';
} else if (isset($_POST['savListe2'])) {
	$mode='sauveL2';
}

//---------------------------------- Module ---------------------------------------------------

if (!file_exists($ficConf)) ecritConfHoraires('20:00','22:00');
include ($ficConf);

//choix de l'action
switch ($mode) {
	//sauve les horaires
	case 'sauveHor': 
		//echo "sauveHoraires";
		$valRet=verifHoraires($_POST['hor1'],$_POST['hor2']);
		if (is_array($valRet)) { //pas d'erreurs ! on peut enregistrer.
			$msgErreur="";
			ecritConfHoraires($valRet[0],$valRet[1]);
			include ($ficConf);
			ecritFicEcoStations($horaire1,$horaire2,litListe($ficL1),litListe($ficL2));
//			$ligneCron=ecritLigneCron($horaire1,$horaire2);
			lanceModifCron();
		} else $msgErreur=$valRet;
		//if ($msgErreur=="") ecritConfHoraires($_POST['hor1'],$_POST['hor2']);
		$onglet="tab-conf";
		break;
	//modif d'un groupe	
	case 'sauveL1':
		sauveListe($_POST['liste1'],$ficL1);
		ecritFicEcoStations($horaire1,$horaire2,litListe($ficL1),litListe($ficL2));
		lanceModifCron();
		$onglet="tab-hor1";
		break;
	case 'sauveL2':
		sauveListe($_POST['liste2'],$ficL2);
		ecritFicEcoStations($horaire1,$horaire2,litListe($ficL1),litListe($ficL2));
		lanceModifCron();
		$onglet="tab-hor2";
		break;
}



$tabH_Grp=new tableau_HTML(5,2);
$tab=array("nom","détails","nb de<br/>machines","modifier","supprimer"); 
$tabH_Grp->ajoute1Ligne($tab);

if (count($tGrp)>0) { //il y a des groupes
	foreach($tGrp as $_tGrp) {
		$tabH_Grp->ajoute1Ligne(array('<span id="nom_'.$_tGrp['id'].'">'.$_tGrp['nom'].'</span>',$_tGrp['details'],($_tGrp['nb']>0?$_tGrp['nb']:'0'),'<a href="?modifG='.$_tGrp['id'].'">modif</a>','<span id="suppr_'.$_tGrp['id'].'" class="lienSuppr">suppr</span>')); //'<a href="?suppG='.$_tGrp['id'].'">suppr</a>'
	}
	$pageGrp=$tabH_Grp->rendu();
} else { //pas de groupes
	$pageGrp="Aucun groupe de machines défini...";
}

//------------------- View -------------------------
headerPage();
enteteHTML($titrePage,array("./jquery/js/jquery-1.7.1.min.js",
														"./jquery/js/jquery-ui-1.8.17.custom.min.js",
														"./jquery/css/custom-theme2/jquery-ui-1.8.17.custom.css",
														"./scribe.css","./inc/tabHTML.css","./ecoStations.css",
														"./images/pFavicon.ico.png"));


?>
<script language="JavaScript">
	var valChange=false;
	function previentPerteSauve() {
		if (valChange) {
			alert("Vous avez modifié les valeurs d'horaires.\nVous devez sauvegarder ou annuler les changement de ces valeurs !");
			return false;
		} else {
			return true;
		}
	}
	$(function() {
	$( "#test" ).click(function() {$( "#dialog-message" ).dialog('open');});
	
		//-------- boutons --------------------------------
		$( "input:button" ).button(); //"input:submit,input:reset", 
		$( "input:submit" ).button(); //"input:submit,input:reset", 
		$( "#btnAnnuleConf" ).click( function() {if (valChange) {if (confirm('Vous avez modifier les valeurs d\'horaires. Etes vous sûr de vouloir annuler vos modifications ?')) window.location.href="./ecoStations.php"; else return false;}} );
		//$( "#_savHor" ).click(function() {document.getElementById("formHor").submit();});
		//-------- onglets --------------------------------
		$( "#tabs" ).tabs();
		$("#tabs").tabs("select", "<?php echo $onglet; ?>");
		$("#tabs").tabs({select:function(event,ui) {return previentPerteSauve();}})
		//-------- fenêtre d'avertissement ----------------
		$( "#dialog:ui-dialog" ).dialog( "destroy" );
		$( "#dialog-message" ).dialog({
			autoOpen: <?php if ($msgErreur!="") echo "true"; else echo "false"; ?>,
			dialogClass : 'ft08',
			modal: true,
			buttons: {
				Ok: function() {
					$( this ).dialog( "close" );
				}
			}
		});

	
		//-------- gestion de la fenêtre crédit ------------
		var togCredit=false;
		var hautCredit=$( "#credit" ).height();
		var decalCredit=hautCredit-$( "#contCredit" ).outerHeight()-3;
		var coulCredit=$( "#clickCredit" ).css("color");
		$( "#credit" ).animate({ top: (-hautCredit+12)+"px" }, 200 );
		$( "#credit" ).click(function(){
			if (!togCredit) $( "#credit" ).animate({ top: (-decalCredit+10)+"px" }, 200 );
			else $( "#credit" ).animate({ top: (-hautCredit+12)+"px" }, 200 );
			togCredit=!togCredit;	
		});
		$( "#credit" ).hover(
		function() {
			$( "#clickCredit" ).css({'font-weight':'bold','color':'black'});
		}, function() {
			$( "#clickCredit" ).css({'font-weight':'normal','color':coulCredit});
		});
	});//ui-widget-content 
</script>

<div id="contGlobal">

<div id="dialog-message" title="Erreur !" style="font-size:0.9em" >
	<p>
		<span class="ui-icon ui-icon-circle-check" style="float:left; margin:0 7px 50px 0"></span>
		<?php echo $msgErreur; ?>
	</p>
</div>

	<div id="contOutil" class="ui-corner-all">
		<h1>EcoStations</h1>
		<div id="lesTabs" style="margin:20px 0 0 0">
			<div id="tabs">
				<ul>
					<?php
					// onMouseDown="if (valChange) {alert('md1'); return false;} else return true;"
					?>
					<li><a href="#tab-hor1">Liste pour <b>l'horaire 1</b> (<i><?php echo $horaire1;?></i>)</a></li>
					<li><a href="#tab-hor2">Liste pour <b>l'horaire 2</b> (<i><?php echo $horaire2;?></i>)</a></li>
					<li><a href="#tab-conf">Configurer les horaires</a></li>
				</ul>
				
				<!-- liste horaire 1                   -->
			<form action="" method="POST" id="formHor">
				<div id="tab-hor1" class="contTabs">
					<h2>Liste des machines à exclure de l'extinction pour l'horaire 1 - <?php echo $horaire1;?></h2><br/>
					<center>
						<textarea style="height:300px;width:250px" name="liste1"><?php echo litListe($ficL1); ?></textarea><br/>
						<input type="submit" id="_savListe1" name="savListe1" value="Enregistrer" style="margin-right:20px;"><input type="button" id="btnAnnuleListe2" value="Annuler"> 
					</center>
				</div>

				<!-- liste horaire 2                   -->
				<div id="tab-hor2" class="contTabs">
					<h2>Liste des machines à exclure de l'extinction pour l'horaire 2 - <?php echo $horaire2;?></h2><br/>
					<center>
						<textarea style="height:300px;width:250px" name="liste2"><?php echo litListe($ficL2); ?></textarea><br/>
						<input type="submit" id="_savListe2" name="savListe2" value="Enregistrer" style="margin-right:20px;"><input type="button" id="btnAnnuleListe2" value="Annuler"> 
					</center>
				</div>

				<!-- config                   -->
				<div id="tab-conf" class="contTabs">
					<h2>Configuration</h2><br/>
					<center>
						<table style="width:300px;margin-bottom:15px;">
							<tr><td style="width:50%;text-align:right;">Horaire 1</td><td><input type="text" style="width:70px" name="hor1" value="<?php echo $horaire1;?>" onChange="valChange=true;"></td></tr>
							<tr><td style="text-align:right;">Horaire 2</td><td><input type="text" style="width:70px" name="hor2" value="<?php echo $horaire2;?>" onChange="valChange=true;"></td></tr>
						</table>
						<input type="submit" id="_savHor" name="savHor" value="Enregistrer" style="margin-right:20px;"><input type="button" id="btnAnnuleConf" value="Annuler"> 
						
					</center>
				</div>
			</form>

			
			</div>
		</div>
		
	</div>
	<div id="credit" class="ui-corner-all fondRayeBleu" style="height:100px;">
		<div id="contCredit" style="position:absolute;bottom:10px;width:100%;padding:5px 0 0 0">
		<center><table cellpadding="0" cellspacing="0" style="margin:0 0 5px 0;padding:0;"><tr><td><center>Développé en étroite collaboration entre <a href="mailto:olivier.hacquard@ac-besancon.fr?subject=ecoStations">Olivier HACQUARD</a>, <a href="mailto:pascal.ratte@ac-besancon.fr?subject=ecoStations">Pascal RATTE</a>, <a href="mailto:laurent.etignard@ac-besancon.fr?subject=ecoStations">Laurent ETIGNARD</a>, <a href="mailto:frederic.lamy@ac-besancon.fr?subject=ecoStations">Frédéric LAMY</a>,</center></td></tr><tr><td><center><a href="mailto:valery.georges@ac-besancon.fr?subject=ecoStations">Valéry GEORGES</a> et <a href="mailto:jerome.labriet@ac-besancon.fr?subject=ecoStations">Jérôme LABRIET</a> ; documentation rédigée par <a href="mailto:pierre.mariot@ac-besancon.fr?subject=ecoStations">Pierre MARIOT</a> dans le cadre du projet</td><td>&nbsp;&nbsp;<a href="http://eole.orion.education.fr/" target="_blank"><image src="./images/pt_logo_eole.png" title="Projet EOLE - Ensemble Ouvert Libre Evolutif" border="0"/></a></center></td></tr></table></center>
		</div>
		<div id="leCredit" style="margin:0;position:absolute;bottom:0px;width:100%"><i><?php if ($_version_!="") echo "version $_version_ |"; ?></i> <span id="clickCredit">Crédit</span></div>
	</div>

</div>

<?php
if ($ligneCron!="") echo "Ecriture de ligne dans le Cron : <b>".$ligneCron."</b>".BRCR;

 
finHTML(); 

?>