<?php
/*---------------------------------------------------------------
		f__ldap_scribe.inc.php
-----------------------------------------------------------------
	Librairie de fonctions d'utilisation du LDAP pour les services 
		installés sur les serveurs Eole Scribe
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon   
---------------------------------------------------------------*/

//*------------------=O===================O----------------------

/*------------------------------------------
 Fonction : mdpROOTLdap
-------------------------------------
 - récupère le mot de passe de connexion root LDAP sur eole
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function mdpROOTLdap() {
	$f=fopen("/var/lib/python-support/python2.5/scribe/backend_conf.pyc", 'r');
	$cont=fread($f, 10000);
	fclose($f);
	$tabC=explode("\0",$cont); //on tronçonne le fichier en séparant les parties contenant des 0
	$prochain=$trouve=false;
	if (is_array($tabC)) foreach($tabC as $_idx=>$_part) { 
		if (strlen($_part)==0) { //on ne traite pas les parties vides
			continue;
		}
		if ($prochain) { //on est sur le bon
			$mdpLdap=substr($_part,0,-2);
			//echo "trouvé : $_part ($mdpLdap)<br/>";
			$prochain=false;
			$trouve=true;
		}
		if (!$trouve && strpos($_part, "backend")!==false) {
			$prochain=true;
		}
	}
	return $mdpLdap;
}


/*------------------------------------------
 Fonction : connecteLDAP
-------------------------------------
 - Connexion au serveur LDAP - scribe ou académique selon le choix...
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function connecteLDAP($choix='scribe') {
	global $cnxLDAP;

	if ($choix!='scribe' && $choix!='aca') return false; //choix scribe ou aca seulement
	if (isset($cnxLDAP[$choix]['etat'])) if ($cnxLDAP[$choix]['etat']) return true; //si déjà connecté, on sort
	
	switch ($choix) {
		case 'scribe':
			if (!isset($cnxLDAP['scribe']['host'])) { //si infos pas encore générées
//				$cnxLDAP['scribe']=array('host'=>"localhost", 'port'=>"389", 'etat'=>false, 'dnCnx'=>"cn=admin,o=gouv,c=fr", 'mdpCnx'=>mdpROOTLdap());
				$cnxLDAP['scribe']=array('host'=>"localhost", 'port'=>"389", 'etat'=>false);
			}
			if ($cnxLDAP['scribe']['etat']) return true;
			break;
		case 'aca':
			if (connecteLDAP('scribe')) { //on récupère les infos du serveur local
				if (!isset($cnxLDAP['aca']['host'])) { //si infos pas encore générées
					$cnxLDAP['aca']=array('academie'=>$cnxLDAP['aca']['academie'], 'host'=>"annuaire.".$cnxLDAP['aca']['academie'].".fr", 'port'=>"389", 'etat'=>false);
				}
			}
			break;
	} //switch
	
	// Accès LDAP  
	$cnxLDAP[$choix]['ds']=ldap_connect($cnxLDAP[$choix]['host'].':'.$cnxLDAP[$choix]['port']); //connexion serveur ldap
	
	if($cnxLDAP[$choix]['ds']) { //la connexion a marché

		if (!isset($cnxLDAP[$choix]['dnCnx'])) $r=ldap_bind($cnxLDAP[$choix]['ds']); //connexion anonyme
		else $r=ldap_bind($cnxLDAP[$choix]['ds'], $cnxLDAP[$choix]['dnCnx'], $cnxLDAP[$choix]['mdpCnx']); //connexion non anonyme

		if ($r===false) { //liaison (bind) a échoué
			$cnxLDAP['message']="Connexion LDAP $choix impossible (bind) !";
			//echo ("Connexion LDAP $choix impossible (bind) !".BRCR);
			return false;
		} else $cnxLDAP[$choix]['etat']=true;
		//echo "Connexion LDAP OK !".BRCR;
	}
	else { //la connexion n'a pas marché
		$cnxLDAP['message']="Erreur de Connexion LDAP !";
		return false;
	}

	switch ($choix) {
		case 'scribe':
			$numero_etab 	= exec("grep -3  numero_etab /etc/eole/config.eol  | gawk -F ']' '{print $1}' | gawk -F '['  '{print $2}' ");
			$RNE			= substr($numero_etab,1,-1);
			$sr = ldap_list( $cnxLDAP['scribe']['ds'], 'ou=education,o=gouv,c=fr', 'ou=ac*', array('ou'));
			$info = ldap_get_entries($cnxLDAP['scribe']['ds'],$sr);
			$cnxLDAP['aca']['academie']=$info[0]['ou'][0];
			$cnxLDAP['scribe']['rne']=$RNE;
			$cnxLDAP['scribe']['baseDN']="ou=$RNE,".$info[0]['dn'];
			break;
		case 'aca':
				$cnxLDAP['aca']['baseDN']="ou=".$cnxLDAP['aca']['academie'].",ou=education,o=gouv,c=fr";
			break;
	} //switch
	return $cnxLDAP[$choix]['etat'];
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function testConnexionLDAP($choixLDAP) {
	//global $cnxLDAP;
	
	return connecteLDAP($choixLDAP);
}


/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function recupDataLDAP2($choixLDAP, $choixDN, $champs, $filtre="(objectClass=*)") {
	global $cnxLDAP;
	
	$tabData=false;
	
	if ($choixDN!="") $choixDN.=","; 
	if (!$cnxLDAP[$choixLDAP]['etat']) { //si pas encore connecté
		if ((connecteLDAP($choixLDAP))===false) {
			die($cnxLDAP['message']);
		} //else echo "Connexion LDAP $choixLDAP OK !".BRCR;
	}
	$sr=$count=$info=NULL;
	//echo "<br>dn:"."$choixDN,".$cnxLDAP[$choixLDAP]['baseDN']."<br>\n".$filtre."<br>\n";
	$sr=ldap_search($cnxLDAP[$choixLDAP]['ds'],"$choixDN".$cnxLDAP[$choixLDAP]['baseDN'], $filtre, $champs);
	
	if($sr)	$info=ldap_get_entries($cnxLDAP[$choixLDAP]['ds'], $sr);
	//print_r($info);
	
	for ($i=0; $i<$info["count"]; $i++) {
		if (is_array($champs)) foreach ($champs as $valC) {
			if ($valC=="dn") {
				$tabData[$i][$valC]=$info[$i]['dn'];
			} else {
				if (count($info[$i][$valC])>2) {
					foreach ($info[$i][$valC] as $_idx => $_val) {
						if ( is_numeric($_idx)) {
							$tabData[$i][$valC][$_idx]=$_val;
						}
					}
				}	else {
					$tabData[$i][$valC]=$info[$i][$valC][0];
				} 
			}
		}		
	}
	return $tabData;
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function recupListeClasse($div="") {
	if ($div!="") $filtre="(cn=$div)";
	else $filtre="(description=classe*)"; //toutes les classes
	
	//récup des classes avec les élèves qui en font partie
	$tabD=recupDataLDAP2('scribe',"ou=local,ou=groupes", array("cn", "memberuid"), $filtre);
	
	return($tabD);
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function recupEquipePeda($div="") {
	if ($div!="") $filtre="(cn=profs-$div)";
	else $filtre="(description=Equipe*)"; //toutes les classes
	$chF=$filtre;
/*
	//récup des classes avec les élèves qui en font partie
	$tabD=recupListeClasse();
	$chF="";
	if (is_array($tabD)) foreach($tabD as $_tVal) {
		$chF.="(description=Equipe profs-".$_tVal['cn'].")";
	}
	if (count($tabD)>1) $chF="(|".$chF.")";
*/	
	//récup des équipes pédagogiques pour toutes les classes
	$tabD=recupDataLDAP2('scribe',"ou=local,ou=groupes", array("cn", "memberuid"), $chF);
	
	return ($tabD);
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function recupListeProfsLDAP($uid) {
	$tP=array();
	//récup des infos
	$chF="(objectclass=*)";
	$tabP=recupDataLDAP2('scribe',"ou=local,ou=personnels,ou=Utilisateurs", array("sn", "givenname","entpersonsexe","intid","uid"), $chF);
	if (is_array($tabP)) foreach ($tabP as $_prof) {
		$tP[$_prof['uid']]=array('nom'=>$_prof['sn'],'prenom'=>$_prof['givenname'],'civ'=>$_prof['entpersonsexe'],'intid'=>$_prof['intid']);
	}
	return $tP;
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function recupGroupesLDAP() {
	$filtre="(objectClass=*)";

	//récup des équipes pédagogiques pour toutes les classes
	$tabD=recupDataLDAP2('scribe',"ou=local,ou=groupes", array("cn","type", "description","memberuid","lastupdate"), $filtre);
	
	return ($tabD);
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function rechercheCorrespondUseridProfLDAP($nom,$prenom) {
	$useridTrouve="";
	if (($_pos=strpos($nom,'-'))!==false) {
		$_nom=substr($nom,0,$_pos).'*';
	} else if (($_pos=strpos($nom,' '))!==false) {
		$_nom=substr($nom,0,$_pos).'*';
	} else if (($_pos=strpos($nom,'_'))!==false) {
		$_nom=substr($nom,0,$_pos).'*';
	} else $_nom=$nom.'*';
	if (($_pos=strpos($prenom,'-'))!==false) {
		$_prenom=substr($prenom,0,$_pos).'*';
	} else if (($_pos=strpos($prenom,' '))!==false) {
		$_prenom=substr($prenom,0,$_pos).'*';
	} else if (($_pos=strpos($prenom,'_'))!==false) {
		$_prenom=substr($prenom,0,$_pos).'*';
	} else $_prenom=$prenom.'*';
	//echo "<i>$nom $prenom - $_nom $_prenom - (&(sn=$_nom)(givenname=$_prenom))".BRCR;
	$tabD=recupDataLDAP2('scribe',"ou=local,ou=personnels,ou=utilisateurs", array("uid"), "(&(sn=$_nom)(givenname=$_prenom))");	
	//print_r($tabD);
	if (is_array($tabD)) {
			$premPass=true;
			foreach($tabD as $_useridTrouve) {
				if (!$premPass) { //s'il y a plusieurs login correspondant
					$useridTrouve.=';';
				}
				$useridTrouve.=$_useridTrouve['uid'];
				$premPass=false;
			}
	}

	return $useridTrouve;
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/

function recupInfosUserLDAP($login) {
	$tabD=recupDataLDAP2('scribe',"", array('sn','givenname','dn','homedirectory','divcod','objectclass','mail'), "(|(uid=$login))");	
	//print_r($tabD);
	if (stristr($tabD[0]['dn'],'ou=personnels')!==false) {
		if (is_array($tabD[0]['objectclass']) && in_array("administratif",$tabD[0]['objectclass'])) $_groupep="ADMINISTRATIF";
		else $_groupep="PROFS";
	} else if (stristr($tabD[0]['dn'],'ou=eleves')!==false) {
		$_groupep="ELEVES";
	} else if (stristr($tabD[0]['dn'],'ou=responsables')!==false) {
		$_groupep="RESP";
	} else {
		$_groupep="AUTRES";
	}
	return array('nom'=>strtoupper($tabD[0]['sn']),'prenom'=>ucfirst(strtolower($tabD[0]['givenname'])),'groupep'=>$_groupep,'div'=>$tabD[0]['divcod'],'home'=>$tabD[0]['homedirectory']);
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function recupInfosElevesClasse($div) {
	$tElv=array();
	$tabE=recupListeClasse($div);
	if (is_array($tabE)) foreach ($tabE[0]['memberuid'] as $_loginE) {
		//echo "$_loginE<br/>";
		$tElv[$_loginE]=recupInfosUserLDAP($_loginE);
	}
	return $tElv;
}

//----------------- A VERIFIER ------------------------------


/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function recupDatasLDAPacaProfs() {
	set_time_limit(0);
	global $cnxLDAP;

	connecteLDAP('scribe'); //appel bidon pour récupérer à coup sûr le rne de l'étab
	$filter="(rneextract=".$cnxLDAP['scribe']['rne'].")";
	$tabD=recupDataLDAP2('aca',"ou=personnels EN", array("cn", "codecivilite", "datenaissance", "dermaj" ,"discim", "discipline", "givenname", "mail", "nompatro", "rne", "rneextract", "sn", "title", "uid"), $filter); //);"sn", "mail", "givenname"
	//print_r($tabD);
	$nbUid=$nbUidTrouve=$nbMultiples=0;
	//exit();
	if (is_array($tabD)) foreach ($tabD as $_tProf) {
		$_userid=rechercheCorrespondUseridProfLDAP($_tProf['sn'],$_tProf['givenname']);
		//if ($_tProf['title']=="ENS") 
		$nbUid++;
		$uidMultiple=(strpos($_userid,';')!==false);
		if ($_userid!="" && !$uidMultiple) $nbUidTrouve++;
		if ($uidMultiple) {$nbMultiples++;echo "<b>".$_tProf['sn']." ".$_tProf['givenname']."</b> login multiple : $_userid".BRCR;}
		if ($_userid=="") {echo "<b>".$_tProf['sn']." ".$_tProf['givenname']."</b> login inconnu".BRCR;}
		//echo "uid=".$_tProf['uid']." userid=$_userid".BRCR;
		$tInfosLDAPaca[]=array('uid_aca'=>$_tProf['uid'],'userid'=>$_userid,'codecivilite'=>$_tProf['codecivilite'],'nom'=>$_tProf['sn'],'prenom'=>$_tProf['givenname'],'nomComplet'=>$_tProf['cn'],'date_naiss'=>$_tProf['datenaissance'],'title'=>$_tProf['title'],'discim'=>$_tProf['discim'],'discipline'=>$_tProf['discipline'],'rne'=>$_tProf['rne'],'rneextract'=>$_tProf['rneextract'],'mail'=>$_tProf['mail'],'dermaj'=>$_tProf['dermaj']);
	}
	echo "résultat : <b>$nbUidTrouve</b> userid trouvés, <b>$nbMultiples</b> userid multiples,  sur <b>$nbUid</b> profs...".BRCR;
	return $tInfosLDAPaca;
}
	
//--------------------------------------- Partie exécutée ----------------------------------------------

global $cnxLDAP;

$cnxLDAP=array('scribe'=>false,'aca'=>false);

?>