<?php
/*
	cas_auth.php

 Bibliotèque de fonctions pour utiliser l'authentification par le CAS dans les modules Envole
*/

//inclue le bon dossier système pour le cas
require_once('CAS-1.3.1/eoleCAS.php');
include_once("configCAS/cas.inc.php");

if (!defined("__CAS_URL")) define("__CAS_URL", __CAS_FOLDER);


function cas_instance(){
    eolephpCAS::client(CAS_VERSION_2_0, __CAS_SERVER, __CAS_PORT, __CAS_URL, false);
    // Maj pour phpCAS 1.3.1
    if (__CAS_VALIDER_CA) {
        EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
    } else {
        if (method_exists("EolephpCAS", "setNoCasServerValidation")){
            EolephpCAS::setNoCasServerValidation();
        }
    }
    if (__CAS_LOGOUT){
        if (method_exists('eolephpCAS', 'eolelogoutRequests')){
            eolephpCAS::EoleLogoutRequests(false);
        }
    }
}


function cas_verif(){
	return EolephpCAS::checkAuthentication();
    //return EolephpCAS::isAuthenticated();
}


function cas_auth(){
    EolephpCAS::forceAuthentication();
}


function cas_logout(){
    EolephpCAS::logout(array("url"=>$_SERVER["SCRIPT_URI"]));
}

function cas_details() {
	  return EolephpCAS::getDetails();
}
?>
