#! /usr/bin/perl -w
##-IEcoStations-2.0
# Académie de Besançon - PR
#
# Modifications Laurent Guinard - Académie de Reims
#
# Script d'insertion de ecostation dans le cron de root
# à partir du fichier (ecostations.txt) produit par l'outil d'administration web..
#
# Attention ecoStations.txt doit être au format Unix.
# aucun controle n'est fait sur le format des paramètres, on assume qu'ils sont toujours correctement présentés
# horaires= 2 : HH:MM

$REP_ECOSTATION="/var/www/html/outils/ecoStations";

# On lit les paramètres du fichier ecostations.txt
if (open(FIC_ECOSTAT, "$REP_ECOSTATION/config/ecoStations.txt")){
	while ($ligne = <FIC_ECOSTAT>) {
		chomp($ligne);
		if ( $ligne =~ /\[(.+)\]/ ) {
			$section=$1;
			$i=0;
		} else {
			if ( $ligne =~ /(.+)/ ) {
				$PARAM{$section}[$i]=$ligne;
				chomp($PARAM{$section}[$i]);
				$i++;
			}
		}
	}
	close(FIC_ECOSTAT);
}

# Création du fichier cron/ecoStations.cron qui va déclencher arret_stations.pl
if ( defined($PARAM{horaires}[0]) ) {
	open (FIC_CRON, "> $REP_ECOSTATION/cron/ecoStations.cron");
	print FIC_CRON "# ECOSTATION: déclenchement du script permettant l'arret de stations\n";
	if ( defined($PARAM{horaires}[0]) ) {
		if ($PARAM{horaires}[0] =~ /^([0-9][0-9]):([0-9][0-9])$/ ) {
			print FIC_CRON "$2 $1 * * * root $REP_ECOSTATION/arret_stations.pl H1 >& /dev/null\n";
		}
	}
	if ( defined($PARAM{horaires}[1]) ) {
		if ($PARAM{horaires}[1] =~ /^([0-9][0-9]):([0-9][0-9])$/ ) {
		        print FIC_CRON "$2 $1 * * * root $REP_ECOSTATION/arret_stations.pl H2 >& /dev/null\n";
		}
	}
	`/bin/cp -f $REP_ECOSTATION/cron/ecoStations.cron /etc/cron.d/ecoStations`;
	close(FIC_CRON);
	`/usr/bin/crontab -l|crontab -`;
	`/etc/init.d/cron restart`;
} else {
	`rm -f $REP_ECOSTATION/cron/ecoStations.cron`;
	`rm -f /etc/cron.d/ecoStations`;
}


