	<ul id="navhelp">
		<li><a href='#arret'>Configurer l'arrêt des stations</a></li>
		<li><a href='#demarrage'>Configurer le démarrage des stations</a></li>
		<li><a href='#tests'>Tests à effectuer en cas de dysfonctionnement</a></li>
	</ul>


	<p style="text-align:justify;text-indent:30px;">
		<b>EcoStations 2.X</b> est un paquet additionnel à <b>Scribe</b> qui permet l'arrêt et le démarrage automatisés des machines du réseau pédagogique. Il offre la planification de deux horaires d'extinction et d'autant d'horaires de démarrage que souhaités. <b>Cette version est compatible avec les versions 2.3 et 2.4 de Scribe</b>.
		<br/><br/>
		<b>Seules les machines sur lesquelles est installé le client Scribe</b> pourront recevoir les ordres d'arrêt ou de démarrage.
		De plus, elles devront avoir été préconfigurés de la manière suivante :
		<ul>
			<li style="text-align:justify">pour recevoir les ordres d'arrêt : désactiver la mise en veille automatique à partir de l'OS de la machine,</li>
			<li style="text-align:justify">pour recevoir les ordres de démarrage : activer le WakeOnLan (WOL) dans le bios s'il le permet. Il est parfois aussi nécessaire d'aller modifier les réglages de la carte réseau.</li>
		</ul>
		Le paquet <b>wakeonlan</b> doit être installé sur le serveur Scribe :
		<span class="code">
		root@scribe:~# apt-eole install wakeonlan
		</span><br/>
	</p>

	<a name='arret'></a><h2>Configurer l'arrêt des stations</h2>
	<p style="text-align:justify;text-indent:30px;">
		Cette méthode utilise le script <font face="Courier New">/usr/share/eole/controlevnc/cliscribe.py</font> du Scribe ainsi que les adresses IP des machines. Que le Scribe soit dans la même zone que les stations ou dans la zone DMZ, les régles du parefeu Amon ne nécessitent pas d'adaptation pour laisser passer les paquets de démarrage.
		<br/>
		Par défaut la planification d'arrêt des machines est désactivée. Cliquer sur le bouton <i>Modifier</i> pour paramétrer les horaires d'extinction ainsi qu'éventuellement les listes des machines à ne pas arrêter. Les listes déroulantes proposées reprennent les machines inscrites dans le fichier <font face="Courier New">/usr/share/eole/controlevnc/machines.db</font> du Scribe.
	</p>
	<center><image src="./images/arret01.png" height="100%" width="100%" title="" border="0"/></center>
	<p style="text-align:justify">
		Une fois la planification activée, les programmations sont affichées et les différents boutons permettent d'interagir :
		<ul>
			<li style="text-align:justify"><i>Modifier</i> : permet de modifier la programmation enregistrée.</li>
			<li style="text-align:justify"><i>Supprimer</i> : supprime les tâches planifiées d'extinction ainsi que les fichiers de configuration des programmations.</li>
			<li style="text-align:justify"><i>Désactiver</i> : supprime les tâches planifiées d'extinction sans perdre les programmations existantes.
		</ul>
	</p>
	<center><image src="./images/arret02.png" height="100%" width="100%" title="" border="0"/></center>
	
	<a name='demarrage'></a><h2>Configurer le démarrage des stations</h2>
	<p style="text-align:justify;text-indent:30px;">
		Le paquet <b>WakeOnLan</b>, utilisé par ecoStations pour démarrer les machines, communique par le protocole UDP sur le port 9 et utilise les adresses MAC des stations. Cette différence avec la méthode utilisée pour envoyer les requêtes d'extinction des machines nécessite d'adapter les règles du parefeu Amon <b>si et uniquement si le Scribe est dans la zone DMZ</b>. Si tel est le cas, il faut alors réserver une adresse IP non utilisée sur le réseau pédagogique puis poser les deux règles suivantes sur le parefeu <b>Amon</b> :
		<span class="code">
		root@amon:~# arp -s ip_réservée_sur_le_réseau_peda ff:ff:ff:ff:ff:ff<br/>
		root@amon:~# iptables -I dmz-ped -s ip_du_scribe/32 -i eth2 -o eth2 -p udp -m udp --dport 9 -j ACCEPT
		</span>
		où <i>ip_réservée_sur_le_réseau_peda</i> et <i>ip_du_scribe</i> sont à remplacer par les IP effectives.
		<br/><br/>
		Du côté d'<b>ecoStations</b> il faut, dans la section <i>Paramétrage</i>, définir la zone du serveur Scribe et renseigner quand il est en DMZ l'adresse IP réservée sur le réseau pédagogique, la même que l'on aura utilisée pour les règles du Amon.
	</p>
	<center><image src="./images/demarrage01.png" height="100%" width="100%" title="" border="0"/></center>
	<p style="text-align:justify">
		Par défaut la planification de démarrage des machines est désactivée. Cliquer sur le bouton <i>Ajouter</i> pour créer une nouvelle programmation de démarrage. La liste déroulante proposée reprend les machines inscrites dans le fichier <font face="Courier New">/usr/share/eole/controlevnc/machines.db</font> du Scribe.
	</p>
	<center><image src="./images/demarrage02.png" height="100%" width="100%" title="" border="0"/></center>
	<p style="text-align:justify">
		Une fois la planification activée, les programmations sont affichées et les différents boutons permettent d'interagir :
		<ul>
			<li style="text-align:justify"><i>Ajouter</i> : permet de créer une nouvelle programmation.</li>
			<li style="text-align:justify"><i>Modifier</i> : permet de modifier une programmation enregistrée.</li>
			<li style="text-align:justify"><i>Supprimer</i> : supprime une ou plusieurs programmation(s). Cela ne change pas l'état de la planification sauf si toutes les programmations sont supprimées. Dans ce cas les tâches planifiées de démarrage sont aussi supprimées ainsi que les fichiers de configuration des programmations.</li>
			<li style="text-align:justify"><i>Désactiver</i> : supprime les tâches planifiées de démarrage sans perdre les programmations existantes.
		</ul>
	</p>
	<center><image src="./images/demarrage03.png" height="100%" width="100%" title="" border="0"/></center>
	
	<a name='tests'></a><h2>Tests à effectuer en cas de dysfonctionnement</h2>

	<h3>Vérifier le fichier /usr/share/eole/controlevnc/machines.db</h3>
	<p style="text-align:justify;text-indent:30px;">
	Que ce soit pour l'arrêt ou le démarrage des stations, la méthode se base sur la lecture du fichier <font face="Courier New">/usr/share/eole/controlevnc/machines.db</font> du Scribe. Ce fichier est alimenté automatiquement par le client Scribe installé sur les stations du domaine. Il comporte, <b>depuis la version 13.0 du client</b>, les noms des machines, les types d'OS, leurs adresses IP et MAC. Si des machines ne reçoivent pas les ordres établis par les programmations, il faut donc se diriger en premier lieu vers ce fichier et vérifier qu'il comporte bien toutes les informations requises. <span style="color:red;font-weight:bold">Si des adresses IP ou MAC sont manquantes, la version du client sur les machines correspondantes n'est pas à jour.</span> Il faut alors procéder à la mise à jour du client pour voir remonter les informations manquantes. Sur une station, le fichier <i>C:\Windows\Eole\install.ini</i> permet de vérifier la version du client.
	</p><br/>

	<h3>Faire des tests de réveil sans utiliser ecoStations</h3>
	<p style="text-align:justify;text-indent:30px;">
		Sur Scribe, à partir du fichier <font face="Courier New">/usr/share/eole/controlevnc/machines.db</font>, récupérer l'adresse MAC d'une machine à démarrer. Lancer ensuite la commande :
		<span class="code">root@scribe:~# wakeonlan MAC_adresse</span>
		où <i>MAC_adresse</i> est de la forme <font face="Courier New">00:15:60:B1:DB:D4</font>. Si la machine démarre, le réseau laisse bien passer les <i>Magic Packet</i> et les problèmes, s'il en existe, devraient être directement liés à ecoStations. 
	</p><br/>

	<h3>Vérifier la présence des fichiers de configurations et des crons</h3>
	<p style="text-align:justify;text-indent:30px;">
		Quand une programmation est planifiée, les fichiers de configuration sont créés dans le répertoire <font face="Courier New">/var/www/html/outils/ecoStations/config</font> et les crons dans <font face="Courier New">/var/www/html/outils/ecoStations</font> et <font face="Courier New">/etc/cron.d</font>. Si tel n'est pas le cas, il manque peut-être des droits. Il faut alors reprendre les différentes étapes de l'installation d'ecoStations.
		<br/>
		Si les fichiers sont bien présents, on peut lancer le script de démarrage sans attendre l'heure de la tâche planifiée avec la commande :
		<span class="code">
		root@scribe:~# cd /var/www/html/outils/ecoStations/<br/>
		root@scribe:~# ./start_stations.pl H1
		</span>
		L'argument <i>H1</i> permet de lancer la première planification du fichier de configuration, <i>H2</i> la deuxième et ainsi de suite. On peut enfin vérifier le fichier de log <font face="Courier New">/var/www/html/outils/ecoStations/ecostations_start.log</font>
	</p>