<?php

include_once('./inc/f_mysql.inc.php');

function verifTableDroits() {
	global $mysqli;
	global $msgCreaTables;
	
	$versionDB=getVersionTableDB("droits");
	if ($versionDB==65000) ecritVersionTableDB("droits", 0);
	
	if (getVersionTableDB("droits")<1) {
		// création des tables
		$sql_query="CREATE TABLE `droits` (
			`num` INT NOT NULL AUTO_INCREMENT,
		  `id_droit` int(2) NOT NULL default 0,
		  `uid` varchar(255) NOT NULL default '',
		  PRIMARY KEY  (num)
			) ENGINE=MyISAM";
		if ($mysqli->query($sql_query)) $msgCreaTables.="Table <b>'droits'</b> creee.\n<br>";
		ecritVersionTableDB("droits", 1);
	}
}

/*-------------------------------------------------------
 fonction verifDroit
 ------------------------------
 indique si lesdroits sont vérifiés ou non (lus dans la table)
 ------------------------------
 Entrées :
  - idDroit : le N° de droit à tester
  - adminOK : indique si l'on doit accorder le droit naturellement à l'administrateur (oui par défaut)
  - isPP : indique si l'utilisateur a le statut de prof principal et donc on testera si profprin à les droits 
---------------------------------------------------------*/
function verifDroit($idDroit, $adminOK=true, $isPP=false) {
	global $uid, $_nomAppli, $tabDroits;
	
	//print_r($_SESSION);
	
	//l'administrateur à souvent tous les droits...
	if ($uid=="admin" && $adminOK) return true;
	//echo " uid:$uid idDroit:$idDroit ";
	//vérifie que l'UID a les droits
	$uidOK=litDroitOk($uid, $idDroit);
	if ($uidOK) return true;
	
	//vérifier qu'un groupe dont fait partie l'UID ou son groupe principal a les droits
	//on commence par mettre en tableau tous les type de groupes de l'utilisateur
	if (isset($_SESSION['_user_']['groupes'])) {
		if (is_array($_SESSION['_user_']['groupes'])) //s'il y a des groupes pour l'utilisateur
			foreach ($_SESSION['_user_']['groupes'] as $_typeGrp=>$_tGrp) { //pour chaque type de groupe
				if (is_array($_tGrp)) 
					foreach ($_tGrp as $_detailGrp) { //pour chaque groupe
						$tabGrp[]=$_detailGrp; //on met chaque groupe de l'utilisateur dans le tableau
					}
			}
	}
	
	//on ajoute le profil à la liste des groupes à tester
	$tabGrp[]=$_SESSION['_user_']['profil'];
	
	//si ce droit n'a pas été précédemment défini, on va le vérifier pour les groupes de l'utilisateur
	if (!isset($_SESSION[$_nomAppli]['droits'][$idDroit])) $_SESSION[$_nomAppli]['droits'][$idDroit]=litDroitOk($tabGrp, $idDroit);
	//si ok pour un des groupes, on sort
	if ($_SESSION[$_nomAppli]['droits'][$idDroit]) return true;
	
	//vérifie que le prof principal a les droits
	if ($isPP) {
		if (litDroitOk("prof_principal", $idDroit)) {
			$_SESSION[$_nomAppli]['droits']['PP'][$idDroit]=true; //on le met en session pour le prochain appel
			return true;
		}
		//else $_SESSION[$_nomAppli]['droits']['PP'][$idDroit]=false; //on le met en session comme faux pour le prochain appel
	}
	
	return false;
}

/*-------------------------------------------------------
 fonction litDroitOk
 ------------------------------
 lit les droits pour un utilisateur (ou groupe d'utilisateur) pour un droit donné dans le service courant 
 ------------------------------
 Entrées :
  - idDroit : le N° de droit à tester
  - userid : l'utilisateur ou le groupe à tester 
---------------------------------------------------------*/
function litDroitOk($userid, $idDroit) {
	global $mysqli;
	global $_nomAppli,$uid;
	
	if (is_array($userid)) { //userid est une liste de groupes dont on recherche les droits
		$rqtIn=mkRequeteIN("uid", $userid);
	}
	else { //userid est un id simple
		//echo $rqtIn="uid='$userid'";
		if ($userid==$uid) { //si l'utilisateur est l'uid courant
			//print_r($_SESSION);
			if (!isset($_SESSION[$_nomAppli]['droits'])) { //si les droits ne sont pas encore en session
				litDroitsUserEtMiseEnSession(); //on va les chercher
			}
			//echo " droits depuis session pour $uid ";
			if (isset($_SESSION[$_nomAppli]['droits'][$idDroit])) return $_SESSION[$_nomAppli]['droits'][$idDroit];
			else return false;
		}	else if($userid=="prof_principal") {
			if (isset($_SESSION[$_nomAppli]['droits']['PP'][$idDroit])) return $_SESSION[$_nomAppli]['droits']['PP'][$idDroit];
			else return false;
		}
	}
	//echo " droits dans la base pour $rqtIn ";
	//si ce n'est pas l'uid et qu'on a pas les infos en session...
	$rqt="SELECT * FROM droits WHERE id_droit='$idDroit' AND $rqtIn";
	$res=$mysqli->query($rqt);
	if ($res) return $res->num_rows; else return false;
}

/*-------------------------------------------------------
 fonction litDroits
 ------------------------------
 lit les utilisateurs ayant un droit donné dans le service courant 
 ------------------------------
 Entrées :
  - idDroit : le N° de droit à tester
---------------------------------------------------------*/
function litDroits($idDroit) {
	global $mysqli;
	global $_nomAppli;
	
	$rqt="SELECT num, uid FROM droits WHERE id_droit='$idDroit' ORDER BY num";
	$res=$mysqli->query($rqt);
	if ($res) {
		while($ligne=$res->fetch_array()) {
			//if ($ligne['uid']=="admetnum") $_uid="Administrateur"; else 
			$_uid=$ligne['uid'];
			$tabUsers[]=$_uid;
		}
	}
	return $tabUsers;
}

/*-------------------------------------------------------
 fonction litDroitsUserEtMiseEnSession
 ------------------------------
 lit les droits de l'utilisateurs courant et du prof principal  et le met en session pour le rappeler ultèrieurement plus rapidement, donné dans le service courant 
 ------------------------------
 Entrées :
---------------------------------------------------------*/
function litDroitsUserEtMiseEnSession() {
	global $mysqli;
	global $_nomAppli,$uid;
	
	$tabDroitsPourLeService=array();
	//echo "SELECT id_droit,uid FROM droits WHERE uid IN ('$uid', 'prof_principal')";
	if ($res=$mysqli->query("SELECT id_droit,uid FROM droits WHERE uid IN ('$uid', 'prof_principal')")) {
		while (list($_id_droit,$_uid)=$res->fetch_row()) {
			if ($_uid=='prof_principal') $tabDroitsPourLeService['PP'][$_id_droit]=true;
			else $tabDroitsPourLeService[$_id_droit]=true;
		}
	}
	$_SESSION[$_nomAppli]['droits']=$tabDroitsPourLeService;
	
/*
	//idem pour le prof principal
	$tabDroitsPourLeService=array();
	if ($res=mysql_query("SELECT id_droit FROM droits WHERE service='$_nomAppli' AND uid='prof_principal'")) {
		while (list($id_droit)=mysql_fetch_row($res)) {
			$tabDroitsPourLeService[$id_droit]=true;
		}
	}
	$_SESSION[$_nomAppli]['droits']['PP']=$tabDroitsPourLeService;
*/
	//echo " mise en session des droits ";
}


/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function ecritDroit($_uid, $idDroit) {
	global $mysqli;
	global $_nomAppli,$uid;
	
	if ($_uid==$uid || $_uid==$_SESSION['_user_']['profil']) $_SESSION[$_nomAppli]['droits'][$idDroit]=true; 			
	if ($_uid=='prof_principal') $_SESSION[$_nomAppli]['PP'][$idDroit]=true;
	
	$rqt="INSERT INTO droits  ( `id_droit` , `uid` ) VALUES ('".secMy($idDroit)."', '".secMy($_uid)."')";
	$res=$mysqli->query($rqt);
	if ($res) return true; else return false;
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function supprimeDroits($idDroit) {
	global $mysqli;
	global $_nomAppli,$uid;
	
	unset($_SESSION[$_nomAppli]['droits']);
	unset($_SESSION[$_nomAppli]['PP']);
	$rqt="DELETE FROM droits  WHERE `id_droit`='$idDroit'";
	$res=$mysqli->query($rqt);
	if ($res) return true; else return false;
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function supprimeDroit($_uid, $idDroit) {
	global $mysqli;
	global $_nomAppli,$uid;
	
	$tUidAvecDroit=litDroits($idDroit);
	//print_r($tUidAvecDroit);
	//echo "$uid/".$_SESSION['_user_']['profil'];
	$nbDroitsUtiliseur=0;
	if (in_array($uid, $tUidAvecDroit)) {
		$nbDroitsUtiliseur++;
	}
	if (in_array($_SESSION['_user_']['profil'], $tUidAvecDroit)) {
		$nbDroitsUtiliseur++;
	}
	if (($nbDroitsUtiliseur<2)) if (isset($_SESSION[$_nomAppli]['droits'][$idDroit])) unset($_SESSION[$_nomAppli]['droits'][$idDroit]); 			
	if ($_uid=='prof_principal') if (isset($_SESSION[$_nomAppli]['PP'][$idDroit]))  unset($_SESSION[$_nomAppli]['PP'][$idDroit]);
	
	$rqt="DELETE FROM droits  WHERE `id_droit`='$idDroit' AND uid='$_uid'";
	$res=$mysqli->query($rqt);
	if ($res) return true; else return false;
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function saisieSimpleDroits($tabChoixDroit, $action="", $nomForm="form1") {
	global $tabDroits;
	
	$styleLigne="text-align:center;font-weight:bold;font-style:italic;";
	$styleCell="background-color:#B0B0FF;margin:2px;padding:2px 5px 2px 5px;";
	if (is_array($tabChoixDroit)) {
		echo '<form method="POST" action="'.$action.'" name="'.$nomForm.'">'.CR;
		echo '<table id="tDroits" align="center"><tr class="ligne"><td class="cellule">intitulé2</td><td class="cellule"><table><tr class="ligne"><td>utilisateurs autorisés </td><td>'."aide"/*demandeAide(1002)*/.'</td></tr></table></td></tr>\n';
		foreach ($tabChoixDroit as $choixDroit) {
			$tabUsers=litDroits($choixDroit);
			$chaineUsers="";
			if (is_array($tabUsers)) $chaineUsers=implode(";", $tabUsers);
			if (isset($tabDroits[$choixDroit])) {
				echo '<td style="'.$styleCell.'">'.$tabDroits[$choixDroit]['libelle'].'</td>'.CR;
				echo '<td style="'.$styleCell.';text-align:center;"><input type="text" size="50" name="listeAutorises['.$choixDroit.']" value="'.$chaineUsers.'"></td></tr>'.CR;
			}
		}
		echo '</table>'.CR;
		echo '<br /><center><input type="submit" name="sauveDroits" align="center" value="Enregistrer les modifications"></center>'.CR;
		echo '</form>'.CR;
	}
}


/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function afficheDroits($tabChoixDroit, $retour, $numDivAide) {
	global $tabDroits;
	
	$styleLigne="text-align:center;font-weight:bold;font-style:italic;";
	$styleCell="background-color:#B0B0FF;margin:2px;padding:2px 5px 2px 5px;";
	$boutonAM="height:20px;font-size:10px";
	if (is_array($tabChoixDroit)) {
		//echo "<table width=\"650\" align=\"center\" style=\"border:1px SOLID #004080;\"><tr style=\"$styleLigne\"><td width=\"300\" style=\"$styleCell\">intitulé</td><td width=\"300\" style=\"$styleCell\"><table><tr style=\"$styleLigne\"><td>utilisateurs autorisés </td><td>"./*demandeAide(1002)*/"aide"."</td></tr></table></td></tr>\n";
		//echo '<table id="tDroits" align="center"><tr class="ligne"><td class="cellule">intitulé2</td><td class="cellule"><table><tr class="ligne"><td>utilisateurs autorisés </td><td>'."aide"/*demandeAide(1002)*/.'</td></tr></table></td></tr>\n';
		
		
		echo '<table id="tDroits" align="center">
			<tr class="ligne">
				<td class="cellule">intitulé</td>
				<td class="cellule">utilisateurs autorisés '.iconeAide($numDivAide).'
				'.
				'</td>
			</tr>'.CR;
		/*	<table>
						<tr class="ligne">
							<td></td>
							<td>'.demandeAide(1002).'</td>
						</tr>
					</table>*/
		foreach ($tabChoixDroit as $choixDroit) {
			//$tabUsers=litDroits($choixDroit);
			//print_r($tabUsers);
			//$selectD=selectDroits($tabUsers);
			if (isset($tabDroits[$choixDroit])) {
				//echo "<td style=\"$styleCell\">".$tabDroits[$choixDroit]['libelle']."</td>\n";
				echo '<td class="cellule">'.$tabDroits[$choixDroit]['libelle'].'</td>'.CR;
				//echo '<td class="cellule tCentre">'.$selectD.'<input type="button" class="boutonAM" value="Ajouter/Modifier" onClick="window.location=\'select_user.php?id_droit='.$choixDroit.'&retour='.encodeURL_OH($retour).'\';"></td></tr>'.CR;
				echo '<td class="cellule tCentre">'.listeUtilisateursAyantDroit($choixDroit, $retour).'</td></tr>'.CR;
			}
		}
		echo "</table>\n";
		echo "<br />\n";
	}
}


function listeUtilisateursAyantDroit($choixDroit, $retour, $droit="", $JSavantChargement="") {
	$tabUsers=litDroits($choixDroit);
	//print_r($tabUsers);
	$selectD=selectDroits($tabUsers);
	if ($droit!='') $paramDroit='&libDroit='.urlencode($droit);
	else $paramDroit='';
	return $selectD.'<input type="button" class="boutonAM" value="Ajouter/Modifier" onMouseDown="'.$JSavantChargement.'" onClick="window.location=\'select_user.php?id_droit='.$choixDroit.'&retour='.encodeURL_OH($retour).$paramDroit.'\';">';	
}

/*------------------------------------------
 Fonction : selectDroits
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function selectDroits($tabUsers) {
	$tabLibProfil['autre']="Autres";
	$tabLibProfil['eleve']="Elèves";
	$tabLibProfil['professeur']="Profs";
	$tabLibProfil['administratif']="Administratifs";
	$tabLibProfil['responsable']="Responsables";
	$tabLibProfil['prof_principal']="Professeur principal";
	$tabLibProfil['administrateur']="Administrateur";
	
	$tUid=array();
	$tabC=array_keys($tabLibProfil);
	$tabO="";
	if (is_array($tabUsers)) foreach ($tabUsers as $user) {
		if (in_array($user, $tabC)) { //si c'est une catégorie
			if ($user!="admin" && $user!="prof_principal") $cat="catégorie - "; else $cat="";
			$tabO[0][]="<option>$cat".$tabLibProfil[$user]."</option>\n";
		}
		else { //c'est un userid
				$tUid[]=$user;
		}
		/*else { //groupe ou userid
			$isGroupe=false;
			if ($res=mysql_query("SELECT libGrp FROM groupes_en WHERE nomGrp='$user'")) if (mysql_num_rows($res)>0) $isGroupe=true;
			if ($isGroupe) { //si c'est un groupe
				list($libGrp)=mysql_fetch_array($res);
				$tabO[1][]="<option>groupe - $libGrp</option>\n";
			}
		}*/
	}
	if (count($tUid)>0) { //il y a des userid dans la liste
		$tUsers=recupInfosMultiUsersLDAP($tUid);
	//print_r($tUsers);
		if (is_array($tUsers)) foreach ($tUsers as $_uid=>$_tUser) {
			if ($_tUser['profil']!='eleve') $_tUser['div']='';
			$tabO[$_tUser['profil']][]='<option>'.$_tUser['profil'].' - '.$_tUser['nom'].' '.$_tUser['prenom'].(($_tUser['div']!='')?' ('.$_tUser['div'].')':'').'</option>\n';
		}
	}
	
	if (!is_array($tabO)) {$chO="<option>liste vide...</option>\n"; $dis="DISABLED";}
	else {
		$prems=true;
		foreach ($tabO as $_tabO) {
			if (!$prems) $chO.="<option>--------------------</option>\n";
			$prems=false;
		//for ($idx=0; $idx<count($tabO) /*3*/ ; $idx++) {
			//if (isset($tabO[$idx])) foreach ($tabO[$idx] as $option) $chO.=$option;
			if (isset($_tabO)) {
				foreach ($_tabO as $option) $chO.=$option;
			}
		}
	}
//	$ch='<select style="width:250px;background-color:#FFFFFF;" '.$dis.' onMouseDown="this.style.backgroundColor=\'#FFFF80\';return false;" onBlur="this.style.backgroundColor=\'#FFFFFF\'" >'.CR.$chO.'</select>';
	$ch='<select style="width:250px;background-color:#FFFFFF;" '.$dis.'  >'.CR.$chO.'</select>';
	
	return $ch;
}


function sauveDroitsPOST() {
	if (isset($_POST['sauveDroits'])) {
		if (isset($_POST['listeAutorises'])) foreach ($_POST['listeAutorises'] as $num=> $listeAut) {
			$tabU=explode(";", $listeAut);
			supprimeDroits($num);
			if (is_array($tabU) && trim($listeAut)!="") foreach ($tabU as $user) {
				if (strtolower(trim($user))=="administrateur") $user="admin";
				if (trim($user)!="") ecritDroit(trim($user), $num);
			}
		}
	return "Droits enregistrés...";
	}
}

function pasLesDroits($uid) {
	echo "<center><h2>Vous n'avez pas les droits pour accéder à cette page.<br/>Pour les obtenir, contactez l'administrateur du logiciel...</h2></center>";
	echo "<a href=\"#\" onMouseDown=\"window.history.go(-1)\">Retourner à la page précédente</a>"; exit();
}//<script language=\"Javascript\" type=\"text/javascript\">window.history.go(-1)</script>


/*------------------------------------------
 Fonction : valideAccesPage
-------------------------------------
 vérifie l'autorisation d'accès à une page à partir d'une liste de groupes ayant le droit d'accès
-------------------------------------
 - Entrée : liste : liste de groupes autorisés          droitPrioritaire : indique si le droit est accordé de fait
 - Sortie :
---------------------------------------------*/
/*function valideAccesPage($liste,$droitPrioritaire=false,$versPageNonAutorisee=false) {
	global $uid, $isProf, $isEleve, $isAutres, $isEtudian, $isStage, $isAdulte; //récup de l'uid courant
	
	if ($droitPrioritaire) return true;
	chercheGroupe($uid);
	$tListe=explode(';',$liste);
	if (is_array($tListe)) foreach ($tListe as $_elem) {
		switch (strtolower(substr($_elem,0,4))) {
			case "adul":
				if ($isAdulte) return true;
				break;
			case "prof":
				if ($isProf) return true;
				break;
			case "stag":
				if ($isStage) return true;
				break;
			case "autr":
				if ($isAutres) return true;
				break;
			case "elev":
			case "élèv":
			case "elèv":
				if ($isEleve) return true;
				break;
			case "etud":
			case "étud":
				if ($isEtudian) return true;
				break;
		}
	}
	//si on est là c'est que l'uid n'a pas le droit d'aller plus loin
	//return false;
	if ($versPageNonAutorisee) pageNonAutorisee();
	return false;
	
} //fin de fonction
*/

/*------------------------------------------
 Fonction : 
-------------------------------------
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function pageNonAutorisee() {
	echo "<script>window.location='./inc/non_autorise.html'</script>\n";
	exit();
} //fin de fonction


//--------------------------------- Parti exécutée lors de l'inclusion du fichier ----------------
//pour récupérer le nom du service
//require ('./_infoAppli.inc.php'); 

//récupère la définition des droits 
if (file_exists("./_droits.inc.php")) include ("./_droits.inc.php");

//fait la verif de l'existence de la table à l'appel de la librairie
verifTableDroits();


?>