#! /usr/bin/perl -w
#-IEcoStations-2.0
# Laurent Guinard - Académie de Reims
# adaptation du fichier arret_stations.pl pour démarrer les stations


$REP_ECOSTATION="/var/www/html/outils/ecoStations";
$err=0;

# AG 07/02/2017
# Vérification si on est en vacances ou pas
$result=`php /var/www/html/outils/ecoStations/verifStart.php`;

$result =~ s/[^[:print:]]//g; #supprime caractères non imprimables
if ( $result ge '2' ) {
    print "Vacances...\n";
    exit 1;
}


# Lecture des paramètres du fichier ecostations_start.txt
open(FIC_ECOSTAT_START, "$REP_ECOSTATION/config/ecoStations_start.txt") or die "ouverture impossible du fichier ecoStations_start.txt";
if ( $ARGV[0] =~ /H(.+)/) {
	# récupération de l'argument pour démarrer les machines du numéro de ligne correspondant
	$num_ligne_start = $1;
	$i_start=0;
	while ($ligne_temp = <FIC_ECOSTAT_START>) {
		chomp($ligne_temp);
		$ligne_start[$i_start] = $ligne_temp;
		$i_start++;
	}
	# si l'argument saisi est supérieur au nombre de lignes
	if ($num_ligne_start >= $i_start){
		$err=1;
	} else {
		if ($ligne_start[$num_ligne_start] =~ /(.+)\|(.+)\|(.+)/) {
			$horaire_start = $1;
			$machines_start = lc($3);
		}
	}
}
close(FIC_ECOSTAT_START);

# Lecture des paramètres du fichier confEcoStations_start.inc.php
open(FIC_CONF_ZONE, "$REP_ECOSTATION/config/confEcoStations_start.inc.php") or die "ouverture impossible du fichier confEcoStations_start.inc.php";

$j_ip=0;
while ($zone_temp = <FIC_CONF_ZONE>) {
	chomp($zone_temp);
	$ligne_ip[$j_ip] = $zone_temp;
	$j_ip++;
}

if ($ligne_ip[1] =~ /\'(.+)\'/) {
	$zone = $1;
}
if ($zone eq "DMZ") {
	if ($ligne_ip[2] =~ /\'(.+)\'/) {
		$cmd_wol = "wakeonlan -i $1";
	}
} else {
		$cmd_wol = "wakeonlan";
}
close(FIC_CONF_ZONE);

if ($err==0){
	$ORDI{demarre}="";
	$ORDI{actifs}="";
	my $version=`grep EOLE_VERSION /etc/eole/release | tr -d "'" | cut -d '=' -f2`;
	# ouverture du fichier /usr/share/eole/controlevnc/machines.db pour retrouver les adresses mac des machines à éteindre
	open(FIC_MACHINES, "$REP_ECOSTATION/config/copie_machines.db") or die "ouverture impossible du fichier machines.db";
	while ($ligne = <FIC_MACHINES>) {
		chomp($ligne);
		 #fl 15/01/2019  la regex doit être différente entre 2.3 et 2.5, du fait que les fichiers machine.db n'ont pas le même nombre de champs
			if( $version == "2.5" || $version == "2.6" || $version == "2.7" ) {                     
				if ( $ligne =~ /(.+)\;([0-9.]{7,15})\;(.+)/ ) {
			# récupération des champs
					$machine=$1;
					$ip=$2;
					$mac=$3;
				}	
			} else {
				if ( $ligne =~ /(.+)\;([0-9.]{7,15})\;(.+)\;(.+)/ )	{
					# récupération des champs
					$machine=$1;
					$ip=$2;
					$mac=$4;
				}	
			}
			if ($machines_start =~ m/$machine/){
				# test de l'activité de la machine
				if (system("tcpcheck 1 $ip:8788 | grep -q alive")==0){
					$ORDI{actifs}.=" $machine";
				} else {
					$ORDI{demarre}.=" $machine";
					system("$cmd_wol $mac");
				}
			}
		}
	
	close(FIC_MACHINES);
}

if ( ! -f "$REP_ECOSTATION/log/ecoStations.log" ) { `touch $REP_ECOSTATION/log/ecoStations.log`; }
$taille=(stat("$REP_ECOSTATION/log/ecoStations.log"))[7];
if ( $taille > 100000 ) { `mv $REP_ECOSTATION/log/ecoStations.log $REP_ECOSTATION/log/ecoStations.log.1`; }
open(FIC_LOG,">> $REP_ECOSTATION/log/ecoStations.log") or die "ouverture impossible du fichier log/ecoStations.log";
$DATE=`date '+%d/%m/%y %H:%M:%S'`;
chomp($DATE);
print FIC_LOG "--------------------------------------------------------------------------\n";
if ($err==1){
	print FIC_LOG "$DATE - L'argument donné au script start_stations.pl ne correspond pas à une ligne du fichier ecoStations_start.txt"
} else {
	print FIC_LOG "$DATE - Démarrage des stations à $horaire_start\n";
	print FIC_LOG "Ordi à démarrer : $machines_start\n";
	print FIC_LOG "Ordi trouvés dans la base et déjà actifs :$ORDI{actifs}\n";
	print FIC_LOG "Ordi trouvés dans la base ayant reçu l'ordre de démarrer :$ORDI{demarre}\n";
}
print FIC_LOG "\n\n";
close(FIC_LOG);

