<?php
/*----------------------------------------------------------------
 Librairies de fonctions pour l'application ecoStations
----------------------------------------------------------------*/

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function creeNouvGrp($nomGrp,$details) {
	global $mysqli;

	if (trim($nomGrp)=="") return "Nom du groupe vide !";
	if ($res=$mysqli->query("SELECT nom FROM es_groupes WHERE nom LIKE '$nomGrp'")) {
		if ($res->num_rows==0) {//le nom n'existe pas encore - on créé le groupe
			$mysqli->query("INSERT INTO es_groupes SET nom='".trim($nomGrp)."',details='".trim($details)."'");
		} else return "Création impossible !<br/><br/>Le nom de groupe existe déjà...";
	}
	return '';
}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function recupGrp($choix=0) {
	global $mysqli;

	if ($choix==0) $leChoix1=$leChoix2='1';
	else {
		$leChoix1='groupe_ID='.$choix;
		$leChoix2='ID_groupe='.$choix;
	}
	$tGrp=array();
	if ($res=$mysqli->query("SELECT count(*),groupe_ID FROM es_grp_machines WHERE ".$leChoix1." GROUP BY groupe_ID")) {
		while (list($_nb,$_grpID)=$res->fetch_row()) {
			$tGrp2[$_grpID]['nb']=$_nb;
		}
	}

	if ($res=$mysqli->query("SELECT ID_groupe,nom,details FROM es_groupes WHERE ".$leChoix2." ORDER BY nom")) {
		while (list($_grpID,$_nom,$_details)=$res->fetch_row()) {
			$tGrp[]=array('id'=>$_grpID,'nom'=>$_nom,'details'=>$_details,'nb'=>((isset($tGrp2[$_grpID]['nb']))?$tGrp2[$_grpID]['nb']:0));
		}
	}
	return $tGrp;
}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function recupCompoGrp($idGrp) {
	global $mysqli;

	$tMach=array();
	if ($res=$mysqli->query("SELECT es_machines.nom,machine_ID FROM es_machines,es_grp_machines WHERE machine_ID=ID_machine AND groupe_ID='".$idGrp."' ORDER BY es_machines.nom")) {
		while (list($_nomM,$_machID)=$res->fetch_row()) {
			$tMach[$_machID]=$_nomM;
		}
	}
	return $tMach;
}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function recupMachines($idMach=0) {
	global $mysqli;

	if ($idMach==0) $choixMachine='1';
	else $choixMachine="ID_machine=$idMach";
	$tMach=array();
	if ($res=$mysqli->query("SELECT ID_machine,nom,ip,os FROM es_machines WHERE ".$choixMachine." ORDER BY nom")) {
		while (list($_machID,$_nomM,$_ip,$_os)=$res->fetch_row()) {
			$tMach[$_machID]=array('nom'=>$_nomM,'ip'=>$_ip, 'os'=>$_os);
		}
	}
	return $tMach;
}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/

function ajouteMachinesGroupe($idGroupe,$idMach){
	global $mysqli;

	if (!is_array($idMach)) $idMach=array($idMach);
	if (count($idMach)>0) foreach ($idMach as $_ajoutMachine) {
		$query="INSERT INTO es_grp_machines SET groupe_ID='$idGroupe' , machine_ID='$_ajoutMachine'";
		//echo $query.BRCR;
		$mysqli->query($query);
	}
}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/

function supprimeMachinesGroupe($idGroupe,$idMach){
	global $mysqli;

	if (!is_array($idMach)) $idMach=array($idMach);
	if (count($idMach)>0) foreach ($idMach as $_ajoutMachine) {
		$query="DELETE FROM es_grp_machines WHERE groupe_ID='$idGroupe' AND machine_ID='$_ajoutMachine'";
		//echo $query.BRCR;
		$mysqli->query($query);
	}
}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function majNomGroupe($choixG,$nomG,$detailsG) {
	global $mysqli;

	if ($res=$mysqli->query("SELECT nom FROM es_groupes WHERE nom LIKE '$nomG'")) {
		if ($res->num_rows==0) {//le nom n'existe pas encore - on créé le groupe
			$query="UPDATE es_groupes SET nom='$nomG',details='$detailsG' WHERE ID_groupe='$choixG'";
			$mysqli->query($query);
		} else return "Modification du nom impossible !<br/><br/>Le nom de groupe existe déjà...";
	}
	return '';

}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function suppGrp($choixG) {
	global $mysqli;

	$mysqli->query("DELETE FROM es_grp_machines WHERE groupe_ID=".$choixG);
	$mysqli->query("DELETE FROM es_groupes WHERE ID_groupe=".$choixG);
}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function majBaseMachines($tMach,$tMachASupprimer) {
	global $mysqli;
	if (!is_array($tMach) && !(is_array($tMachASupprimer))) return false;

	//print_r($tMach);
	//print_r($tMachASupprimer);
	//on gère les machines existantes dans le fichier qu'on met à jour ou ajoute
	if (is_array($tMach)) foreach ($tMach as $_mach) {
		if ($_mach['id']==0) { //la machine n'existe pas encore dans la base
			$query="INSERT INTO es_machines SET nom='".$_mach['nom']."',ip='".$_mach['ip']."',os='".$_mach['os']."'";
		} else {
			$query="UPDATE es_machines SET ip='".$_mach['ip']."',os='".$_mach['os']."' WHERE ID_machine='".$_mach['id']."'";
		}
		$mysqli->query($query);
	}

	//on gère les machines à supprimer de la base
	if (is_array($tMachASupprimer)) foreach ($tMachASupprimer as $_nomM=>$val) {
		$_idM='0';
		if ($res=$mysqli->query("SELECT ID_machine FROM es_machines WHERE nom='".$_nomM."'")) {
			if ($res->num_rows>0) { //la machine portant ce nom existe
				list($_idM)=$res->fetch_row();
			}
		}
		$query="DELETE FROM es_machines WHERE ID_machine='".$_idM."'"; //supprime les machines
		$mysqli->query($query);
		$query="DELETE FROM es_grp_machines WHERE machine_ID='".$_idM."'"; //supprime les machines dans les groupes
		$mysqli->query($query);
	}
}

/*------------------------------------------
 Fonction :
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function traiteFichierMachines() {
	global $dateModifFichierMachines;

	$fichier="./machines.db";
	//lecture du fichier et récup des informations sur les machines
	if (file_exists($fichier)) {
		if (($dateF=filemtime($fichier))>$dateModifFichierMachines) {
			ecritParam('dateModifFichierMachines',$dateF); //on enregistre en base
		} else return ''; //si fichier pas modifié, on sort
		//echo "suite traiteFichier.".BRCR;
		$tMachines=recupMachines();
		foreach ($tMachines as $_id=>$_mach) $tMachDB[$_mach['nom']]=$_id;
		$fd = fopen($fichier, 'r' );
		while (($buffer = fgets($fd)) !== false) {
			list($_nomM,$_ipM,$_osM)=explode(':',$buffer);
			if (isset($tMachDB[$_nomM])) {
				$_idM=$tMachDB[$_nomM];
				unset($tMachDB[$_nomM]); //on supprime la machine du tableau si elle existe
			} else $_idM=0;
			$tNewMach[]=array('id'=>$_idM,'nom'=>$_nomM,'ip'=>$_ipM,'os'=>$_osM);
		}
		fclose($fd);
		//print_r($tNewMach);
		majBaseMachines($tNewMach,$tMachDB);
		return '';
	} else return "Impossible d'ouvrir le fichier <b>".$fichier."</b>";
}

function ping($host, $timeout = 1) {
                /* ICMP ping packet with a pre-calculated checksum */
                $package = "\x08\x00\x7d\x4b\x00\x00\x00\x00PingHost";
                $socket  = socket_create(AF_INET, SOCK_RAW, 1);
                socket_set_option($socket, SOL_SOCKET, SO_RCVTIMEO, array('sec' => $timeout, 'usec' => 0));
                socket_connect($socket, $host, null);

                $ts = microtime(true);
                socket_send($socket, $package, strLen($package), 0);
                if (socket_read($socket, 255))
                        $result = microtime(true) - $ts;
                else    $result = false;
                socket_close($socket);
echo "ping de $host ";
                return $result;
        }


//enregistrement des horaires d'extinction dans le fichier config/confEcoStations.inc.php
function ecritConfHoraires($_hor1,$_hor2,$_etat_plan_stop) {
	global $ficConf;

	if ($fp=fopen($ficConf,'w')) {
		fwrite($fp, "<?php\n\$horaire1='$_hor1';\n\$horaire2='$_hor2';\n\$etat_plan_stop='$_etat_plan_stop';\n?>\n");
		fclose($fp);
	}
}

//enregistrement des param. de démarrage dans le fichier config/confEcoStations_start.inc.php
function ecritConfstart($peda_dmz,$_ip,$_etat_plan) {
	global $ficConfstart;

	if ($fp=fopen($ficConfstart,'w')) {
		fwrite($fp, "<?php\n\$zone='$peda_dmz';\n\$ip='$_ip';\n\$etat_plan='$_etat_plan';\n?>\n");
		fclose($fp);
	}
}

//lecture de la liste des machines à ne pas éteindre dans le fichier texte correspondant
function litListe($nomFic,$indice) {
	if (!file_exists($nomFic)) return "";
	if ($fp=fopen($nomFic,"r")) { //lecture des données dans le fichier
		$cont=fread($fp, filesize($nomFic));
		fclose($fp);
		$lignes = explode(PHP_EOL, $cont);
		foreach ($lignes as $i => $ligne){
			if ($ligne=="[horaire1_exclusions]") {
				$indice1=$i;
			}
			if ($ligne=="[horaire2_exclusions]") {
				$indice2=$i;
			}
		}
		if ($indice==1) {
			for ($k = $indice1 + 1; $k <= $indice2 - 1; $k++) {
				$stations[]=$lignes[$k];
			}
		}
		if ($indice==2) {
			for ($k = $indice2 + 1; $k <= count($lignes); $k++) {
				$stations[]=$lignes[$k];
			}
		}
		return $stations;
	}
	return "";

}

//affichage de la liste des machines à ne pas arrêter
function afficheListe($tListe) {
	//$tListe=explode(PHP_EOL,$nomliste);
	if (is_array($tListe)) foreach ($tListe as $_lig) {
		if (trim($_lig)!="") $tL[]=trim($_lig);
	}
	if ($tL[0]=="") {
		return "Toutes les stations vont recevoir l'ordre de s'arrêter";
	} else {
		return implode(", ", $tL);
	}
}

//lecture du fichier copie_machines.db pour menu déroulant liste noms stations
function listeStations($fic,$stationselect) {
	if (is_array($stationselect)) foreach ($stationselect as $_lig) {
		if (trim($_lig)!="") $tL[]=trim($_lig);
	}

	//si le fichier copie_machine.db n'existe pas ou qu'il est vide, on sort...
	if (!file_exists($fic) || filesize($fic) == 0) {
		echo '<option disabled="1">aucune station trouvée...</option>';
		return;
	}

	$id_fichier = fopen($fic,"r");
	$contenu = fread($id_fichier, filesize($fic));
	fclose($id_fichier);

	$lignes = explode(PHP_EOL, $contenu);
	//print_r($lignes);
	foreach ($lignes as $ligne) {
		if (trim($ligne)=="") continue;
		$tabligne = explode(";",$ligne);
		//print_r($tabligne);
		/// V2.4.7 - OH - correction affichage lignes vides pour les entrées de copie_machines.db incomplètes
		if (count($tabligne)==4) { //scribe <= 2.3
			if (trim($tabligne[1])=="" || trim($tabligne[3])=="" || trim(strtolower($tabligne[3]))=="none") { //pb adresse IP ou adresse MAC
				$noms[] = $nomsPb[] = $tabligne[0]." (adresse inconnue)";
			} else $noms[] = $tabligne[0];
			$noms[] = $tabligne[0];
		} else { //scribe 2.5
			if (trim($tabligne[0])=="") { //pb nom
				$noms[] = $nomsPb[] = "(nom inconnu - ".$tabligne[1].")";
				//$noms[] = "(nom inconnu - ".$tabligne[1].")";
			}
			else if (trim($tabligne[2])=="") { //pb adresse MAC
				$noms[] = $nomsPb[] = $tabligne[0].'(adresse MAC inconnue)';
			}
			else if (trim($tabligne[1])=="") { //pb adresse IP
				$noms[] = $nomsPb[] = $tabligne[0].'(adresse IP inconnue)';
			}
			else $noms[] = $tabligne[0];
		}
		//$noms[] = $tabligne[0];

		if (isset($noms)) usort($noms, "strcasecmp");
	}
    if(isset($noms)) {
	    foreach ($noms as $nom) {
	    	$desac=$txtPb="";
	    	if (in_array($nom, $nomsPb)) {
	    		$desac=" disabled";
	    		//$txtPb=" (adresse inconnue)";
	    	}
	    	if (in_array($nom, $tL)) {
	    		echo '<option selected="selected"'.$desac.'>'.$nom.$txtPb.'</option>';
	    	} else {
	    		echo '<option'.$desac.'>'.$nom.$txtPb.'</option>';
	    	}
	    }
	}
	/// V2.4.7 - OH
}

//modification du fichier ecoStations.txt
function ecritFicEcoStations($hor1, $hor2, $liste1, $liste2) {
	global $ficEcoStations;

	if (is_array($liste1)) foreach ($liste1 as $_lig1) {
		if (trim($_lig1)!="") $tL1[]=trim($_lig1);
	}
	if (is_array($tL1)) foreach ($tL1 as $_lig1) {
		$cont1.=$_lig1."\n";
	}

	if (is_array($liste2)) foreach ($liste2 as $_lig2) {
		if (trim($_lig2)!="") $tL2[]=trim($_lig2);
	}
	if (is_array($tL2)) foreach ($tL2 as $_lig2) {
		$cont2.=$_lig2."\n";
	}

	$contFic="[horaires]
$hor1
$hor2

[horaire1_exclusions]
$cont1
[horaire2_exclusions]
$cont2";
	if ($fp=fopen($ficEcoStations,"w")) { //écriture des données dans le fichier
		fwrite($fp, $contFic);
		fclose($fp);
	}
}

//modification du fichier ecoStations_start.txt
function ecritFicEcoStationstart($hor_start, $jour_start, $tListe, $numlignemodif) {
	global $ficEcoStationstart;

	//formatage de la liste de stations
	if (is_array($tListe)) foreach ($tListe as $_lig) {
		if (trim($_lig)!="") $tL[]=trim($_lig);
		$liste_ligne = implode(", ", $tL);
	}
	//écriture des données dans le fichier
	//modification d'une ligne existante
	if ($numlignemodif!="") {
		$fp = fopen($ficEcoStationstart, 'r');
		$contenu = fread($fp, filesize($ficEcoStationstart));
		fclose($fp);

		$contenu = explode(PHP_EOL, $contenu);
		$contenu[$numlignemodif] = "$hor_start|$jour_start|$liste_ligne";
		$contenu = implode(PHP_EOL, $contenu);
		$fp = fopen($ficEcoStationstart, 'w');
		fwrite($fp, $contenu);
		fclose($fp);
	//création d'une nouvelle ligne
	} else {
		//si le fichier n'existe pas
		if(!file_exists($ficEcoStationstart)) {
			$contFic="horaire|jours|stations
$hor_start|$jour_start|$liste_ligne";
			if ($fp=fopen($ficEcoStationstart,'w')) {
				fwrite($fp, $contFic);
				fclose($fp);
			}
		//si le fichier existe
		} else {
			$contFic="\n$hor_start|$jour_start|$liste_ligne";
			if ($fp=fopen($ficEcoStationstart,'a')) {
				fwrite($fp, $contFic);
				fclose($fp);
			}
		}
	}
}

//suppression d'une ligne dans le fichier ecoStations_start.txt
function supprLigneEcoStationstart($numligne,$peda_dmz,$_ip) {
	global $ficEcoStationstart;

	if($numligne!=0) {// on ne supprime pas l'entête du fichier ie la ligne 0.
		$fp = fopen($ficEcoStationstart, 'r');
		$contenu = fread($fp, filesize($ficEcoStationstart));
		fclose($fp);

		$contenu = explode(PHP_EOL, $contenu); // PHP_EOL contient le saut à la ligne utilisé sur le serveur (\n linux, \r\n windows ou \r Macintosh
		foreach($numligne as $val) {
			unset($contenu[$val]); // On supprime la ou les lignes
		}
		$contenu = array_values($contenu); // Ré-indexe l'array

		if(count($contenu)!=1) {//s'il reste plus que la ligne d'entête, on reconstruit le tout et on l'écrit
			$contenu = implode(PHP_EOL, $contenu);
			$fp = fopen($ficEcoStationstart, 'w');
			fwrite($fp, $contenu);
			fclose($fp);
		} else {//s'il ne reste que l'entête, on supprime le fichier
			unlink($ficEcoStationstart);
			ecritConfstart($peda_dmz,$_ip,'off');
			supprcron();
		}
	}
}

//insertion des données du fichier ecoStations_start.txt dans le planificateur dans le cas d'une modification
function modifLigneEcoStationstart($numligne) {
	global $ficEcoStationstart;
	global $horaireplan;
	global $stationplan;
	global $jourplan;
	global $verroumodif;

	if($numligne!=0) {// on ne modifie pas l'entête du fichier ie la ligne 0.
		$fp = fopen($ficEcoStationstart, 'r');
		$contenu = fread($fp, filesize($ficEcoStationstart));
		fclose($fp);
		//affichage des données dans le planificateur
		$contenu = explode(PHP_EOL, $contenu);
		$valligne = explode("|",$contenu[$numligne[0]]);
		$horaireplan = $valligne[0];
		$jourplan = explode(",",$valligne[1]);
		$stationplan = explode(", ", $valligne[2]);
		$verroumodif = 1;
	}
}

//activation ou desactivation de la planification d'arret
function activestop($_hor1,$_hor2,$_etat) {
	//désactivation
	if ($_etat=='on') {
		ecritConfHoraires($_hor1,$_hor2,'off');
		//suppression des cron
		supprcronstop();
	//activation
	} else {
		ecritConfHoraires($_hor1,$_hor2,'on');
		lanceModifCron();
	}
}

//activation ou desactivation de la planification de démarrage
function activeplan($peda_dmz,$_ip,$_etat) {
	//désactivation
	if ($_etat=='on') {
		ecritConfstart($peda_dmz,$_ip,'off');
		//suppression des cron
		supprcron();
	//activation
	} else {
		ecritConfstart($peda_dmz,$_ip,'on');
		lanceModifCronstart();
	}
}

//importation du tableau des planifications programmées de démarrage
function tabplanstart($fichier,$_etat) {
	global $nbplan;
	global $verroumodif;
	global $verrouajout;
	global $verroumodifparam;

	//si une programmation existe, le fichier existe
	if(file_exists($fichier)) {
		if(filesize($fichier) != 0) { //si le fichier n'est pas vide
			//on renvoie chaque ligne du fichier dans un tableau $lignes
			$lignes = file($fichier);
			//si la panification est activée
			if ($_etat=='on') {
				$statut = 'activée';
				$action = 'Désactiver';
			//sinon
			} else {
				$statut = 'désactivée';
				$action = 'Activer';
			}
			echo '<h2>Planification '.$statut.' </h2>';
			echo '<table class="tabeco">';
			echo '<th style="text-align:center;width:25px;"></th>';
			echo '<th style="text-align:center;width:60px;">Horaire</th>';
			echo '<th style="text-align:center;width:165px;">Jours</th>';
			echo '<th style="text-align:left;">Stations à démarrer</th>';
			echo '</tr>';
 			foreach($lignes as $ligne_num => $ligne) { // on lit le tableau de façon séquentielle
				//on n'insère pas la ligne d'entête
				if ($ligne_num!=0){
					$array = explode('|', $ligne); // retire le séparateur
					echo '<tr>';
					//si on est en modification, on verrouille les checkbox
					if ($verroumodif == 1 || $verroumodifparam == 1 || $verrouajout == 1){
						//on coche la case de la planification à modifier
						if ($ligne_num==$_POST['num_prog'][0]){
							echo '<td style="text-align:center;"><input type="checkbox" id="check'.$ligne_num.'" name="num_prog[]" value="'.$ligne_num.'" checked="checked" disabled="disabled" /></td>';
						} else {
							echo '<td style="text-align:center;"><input type="checkbox" id="check'.$ligne_num.'" name="num_prog[]" value="'.$ligne_num.'" disabled="disabled" /></td>';
						}
					//sinon les checkbox sont vierges et actives
					} else {
						echo '<td style="text-align:center;"><input type="checkbox" id="check'.$ligne_num.'" name="num_prog[]" value="'.$ligne_num.'"/></td>';
					}
					echo '<td style="text-align:center;">'. $array[0] .'</td>';
					echo '<td style="text-align:center;">'. $array[1] .'</td>';
					echo '<td>'. $array[2] .'</td>';
					echo '</tr>';
				}
			}
			echo '</table>';
			//nombre total de planifications
			$nbplan=$ligne_num;
			//----------- boutons Modifier, Supprimer, Activation -------------
			//si on est en modification, on verrouille les boutons
			if ($verroumodif == 1 || $verroumodifparam == 1 || $verrouajout == 1){
				echo '<center>';
				echo '<input type="submit" id="_ajoutstart" name="ajoutstart" value="Ajouter" style="margin-right:20px;" disabled="disabled"><input type="submit" id="_modifstart" name="modifstart" value="Modifier" style="margin-right:20px;" disabled="disabled"><input type="submit" id="_supprstart" name="supprstart" value="Supprimer" style="margin-right:20px;" disabled="disabled"><input type="submit" id="_btactiveplan" name="btactiveplan" value="'.$action.'" disabled="disabled">';
				echo '</center>';
				echo '<br/>';
			// sinon les boutons sont actifs
			} else {
				echo '<center>';
				echo '<input type="submit" id="_ajoutstart" name="ajoutstart" value="Ajouter" style="margin-right:20px;" onClick="videcheck()" title="Créer une nouvelle programmation de démarrage"><input type="submit" id="_modifstart" name="modifstart" value="Modifier" style="margin-right:20px;" onClick="return verifmodif();" title="Modifier une programmation de démarrage existante"><input type="submit" style="margin-right:20px;" id="_supprstart" name="supprstart" value="Supprimer" onClick="return verifsuppr();" title="Supprimer une ou plusieurs programmation(s) de démarrage"><input type="submit" id="_btactiveplan" name="btactiveplan" value="'.$action.'" onClick="return previentPerteSauve()" title="Activer ou désactiver la planification sans supprimer les programmations enregistrées">';
				echo '</center>';
				echo '<br/>';
			}
		} else { // si le fichier est vide
			echo '<br/>Le fichier de configuration ne contient aucun enregistrement.';
		}
	//si aucune programmation n'existe
	} else {
		echo '<h2>Planification désactivée</h2>';
		echo 'Aucune programmation de démarrage des stations n\'est planifiée<br/><br/>';
		//si on est en modification, on verrouille le bouton
		if ($verroumodif == 1 || $verroumodifparam == 1 || $verrouajout == 1){
			echo '<center><input type="submit" id="_ajoutstart" name="ajoutstart" value="Ajouter" disabled="disabled"></center>';
		// sinon le bouton est actif
		} else {
			echo '<center><input type="submit" id="_ajoutstart" name="ajoutstart" value="Ajouter" title="Créer une nouvelle programmation de démarrage"></center>';
		}
		echo '<br/>';
	}
}

//lance le script qui copie du fichier /usr/share/eole/controlevnc/machines.db dans le répertoire /config
function copieMachinesdb() {
	global $chemBaseAppli;
	system("sudo ".$chemBaseAppli."/copieFicMachinesDB.pl");
	$fic='config/copie_machines.db';
	$id_fichier = fopen($fic,"r");
	$contenu = fread($id_fichier, filesize($fic));
	fclose($id_fichier);

	$json = json_decode($contenu);
	$content = "";
	foreach($json as $lan => $devices) {
        	$ip = '';
		$nom = $devices->id;
		foreach($devices->hwaddr_interfaces as $hwdesc => $addmac){
			if ($addmac != ":::::" && $addmac != "00:00:00:00:00:00") {
				$mac=$addmac;
				foreach($devices->ip4_interfaces as $ipdesc => $ipv4){
					if ($ipdesc == $hwdesc) {
						$ip=$ipv4[0];
						break;
					}
				}
				break;
			}
		}
		if ( $ip == '' ) continue;
		$content .= $nom.";".$ip.";".$mac."\n";
	}
	$id_fichier = fopen($fic,"w");
	fwrite($id_fichier, $content);
	fclose($id_fichier);

}

//lance le script qui effectue les modif sur le cron à partir du fichier de config ecoStations.txt
function lanceModifCron() {
	global $chemBaseAppli;
	system("sudo ".$chemBaseAppli."/IecoStations.pl");
	//echo "perl ./IecoStations.pl";
}

//lance le script qui effectue les modif sur le cron à partir du fichier de config ecoStations_start.txt
function lanceModifCronstart() {
	global $chemBaseAppli;
	system("sudo ".$chemBaseAppli."/IecoStations_start.pl");
}

function supprcron() {
	global $chemBaseAppli;
	system("sudo ".$chemBaseAppli."/suppr_cron.pl");
}

function supprcronstop() {
	global $chemBaseAppli;
	system("sudo ".$chemBaseAppli."/suppr_cron_stop.pl");
}

//------------------------------- partie toujours exécutée ----------------------------------
$chemBaseAppli=dirname(__FILE__)."/.."; //dossier au dessus du dossier courant (au dessus de incAppli)
?>
