<?php
/*---------------------------------------------------------------
		calend.php
-----------------------------------------------------------------
	Affichage et édition du Calendrier
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon   
---------------------------------------------------------------*/
include ('./inc/f_session_scribe.inc.php');
include ('./inc/f_ldap_scribe.inc.php');
//initialisation de la Session et recup de l'uid
recupUid();

//verifie si l'utilisateur connecté est du login ou du groupe mis dans la liste (eleve, professeur, etc...)
//verifAccesPage("admin", "professeur");//"admin","olivier.hacquard");

include ('./inc/f_scribe.inc.php');

//-- gestion des paramètres et des droits --
require ('./inc/c_parametres.inc.php');
require ('./inc/f_droits.inc.php');

require ('./inc/f_onglets.inc.php');
require ('./inc/f_selectUser.inc.php');
require ('./inc/c_gestCollecParam.inc.php');

//include ('./inc/_defconst.inc.php');
include ('./incAppli/f_cal.inc.php');

include('./inc/c_tabHTML.old.inc.php');
litTousLesParams();

$titrePage="Calendrier d'empêchement de l'allumage des postes";

define('ONMS_OV', "OnMouseOver");
define('ONMS_MV', "OnMouseMove");
define('ONMS_OU', "OnMouseOut");
define('ONMS_U', "OnMouseUp");
define('ONMS_D', "OnMouseDown");
define('ONMS_C', "OnClick");
define('ONK_D', "OnKeyDown");
define('ALI', "align");
define('CEN', "center");

//------------------- Controler ----------------------

//print_r($_POST);//exit();
//print_r($_params);
$_nbMois=litParam('nbMois');
$_mois=litParam('premMois');
$_nbMoisTotal=litParam('nbMoisTotal');

//si pas encore défini dans la base, on le fait
if ($_nbMois===false) {$_nbMois=10; ecritParam('nbMois',$_nbMois);}
if ($_mois===false) {$_mois=9; ecritParam('premMois',$_mois);}
if ($_nbMoisTotal===false) {$_nbMoisTotal=12; ecritParam('nbMoisTotal',$_nbMoisTotal);}

//prise en compte d'éventuel paramètre en ligne de commande	
if (isset($_GET['annee'])) $_annee=$_GET['annee'];
if (isset($_GET['mois'])) $_mois=$_GET['mois'];
if (isset($_GET['nbMois'])) $_nbMois=$_GET['nbMois'];
if (isset($_GET['nbMoisTotal'])) $_nbMoisTotal=$_GET['nbMoisTotal'];
if ($_GET['mode']=="edition") $edition=true; else $edition=false; //edition ou affichage (par défaut)

$tabDate=getdate();
//print_r($tabDate);

if ($_mois!="") $moisAff=$_mois;
else { // si pas de mois défini
	$moisAff=9; //septembre par défaut
}
if ($_annee!="") $anneeAff=$_annee;
else { // si pas d'année définie
	$anneeAff=$tabDate['year'];
	if ($_mois=="") if ($tabDate['mon']<=8) $anneeAff--; //départ à l'année précédente si mois<8 (avant Août)
}
if ($_nbMois!="") $nbMoisAff=$_nbMois;
else { // si le nb de mois n'est pas défini
	$nbMoisAff=10;
}
if ($_nbMoisTotal!="") $nbMoisTotal=$_nbMoisTotal;
else { // si le nb de mois total n'est pas défini
	$nbMoisTotal=12;
}
if ($nbMoisAff>12) $nbMoisAff=12; //limite à 12 mois
if ($anneeAff<1970) $anneeAff=1970; //limite l'année à 1970 au minimum
//echo ' '.$nbMoisAff.'>'.$nbMoisTotal.' ';
if ($nbMoisAff>$nbMoisTotal) $nbMoisTotal=$nbMoisAff; //limite au minimum au nombre de mois affichés

// --- sauvegarde des paramètres ---
$changeMois=false;
if (isset($_POST['valMois'])) { //on change la config du nombre de mois
	$changeMois=true;
	$_nbMois=$nbMoisAff=$_POST['selNbMois'];
	$_mois=$moisAff=$_POST['selPremMois'];
	$_nbMoisTotal=$nbMoisTotal=$_POST['selNbMoisTotal'];
	ecritParam('nbMois',$_POST['selNbMois']);
	ecritParam('premMois',$_POST['selPremMois']);
	ecritParam('nbMoisTotal',$_POST['selNbMoisTotal']);
	//echo ($_POST['selNbMois'].'/'.$_POST['selPremMois']);
} else if (isset($_POST['sauveTab_x'])) { //on enregistre un calendrier
	foreach($_POST as $_key=>$_val) { //on prépare le tableau pour l'enregistrement
		if (substr($_key, 0,4)=="lig_") {
			$_numLig=substr($_key,4);
			$tLegJours[$_numLig]=explode('-', $_val);
		}
	}
	//print_r($tLegJours);
	ecritCalendrier($anneeAff, $moisAff, $nbMoisAff, $tLegJours);
}

if (isset($_GET['mode'])) {
	//if (($_GET['mode']=='supprAnnee') && isset($_GET['annee'])) supprimeCalendrierAnnee($_GET['annee']);
	if (($_GET['mode']=='supprAnnee') && isset($_GET['annee'])) supprimeCalendrier($anneeAff, $moisAff, $nbMoisAff);
}

$anneePrec=$anneeAff;
$moisPrec=$moisAff-$nbMoisTotal;
if ($moisPrec<1) {$moisPrec+=12; $anneePrec--;}
$lienPrec="annee=$anneePrec&mois=$moisPrec";
$anneeSuiv=$anneeAff;
$moisSuiv=$moisAff+$nbMoisTotal;
if ($moisSuiv>12) {$moisSuiv-=12; $anneeSuiv++;}
$lienSuiv="annee=$anneeSuiv&mois=$moisSuiv";

$affAnnees=$anneeAff;
if ($moisAff+$nbMoisAff-1>12) $affAnnees.='/'.($anneeAff+1);

//définition du mode Edition si reception de la variable modeEdition en POST
$modeEdition=false;
$medit=true; //force le mode édition             $medit=false;
if (isset($_POST['_modeEdition'])) if ($_POST['_modeEdition']==1) $medit=true;
if (isset($_GET['mode'])) if ($_GET['mode']=="ed" || $forceModeEd) $medit=true;

//---------------------------------- Module ---------------------------------------------------

//------------------- View -------------------------
headerPage();
enteteHTML($titrePage,array("./jquery/jquery.min.js",
                            "./jquery/js/jquery-ui.min.js",
                            "./bootstrap/css/bootstrap.min.css",
                            "./bootstrap/js/bootstrap.min.js",                             
                            "./incAppli/calend.js",
                            "./jquery/css/smoothness/jquery-ui.min.css",
                            "./inc/scribe.css",
                            "./inc/tabHTML.css",
                            "./incAppli/calend.css",
                            "./inc/onglets.css",
                            "./inc/droits.css",
                            "./inc/collecParam.css",
                            "./images/pFavicon.ico.png"));


//init javascript du tableau des dates
echo "<script language=\"JavaScript\">initTabDatesSel(31, $nbMoisAff);nbMoisAff=$nbMoisAff;</script>".CRLF;

echo '<div style="text-align:center">'.CR;// id="contGlobal">'.CR;

//titre de la page
echo cadreTitrePage($titrePage);

//afichage des icônes retour et param
/*
$icoRetour=$icoParam='';
//si pas en mode édition, il y a un bouton de retour
if (!$medit) $icoRetour=icoRetour("../param.php?onglet=5");
//si on a les droits d'éditer, on peut administrer
if ($uid=='admin' || verifDroit(EDITER_CALSCOL)) $icoParam=codeJQIconeParam("./param.php", 2);
if ($icoParam!='' || $icoRetour!='') echo '<div id="contIcones">'.$icoRetour.'&nbsp;&nbsp;'.$icoParam.'</div>';
*/
echo '<div id="contIcones">'.icoRetour("./ecoStations.php?onglet=2",'Retour à la page précédente','if (dejaAfficheDoitSauver) if (!confirm("Des modifications n\'ont pas été enregistrées !\nEtes vous sûr de vouloir quitter ?")) return false;').'</div>';

//if ($retour!="") echo $retour; //affichage de la fenêtre d'avertissement ou changement de page si nécessaire

//divAideDroit();
//prepareDivAide(1, '&nbsp;Donne la liste des utilisateurs ayant le droit décrit dans l\'<b>intitulé</b>.<br /><br />&nbsp;Cette liste peut contenir :<br />&nbsp;&nbsp;- des <u>noms d\'utilisateur</u><br />&nbsp;&nbsp;- des <u>catégorie générales</u> (<b>professeurs, élèves, administratifs, autres ou responsables</b>)<br />&nbsp;&nbsp;- des <u>groupes de sélection</u> déclarés dans le système.<br /><br />Pour ajouter ou modifier les membres de cette liste, utiliser le bouton <b>Ajouter/modifier</b>.<br/><br/>');

//prepareDivInfoEff(250, 50, "#FF8040");
prepareDivLegende(150, 100, "#98FB98");
prepareDivCouleurs(250, 200);

echo '<h3 style="margin:30px 0 0 0">Indiquer les dates pour lesquelles il ne faut pas allumer les postes</h3>';
echo '<h4 style="margin:0 0 30px 0;font-weight:normal;font-style:italic;">Toute case non vide sera considérée comme une date à laquelle l\'allumage automatique des postes ne doit pas se faire.</h4>';

// élaboration du calendrier
//echo "$anneeAff, $moisAff, $nbMoisAff<br>";
$tabCalend=calculeCalendrier($anneeAff, $moisAff, $nbMoisAff);
$liensImportVacances=recupVacancesDeCalendrier($anneeAff, $moisAff, $nbMoisAff);
//print_r($tabCalend);
// lecture table - calendrier à afficher
$tabLegendeCalend=litCalendrier($anneeAff, $moisAff, $nbMoisAff);
//print_r($tabLegendeCalend);
echo '<form name="form1" method="POST" action="./calend.php?annee='.$anneeAff.'">';
echo "<input type=\"hidden\" name=\"action\" value=\"\">\n";
for ($lig=1; $lig<=31; $lig++) {
	echo "<input type=\"hidden\" name=\"lig_$lig\" id=\"ligH_$lig\" value=\"\">".CRLF;
}

if ($medit) {
	echo scriptJS("modeEdition=true;");
	echo "<input type=\"hidden\" name=\"_modeEdition\" value=\"1\">".CRLF;
	$modeEdition=true;
	$typeCursor="cursor:pointer;";
}

//indique si besoin qu'on est en mode édition
/*if ($modeEdition) {
	echo '<center><b><span style="background-color:#FFB080;font-size:1em;color:red">&nbsp;Calendrier : Mode édition&nbsp;'.'</span></b></center>'.CRLF;
}*/

//lecture des légendes dans la base
$tabLegende=litLegendes();

prepaLienFeries($tabCalend, $tabLegende);
//print_r($tabLegende);
fonctionsJSplaceWEetVacances();
/*
?>
<script language="JavaScript">
	function placeWeekend() {
		var laCoulFd=$("#L_2").css("background");
		var laCoul=$("#L_2").css("color");
		$(".laDate").each(function() {
			if (($(this).html().substring(0,2)=='Sa') || ($(this).html().substring(0,2)=='Di')) {
				$(this).parent().css("background",laCoulFd);
				$(this).parent().css("color",laCoul);
			}
		});
	}
	var cpt=0;
	function placeVacances(laDate) {
		var laCoulFd=$("#L_3").css("background");
		var laCoul=$("#L_3").css("color");
		$(".calDate").each(function() {
			if ($(this).attr('date')==laDate) {
				//if (cpt<5) alert(laDate);cpt++;
				$(this).css("background",laCoulFd);
				$(this).css("color",laCoul);
			}
		});
	}
</script>
<?php
*/
//init des variables JS stockant les infos 
$numLeg=1;
foreach ($tabLegende as $idx=>$tabVal) {
	$tabLegende[$idx]['numOrdre']=$numLeg;
	$source.="t_legende[$numLeg]=new Array(5);
t_legende[$numLeg][COULEUR]='".$tabLegende[$idx]['couleur']."';
t_legende[$numLeg][COULEURTXT]='".$tabLegende[$idx]['couleurTxt']."';
t_legende[$numLeg][LEGENDE]='".$tabLegende[$idx]['legende']."';
t_legende[$numLeg][TXTCOURT]='".$tabLegende[$idx]['txtCourt']."';
t_legende[$numLeg][NUM_LEGENDE]=$idx;
";
	$numLeg++;
}
echo scriptJS($source).CRLF;

//init des variables JS pour la sélection et la couleur par défaut
echo scriptJS("legendeEnCours=0;couleurSel='".$tabLegende[0]['couleur']."';txtSel='".$tabLegende[0]['txtCourt']."';couleurTxt='".$tabLegende[0]['couleurTxt']."';");
//donnée correpondant à la base de remplissage (couleur blanc, vide);

prepareDivAide(1,'&nbsp;&nbsp;Les vacances scolaires sont importées de l\'application <b>Calendrier</b>.<br/><br/>&nbsp;&nbsp;Il peut y avoir un (ou plusieurs) Calendriers contenant une catégorie <i>Vacances</i>.<br/><br/>&nbsp;&nbsp;Un lien permet de choisir la source des dates de vacances à importer.<br/><br/><br/>');


// affiche le calendrier de l'année définie -----------------------------------------------------



$numAnnee=1;
$nbMoisEnTout=0;
foreach ($tabCalend as $an => $tabAnnee) {
	$nbMoisAnnee[$numAnnee]=count($tabCalend[$an]);
	$nbMoisEnTout+=count($tabCalend[$an]);
	$numAnnee++;
}
//echo $nbMoisEnTout;
$tabComplet=new tableau_HTML_OLD($nbMoisEnTout);
//$tabMois=new tableau_HTML(2);

$col=$lig=1;
$numAnnee=1;
$chaineMoisAnnees="";
$contenu="";
foreach ($tabCalend as $an => $tabAnnee) {
	$tab[0][$numAnnee-1]=$an;
	//$tab[0][$numAnnee][FMT]=tabOptionVal(COLSPAN, $nbMoisAnnee[$numAnnee], ALI, CEN, BGC, "#B0D0FF");
	
	foreach ($tabAnnee as $mo => $tabJours) {
		$tDate[$col]=array('annee'=>$an, 'mois'=>$mo);
		$tab[1][$col-1]=$tabMois[$mo];
		$chaineMoisAnnees.=sprintf("%04d-%02d_", $an, $mo);
		//$tab[1][$col-1][FMT]=tabOptionVal("style", "background-color:#80D0A0;", WID, "70", ALI, CEN);
		foreach ($tabJours as $date => $jour) {
			$laDate=sprintf("%04d-%02d-%02d", $an, $mo, $date);
			if (isset($tabLegendeCalend[$laDate])) $numLegende=$tabLegendeCalend[$laDate];
			else $numLegende=1;
			
			$_case='<div class="laDate">'.$jour.' '.$date.'<div class="txtCourt" id="C2_'.$date.'_'.$col.'">'.$tabLegende[$numLegende]['txtCourt'].'</div></div>'; 
			$tab[$date+2][$col-1]=$_case;
			
			$contenu.="tabDatesSel[$date][$col]=$numLegende;".CR;
		}
		$col++;
	}
	$numAnnee++;
}
echo scriptJS($contenu);

//évite qu'un clique entre les cases du tableau ne provoque une sélection
echo scriptJS('$(function() {
	$("#tabCalendrier").mousedown(function() {
			selectDate(ONMSD, 0, 0);
			}).mouseup(function() {
			selectDate(ONMSU, 0, 0);
			}).mouseout(function() {
			selectDate(ONMSOU, 0, 0);
			}).mouseover(function() {
			selectDate(ONMSOV, 0, 0);
			})
});');
//print_r($tab);
$tabComplet->ajouteLignes($tab);
if (is_array($nbMoisAnnee)) foreach ($nbMoisAnnee as $_numAn=>$_nb) {
	$tabComplet->formatCellule(1,$_numAn,'colspan',$_nb,'class','calAnnee');
}
$tabComplet->formatTableau('id','tabCalendrier');
$tabComplet->formatLigneParCellule(2,'class', 'calMois');
$_class1='calDate cPtr'; $_class2='calDate';
if ($medit) $_class=$_class1; else $_class=$_class2;
for ($lig=1; $lig<=31; $lig++) {
	$tabComplet->formatLigne($lig+2, 'class', 'calLigneJour');
	$tId=array();
	for ($col=1;$col<$nbMoisEnTout+1; $col++) {
		$laDate=sprintf("%04d-%02d-%02d", $tDate[$col]['annee'], $tDate[$col]['mois'], $lig);
		if (isset($tabLegendeCalend[$laDate])) $numLegende=$tabLegendeCalend[$laDate];
		else $numLegende=1;
		$_id='C_'.$lig.'_'.$col;
		//echo $laDate.'/';
		//echo 'if (tabCalend['.$tDate[$col]['annee'].']['.$tDate[$col]['mois'].']['.$lig.']) -> '.(isset($tabCalend[$tDate[$col]['annee']][$tDate[$col]['mois']][$lig])?$_id:'0').BRCR;
		if ($medit) {
			if (!isset($tabCalend[$tDate[$col]['annee']][$tDate[$col]['mois']][$lig])) $_class=$_class2; 
			else $_class=$_class1; 	
		}
		$tId[]=array('id',$_id,'lig',$lig,'col',$col,'date',$laDate, 'class',$_class, 'style','background:'.$tabLegende[$numLegende]['couleur'].';color:'.$tabLegende[$numLegende]['couleurTxt']); //,'class','calMois');
	}
	//print_r($tId);
	
	$tabComplet->formatLigneParMultiCellule($lig+2,$tId);
}
//print_r($tab);	
?>
<div><input type="text" id="_leTxt" value="" style="width:500px;display:none"/></div>
<script language="JavaScript">
	var lig=1,col=1;
	function calculeLigCol(objCase) {
		lig=objCase.attr("lig"); //.substring(9);
		col=objCase.attr("col"); //.substring(9);
	}
	legendeEnCours=0;
	$(function() {
		//$("#_case*").click(function() {alert("cool");} );
		//$("[id^='_case']").click(function() {
		$(".cPtr").mousedown(function() {
		  			calculeLigCol($(this));
		  			selectDate(ONMSD, lig, col);
		  			//alert("lig:"+lig+" col:"+col);
		  		}).mouseup(function() {
		  			calculeLigCol($(this));
		  			selectDate(ONMSU, lig, col);
		  			//alert("up");
		  		}).mouseout(function() {
		  			calculeLigCol($(this));
		  			selectDate(ONMSOU, lig, col);
		  			//alert("quitte");
		  		}).mouseover(function() {
		  			calculeLigCol($(this));
		  			selectDate(ONMSOV, lig, col);
		  			//alert("quitte");
		  		})/*.click(function() {
		  		//lig=$(this).attr("lig"); //.substring(9);
		  		//col=$(this).attr("col"); //.substring(9);
		  		calculeLigCol($(this));
		  		alert(lig+" - "+col);
		  		})*/;
	});
</script>
<div onMouseUp="inSelect=false;" onMouseDown="if (legendeEnCours!=0)	inSelect=true;" id="calendrier">
<?php

// affiche l'année et les fleches de navigation dans les années -------------------------------------------------
if ($medit) $phModeEdit="mode=ed&";
echo '<table align="center" width="700"><tr>'.CRLF;
echo '<td id="_dskSauve" width="26" align="left">';
if ($modeEdition) echo '<image src="./images/disketteG.gif" />'; else echo '&nbsp;';
echo '</td>'.CRLF;
echo '<td id="_txtSauve" width="224" align="left">'.'&nbsp;'.'</td>'.CRLF;
echo '<td width="200" align="center"><input type="button" value="<<" onClick="window.location=\'calend.php?'.$phModeEdit.$lienPrec.'\'">'.'&nbsp;'.'&nbsp;'.CRLF;
echo '<b>'.$affAnnees.'</b>'.'&nbsp;'.'&nbsp;'.CRLF;
echo '<input type="button" value=">>" onClick="window.location=\'calend.php?'.$phModeEdit.$lienSuiv.'\'"></td>'.CRLF;
echo '<td align="right"></td>'.CRLF; //width="250" <a href="'.$codeJSRetour.'"><image src="../images/sortie.gif" border="0"'.' title="'.$txtRetour.'" />
echo '</tr></table>'.CRLF;

echo $tabComplet->rendu(); 
echo '</div>'.CRLF;

//prépare le passage d'une chaine contenant les suite de annee-mois correspondant au calendrier
echo '<input type="hidden" name="moisAnnees" value="'.$chaineMoisAnnees.'">';
echo '<center>';
if ($modeEdition) {
?>	
	<script language="JavaScript"></script>
	<a href="#" onClick="placeWeekend();return false">Placer les week-end</a>
	<a href="#" onClick="placeJoursFeries();return false" style="margin:0 0 0 50px">Placer les jours fériés</a>
	<a href="#" onClick="$('#importVacances').slideToggle();if ($('#changeConfigMois').css('display')!='none') $('#changeConfigMois').slideToggle();return false;" style="margin:0 0 0 50px">Placer les vacances</a> <?php echo iconeAide(1);?>
		
	<a href="#" onClick="$('#changeConfigMois').slideToggle();if ($('#importVacances').css('display')!='none') $('#importVacances').slideToggle();return false;" style="margin:0 0 0 50px">Changer la configuration des mois</a>
	
	<div id="changeConfigMois" style="display:none">
		<i><b>Changer la configuration des mois affichés dans le calendrier</b></i><br/>
		<!--<form action="./calend.php" method="POST"> -->
		<div style="margin:10px 0 0 0">
			nombre de mois affichés : <select  style="padding:0px;margin:0px" name="selNbMois">
			<option value="1"<?php echo ($nbMoisAff==1?" SELECTED":""); ?> >1</option>
			<option value="2"<?php echo ($nbMoisAff==2?" SELECTED":""); ?> >2</option>
			<option value="3"<?php echo ($nbMoisAff==3?" SELECTED":""); ?> >3</option>
			<option value="4"<?php echo ($nbMoisAff==4?" SELECTED":""); ?> >4</option>
			<option value="5"<?php echo ($nbMoisAff==5?" SELECTED":""); ?> >5</option>
			<option value="6"<?php echo ($nbMoisAff==6?" SELECTED":""); ?> >6</option>
			<option value="7"<?php echo ($nbMoisAff==7?" SELECTED":""); ?> >7</option>
			<option value="8"<?php echo ($nbMoisAff==8?" SELECTED":""); ?> >8</option>
			<option value="9"<?php echo ($nbMoisAff==9?" SELECTED":""); ?> >9</option>
			<option value="10"<?php echo ($nbMoisAff==10?" SELECTED":""); ?> >10</option>
			<option value="11"<?php echo ($nbMoisAff==11?" SELECTED":""); ?> >11</option>
			<option value="12"<?php echo ($nbMoisAff==12?" SELECTED":""); ?> >12</option>
		</select>
		<span style="margin:0 0 0 50px"></span>premier mois affiché : <select name="selPremMois">
			<option value="1"<?php echo ($moisAff==1?" SELECTED":""); ?> >Janvier</option>
			<option value="2"<?php echo ($moisAff==2?" SELECTED":""); ?> >Février</option>
			<option value="3"<?php echo ($moisAff==3?" SELECTED":""); ?> >Mars</option>
			<option value="4"<?php echo ($moisAff==4?" SELECTED":""); ?> >Avril</option>
			<option value="5"<?php echo ($moisAff==5?" SELECTED":""); ?> >Mai</option>
			<option value="6"<?php echo ($moisAff==6?" SELECTED":""); ?> >Juin</option>
			<option value="7"<?php echo ($moisAff==7?" SELECTED":""); ?> >Juillet</option>
			<option value="8"<?php echo ($moisAff==8?" SELECTED":""); ?> >Août</option>
			<option value="9"<?php echo ($moisAff==9?" SELECTED":""); ?> >Septembre</option>
			<option value="10"<?php echo ($moisAff==10?" SELECTED":""); ?> >Octobre</option>
			<option value="11"<?php echo ($moisAff==11?" SELECTED":""); ?> >Novembre</option>
			<option value="12"<?php echo ($moisAff==12?" SELECTED":""); ?> >Décembre</option>
		</select>
		<span style="margin:0 0 0 50px"></span>durée de la période complète : <select  style="padding:0px;margin:0px" name="selNbMoisTotal">
			<option value="1"<?php echo ($nbMoisTotal==1?" SELECTED":""); ?> >1</option>
			<option value="2"<?php echo ($nbMoisTotal==2?" SELECTED":""); ?> >2</option>
			<option value="3"<?php echo ($nbMoisTotal==3?" SELECTED":""); ?> >3</option>
			<option value="4"<?php echo ($nbMoisTotal==4?" SELECTED":""); ?> >4</option>
			<option value="5"<?php echo ($nbMoisTotal==5?" SELECTED":""); ?> >5</option>
			<option value="6"<?php echo ($nbMoisTotal==6?" SELECTED":""); ?> >6</option>
			<option value="7"<?php echo ($nbMoisTotal==7?" SELECTED":""); ?> >7</option>
			<option value="8"<?php echo ($nbMoisTotal==8?" SELECTED":""); ?> >8</option>
			<option value="9"<?php echo ($nbMoisTotal==9?" SELECTED":""); ?> >9</option>
			<option value="10"<?php echo ($nbMoisTotal==10?" SELECTED":""); ?> >10</option>
			<option value="11"<?php echo ($nbMoisTotal==11?" SELECTED":""); ?> >11</option>
			<option value="12"<?php echo ($nbMoisTotal==12?" SELECTED":""); ?> >12</option>
		</select>
		<input type="submit" value="Valider" name="valMois" style="margin:0 0 0 50px"/>
		</div>
		<!--</form>-->
	</div>
		
	<div id="importVacances" style="display:none"><?php echo $liensImportVacances;?></div>
	
	<div style="margin:30px 0 0 0;padding:10px;border:1px SOLID #456;width:800px;background:#789	"><b><i>Sélectionner une légende et appliquer la aux dates souhaitées dans le tableau en les cliquant</i></b><br/><br/>
<?php
}
	
//lien pour éditer le calendrier si c'est l'admin
//document.form1.action='calendrier.php?codeJSRetour=javascript:window.close()';
if (1) { //($uid=='admin' || verifDroit(EDITER_CALSCOL)) && !$modeEdition) {
?>
	<input type="hidden" name="_modeEdition" value="0">
	<input type="hidden" name="codeJSRetour" value="javascript:window.close()">
	<input type="hidden" name="txtRetour" value="Quitter l'édition du calendrier">
<!--
	<table align="center"><tr><td>
		<a href="javascript:fenCal=window.open('calend.php?mode=ed','calendrier','location=no,toolbar=no,menubar=no,scrollbars=yes, resizable=yes');fenCal.focus();" style="text-align:center;" >Editer le calendrier...</a>
	</td></tr></table>
-->
<?
}

$tabLegendes=new tableau_HTML_OLD(2*count($tabLegende));

//Affichage du tableau des légendes
$borderSelected="1px DASHED #000000";
$borderSurvol="1px SOLID #000000";
$borderNonsel="1px SOLID #FFFFFF";

//$tabLegende[4]['legende']="Semaine&nbsp;C";
$idxLeg=1;
$tabLeg=$tabFmtLeg=array();
foreach ($tabLegende as $idx=>$tabVal) {
	$idsLeg.="$idx, ";
	$laLegende=$tabVal['legende'];
	$tabLeg[1][$idxLeg]=$laLegende;
	$tabFmtLeg[$idxLeg]=array('class','caseLegende','style','background:'.$tabVal['couleur'].';border:'.$borderNonsel.';color:'.$tabVal['couleurTxt'].';'.$typeCursor.';', 'id', 'L_'.$idx,
		ONMS_OV, "selectLegende(ONMSOV, $idx);",
		ONMS_OU, "selectLegende(ONMSOU, $idx);",
		ONMS_C, "legendeEnCours=$idx;couleurSel='".$tabVal['couleur']."';couleurTxt='".$tabVal['couleurTxt']."';txtSel='".$tabVal['txtCourt']."';selectLegende(ONMSC, $idx);"
		); 
		//,		"onDblClick", "selectLegende(ONMSDC, $idx);");

	$tabFmtLeg[$idxLeg+1]=array('class', 'interLegende'); //zone inter légende
	$idxLeg+=2;
}	//foreach
//print_r($tabLeg);
//init des variables javascript pour le fonctionnement du script de sélection de la légende
$idsLeg=substr($idsLeg, 0, strlen($idsLeg)-2);
echo "<script langage=\"JavaScript\">tabIdLeg=Array($idsLeg);borderSelected='$borderSelected';borderSurvol='$borderSurvol';borderNonsel='$borderNonsel';</script>";
//print_r($tabFmtLeg);
$tabLegendes->ajouteLignes($tabLeg);
$tabLegendes->formatLigneParMultiCellule(1,$tabFmtLeg);
echo $tabLegendes->rendu().'</div>'.CR;

if ($modeEdition) {
//	echo '<div style="background-color:#ADD8E6;border:1px solid lightGrey;padding:5px 10px 22px 10px;font-size:0.8em;font-style:italic;width:500px;">Sélectionner la légende à appliquer - Double-cliquer pour éditer ou ajouter</div>';
	echo "<div style='margin:30px 0 0 0'><a href=\"?mode=supprAnnee&annee=".$anneeAff."\" onMouseDown=\"if(confirm('Etes-vous certain de vouloir supprimer les légendes de cette année dans le calendrier ?')) window.location='?mode=supprAnnee&annee=".$anneeAff."'\">Supprimer le calendrier de l'année affichée</a></div>
	</center>";
}
echo '</center>';


echo '</form></div>'.CR;

finHTML();

?>

 
 
