from creole.client import CreoleClient
from pyeole.process import system_out
from creole.loader import creole_loader, config_save_values
from socket import gethostbyname
from os import system

c = CreoleClient()
domaine_messagerie_etab = c.get_creole('domaine_messagerie_etab')


def exim_cmd(mail, exp_out, exp_err):
    code, out, err = system_out(['exim', '-bt', mail])
    assert code == 0
    assert exp_out.strip() == out.strip()
    assert exp_err.strip() == err.strip()


def test_mail_eleve():
    out = """prenom.eleve112@i-{0} -> /home/mail/prenom.eleve112/
  transport = directory_ldap
""".format(domaine_messagerie_etab)
    err = """R: private_input for prenom.eleve112@i-{0}
R: sympa_aliases for prenom.eleve112@i-{0}
R: ldap_route for prenom.eleve112@i-{0}""".format(domaine_messagerie_etab)
    exim_cmd("prenom.eleve112@i-" + domaine_messagerie_etab, out, err)


def test_mail_prof():
    out = """test.prof@{} -> /home/mail/test.prof/
  transport = directory_ldap""".format(domaine_messagerie_etab)
    err = """R: sympa_aliases for test.prof@{0}
R: ldap_route for test.prof@{0}""".format(domaine_messagerie_etab)
    exim_cmd("test.prof@" + domaine_messagerie_etab, out, err)


def test_mail_exterieur():
    out = """info@fsf.org
  router = satellite_route, transport = remote_smtp
  host socrate.in.ac-dijon.fr [{}]""".format(gethostbyname('socrate.in.ac-dijon.fr'))
    err = """R: private_output for info@fsf.org
R: ldap_route for info@fsf.org
R: satellite_route for info@fsf.org"""
    exim_cmd("info@fsf.org", out, err)


def test_mail_exterieur_no_gateway():
    config = creole_loader(rw=True)
    config.creole.messagerie.activer_exim_relay_smtp = 'non'
    try:
        config.creole.messagerie.exim_relay_smtp
    except:
        pass
    else:
        raise Exception('la variable exim_relay_smtp ne devrait pas etre accessible')
    config_save_values(config, 'creole')
    system('reconfigure')
    out = """info@fsf.org
  router = internet_route, transport = remote_smtp
  host mail.fsf.org [2001:470:142::13] MX=10
  host mail.fsf.org [{}]    MX=10""".format(gethostbyname('mail.fsf.org'))
    err = """R: private_output for info@fsf.org
R: ldap_route for info@fsf.org
R: internet_route for info@fsf.org"""
    error = None
    try:
        exim_cmd("info@fsf.org", out, err)
    except Exception, erro:
        error = erro
    config.creole.messagerie.activer_exim_relay_smtp = 'oui'
    config_save_values(config, 'creole')
    system('reconfigure')
    if error is not None:
        raise error
