# -*- coding: utf-8 -*-
'''
Support for Linux File Access Control Lists
'''
from creole.client import CreoleClient as _CreoleClient
from os.path import abspath as _abspath
_DIRECTORIES = _CreoleClient().get('.quota.quota.directories')

CSV_QUOTA_MAPPING = {
         "block-status":"BlockStatus",
         "file-status":"FileStatus",
         "block-used":"BlockUsed",
         "block-soft-limit":"BlockSoftLimit",
         "block-hard-limit":"BlockHardLimit",
         "block-grace":"BlockGrace",
         "file-used":"FileUsed",
         "file-soft-limit":"FileSoftLimit",
         "file-hard-limit":"FileHardLimit",
         "file-grace":"FileGrace",
        }


def _parse_quota(path, quota_type):
    " Utilisateur,BlockStatus,FileStatus,BlockUsed,BlockSoftLimit,BlockHardLimit,BlockGrace,FileUsed,FileSoftLimit,FileHardLimit,FileGrace"
    cmd = 'repquota -O csv -vp {0} {1}'.format(quota_type, path)
    out = __salt__['cmd.run'](cmd, python_shell=False).splitlines()
    header = out[0].split(',')
    quotas = out[1:]

    if '-u' in quota_type:
        quotatype = 'Users'
    elif '-g' in quota_type:
        quotatype = 'Groups'
    ret = {quotatype: {}}

    for line in quotas:
        comps = line.split(',')
        if not comps[0] in ret[quotatype]:
            ret[quotatype][comps[0]] = {}
        for info in CSV_QUOTA_MAPPING:
            ret[quotatype][comps[0]][info] = comps[header.index(CSV_QUOTA_MAPPING[info])]
    return ret


def report(path, **kwargs):
    path = _abspath(path)
    for directory in _DIRECTORIES:
        if path.startswith(directory):
            break
    else:
        return
    ret = {path: {}}
    ret[path]['User Quotas'] = _parse_quota(path, '-u')
    ret[path]['Group Quotas'] = _parse_quota(path, '-g')
    return ret


def set(path, **kwargs):
    path = _abspath(path)
    for directory in _DIRECTORIES:
        if path.startswith(directory):
            break
    else:
        return
    pass
    empty = {'block-soft-limit': 0, 'block-hard-limit': 0,
             'file-soft-limit': 0, 'file-hard-limit': 0}

    current = None
    cmd = 'setquota'
    if 'user' in kwargs:
        cmd += ' -u {0} '.format(kwargs['user'])
        parsed = _parse_quota(path, '-u')
        if kwargs['user'] in parsed:
            current = parsed['Users'][kwargs['user']]
        else:
            current = empty
        ret = 'User: {0}'.format(kwargs['user'])

    if 'group' in kwargs:
        if 'user' in kwargs:
            raise SaltInvocationError(
                'Please specify a user or group, not both.'
            )
        cmd += ' -g "{0}" '.format(kwargs['group'])
        parsed = _parse_quota(path, '-g')
        if kwargs['group'] in parsed:
            current = parsed['Groups'][kwargs['group']]
        else:
            current = empty
        ret = 'Group: "{0}"'.format(kwargs['group'])

    if not current:
        raise CommandExecutionError('A valid user or group was not found')

    for limit in ('block-soft-limit', 'block-hard-limit',
                  'file-soft-limit', 'file-hard-limit'):
        if limit in kwargs:
            current[limit] = kwargs[limit]

    cmd += '{0} {1} {2} {3} {4}'.format(current['block-soft-limit'],
                                        current['block-hard-limit'],
                                        current['file-soft-limit'],
                                        current['file-hard-limit'],
                                        path)

    result = __salt__['cmd.run_all'](cmd, python_shell=False)
    if result['retcode'] != 0:
        raise CommandExecutionError(
            'Unable to set desired quota. Error follows: \n{0}'
            .format(result['stderr'])
        )
    return {ret: current}

def initialised(path, **kwargs):
    path = _abspath(path)
    for directory in _DIRECTORIES:
        if path.startswith(directory):
            break
    else:
        return
    return __salt__['file.file_exists'](path)
