import json
from flask import make_response, request, url_for
from os.path import join

APPS_CONF_DIR = "/etc/eole/flask/"
APPS_ENABLE_DIR = join(APPS_CONF_DIR, 'enabled')
"""Directory of enabled eoleflask applications
"""

def make_json_response(body, status_code=200):
    resp = make_response(json.dumps(body))
    resp.status_code = status_code
    resp.mimetype = 'application/json'
    return resp

def make_error_response(msg, status_code=400):
    resp = make_response(msg)
    resp.status_code = status_code
    resp.mimetype = 'text/plain'
    return resp

def bad_id_response():
    return make_error_response("Invalid ID", 400)

def get_proxy_url(request, url):
    if request.environ.get("HTTP_X_FORWARDED_PROTO", "") == "https" and url.startswith("http://"):
        url = url.replace("http://", "https://", 1)
    return url
