# -*- coding: utf-8 -*-
# Documentation is at http://docs.gunicorn.org/en/latest/configure.html#config-file
#Server Socket
# The socket to bind.
# A string of the form: ‘HOST’, ‘HOST:PORT’, ‘unix:PATH’. An IP is a valid HOST.
# Multiple addresses can be bound.
bind = '127.0.0.1:5000'

#The maximum number of pending connections.
#This refers to the number of clients that can be waiting to be served.
#Exceeding this number results in the client getting an error when attempting to connect.
#It should only affect servers under significant load.
backlog = '2048'
#end Socket

#Server Mechanics
# Daemonize the Gunicorn process.
daemon = 'True'
# Pid File name
pidfile = '/run/eoleflask.pid'

#Worker handling
# The number of worker process for handling requests.
# A positive integer generally in the 2-4 x $(NUM_CORES) range
workers = '1'
# one of [ sync eventlet gevent tornado ]
worker_class = 'eventlet'
# The maximum number of simultaneous clients
worker_connections = '100'

# The maximum number of requests a worker will process before restarting
# If this is set to zero (the default) then the automatic worker restarts are disabled
max_requests = '0'

# Workers silent for more than this many seconds are killed and restarted.
timeout = '120'

# Timeout for graceful workers restart.
graceful_timeout = '30'

# The number of seconds to wait for requests on a Keep-Alive connection.
# Generally set in the 1-5 seconds range.
keepalive = '2'
#End Worker

#Security
# The maximum size of HTTP request line in bytes
limit_request_line = '4094'

# Limit the number of HTTP headers fields in a request
limit_request_field = '100'

# Limit the allowed size of an HTTP request header field
limit_request_field_size = '8190'
#End Security

#Log haddling
# one of [ debug info warning error critical ]
loglevel = 'info'
# files
accesslog = '/var/log/eoleflask/gunicorn-access.log'
errorlog = '/var/log/eoleflask/gunicorn-error.log'
#End log
