<?php

/**
 * Copyright (C) 2008-2012 FluxBB
 * based on code by Rickard Andersson copyright (C) 2002-2008 PunBB
 * License: http://www.gnu.org/licenses/gpl.html GPL version 2 or higher
 */

if (isset($_GET['action']))
	define('PUN_QUIET_VISIT', 1);

//define('PUN_ROOT', dirname(__FILE__).'/');
define('PUN_ROOT', './'); // modification EOLE
require PUN_ROOT.'include/common.php';

// ajout EOLE
function cas_auth(){
	require_once('CAS-1.3.1/eoleCAS.php');
	require_once('configCAS/cas.inc.php');

	if (__CAS_DEBUG){
		EolephpCAS::setDebug('/var/log/posh/phpCAS-fluxbb.log');
	}
	
	EolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, true);
	
	
	if (__CAS_VALIDER_CA) {
	  EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
	} else {
	  if (method_exists('EolephpCAS', 'setNoCasServerValidation')){
		  EolephpCAS::setNoCasServerValidation();
	  }
	}
	
	if (__CAS_LOGOUT){
		if (method_exists('EolephpCAS', 'eoleLogoutRequests')){
			EolephpCAS::eoleLogoutRequests();
		}
	}
	
	EolephpCAS::forceAuthentication();
}

function cas_logout(){
	require_once('CAS-1.3.1/eoleCAS.php');
	require_once('configCAS/cas.inc.php');

	session_unset();
	if (__CAS_DEBUG){
		EolephpCAS::setDebug('/var/log/posh/phpCAS-fluxbb.log');
	}
	
	EolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, true);


	if (__CAS_VALIDER_CA) {
		EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
	}
	else {
		if (method_exists('EolephpCAS', 'setNoCasServerValidation')){
			EolephpCAS::setNoCasServerValidation();
		}
	}

	if (method_exists('EolephpCAS', 'eoleLogoutRequests')){
		EolephpCAS::eoleLogoutRequests();
	}
	
	
	
	$orig_url = $_SERVER['SCRIPT_URI'];
	$url = str_replace('login.php', 'index.php', $orig_url);
	EolephpCAS::logout(array('url'=>$url));
}

$action=$_GET["action"];

// If cas logoutRequest is detected, terminate the corresponding session
if (isset($_REQUEST['logoutRequest'])) {
	preg_match("/<samlp:SessionIndex>(ST-[0-9]+-[^<]+)<\/samlp:SessionIndex>/", $_REQUEST['logoutRequest'], $regs);
	error_log("[FluxBB] Info : CAS tells that session ".$regs[1]." is ended !");
	$id_ticket_cas_deconnecte = $regs[1];
	$action="out";
}


// ajout EOLE
if ($action != "out" )
{
	session_start();
	cas_auth();

	$USER=EolephpCAS::getUser();
	$attributs=array();
	$attributs=EolephpCAS::getDetails();

	$_POST['req_password'] = "fluxbb";

	// Load the login.php language file
	require PUN_ROOT.'lang/'.$pun_user['language'].'/login.php';

	$action = isset($_GET['action']) ? $_GET['action'] : null;	
	
	$form_username = $USER;
	$form_password = pun_trim($_POST['req_password']);
	$save_pass = isset($_POST['save_pass']);
	$username_sql = ($db_type == 'mysql' || $db_type == 'mysqli' || $db_type == 'mysql_innodb' || $db_type == 'mysqli_innodb') ? 'username=\''.$db->escape($form_username).'\'' : 'LOWER(username)=LOWER(\''.$db->escape($form_username).'\')';
	$result = $db->query('SELECT * FROM '.$db->prefix.'users WHERE '.$username_sql) or error('Unable to fetch user info', __FILE__, __LINE__, $db->error());
	
	
	// ajout EOLE (autocreate)
	$num_rows = $db->num_rows($result);
	if($num_rows == 0){
		$password_hash = pun_hash($form_password);
		// Add the user
		// Insert the new user into the database. We do this now to get the last inserted ID for later use
		$now = time();
		if($attributs['utilisateur']['profil'][0]=="National_1"){
			// On crée un élève
			$db->query('INSERT INTO '.$db->prefix.'users (username, group_id, password, email, email_setting, timezone, dst, language, style, registered, registration_ip, last_visit) VALUES(\''.$db->escape($USER).'\',4, \''.$password_hash.'\', \'\',1,0,0, \'French\', \'Air\', '.$now.', \''.get_remote_address().'\', '.$now.')') or error('Unable to create user', __FILE__, __LINE__, $db->error());
		}elseif ($attributs['utilisateur']['profil'][0]=="National_3") {
			// On crée un professeur
			$db->query('INSERT INTO '.$db->prefix.'users (username, group_id, password, email, email_setting, timezone, dst, language, style, registered, registration_ip, last_visit) VALUES(\''.$db->escape($USER).'\',2, \''.$password_hash.'\', \'\',1,0,0, \'French\', \'Air\', '.$now.', \''.get_remote_address().'\', '.$now.')') or error('Unable to create user', __FILE__, __LINE__, $db->error());
		}
		else {
			$db->query('INSERT INTO '.$db->prefix.'users (username, group_id, password, email, email_setting, timezone, dst, language, style, registered, registration_ip, last_visit) VALUES(\''.$db->escape($USER).'\',4, \''.$password_hash.'\', \'\',1,0,0, \'French\', \'Air\', '.$now.', \''.get_remote_address().'\', '.$now.')') or error('Unable to create user', __FILE__, __LINE__, $db->error());
		}
	}

	$result = $db->query('SELECT * FROM '.$db->prefix.'users WHERE '.$username_sql) or error('Unable to fetch user info', __FILE__, __LINE__, $db->error());
	$cur_user = $db->fetch_assoc($result);
	$authorized = true;

	$form_password_hash = pun_hash($form_password); // Will result in a SHA-1 hash
	$db->query('UPDATE '.$db->prefix.'users SET password=\''.$form_password_hash.'\' WHERE id='.$cur_user['id']) or error('Unable to update user password', __FILE__, __LINE__, $db->error());
	// fin de l'ajout EOLE
    
	if (!$authorized)
		message($lang_login['Wrong user/pass'].' <a href="login.php?action=forget">'.$lang_login['Forgotten pass'].'</a>');

	// Update the status if this is the first time the user logged in
	if ($cur_user['group_id'] == PUN_UNVERIFIED)
	{
		$db->query('UPDATE '.$db->prefix.'users SET group_id='.$pun_config['o_default_user_group'].' WHERE id='.$cur_user['id']) or error('Unable to update user status', __FILE__, __LINE__, $db->error());

		// Regenerate the users info cache
		if (!defined('FORUM_CACHE_FUNCTIONS_LOADED'))
			require PUN_ROOT.'include/cache.php';

		generate_users_info_cache();
	}

	// Remove this user's guest entry from the online list
	$db->query('DELETE FROM '.$db->prefix.'online WHERE ident=\''.$db->escape(get_remote_address()).'\'') or error('Unable to delete from online list', __FILE__, __LINE__, $db->error());

	$expire = ($save_pass == '1') ? time() + 1209600 : time() + $pun_config['o_timeout_visit'];
	pun_setcookie($cur_user['id'], $form_password_hash, $expire);

	// Reset tracked topics
	set_tracked_topics(null);


	// ajout EOLE
	$redirect_url = (isset($_SERVER['HTTP_REFERER']) && preg_match('#^'.preg_quote($pun_config['o_base_url']).'/(.*?)\.php#i', $_SERVER['HTTP_REFERER'])) ? htmlspecialchars($_SERVER['HTTP_REFERER']) : $pun_config['o_base_url'].'/index.php';
	// fin de l'ajout EOLE
	if($_GET['afterlogin']!="") {
		$redirect_url=str_replace('index.php',$_GET['afterlogin'],$redirect_url);
	}

	redirect(pun_htmlspecialchars($redirect_url), $lang_login['Login redirect']);
}


else if ($action == 'out')
{
	// Remove user from "users online" list
	$db->query('DELETE FROM '.$db->prefix.'online WHERE user_id='.$pun_user['id']) or error('Unable to delete from online list', __FILE__, __LINE__, $db->error());

	// Update last_visit (make sure there's something to update it with)
	if (isset($pun_user['logged']))
		$db->query('UPDATE '.$db->prefix.'users SET last_visit='.$pun_user['logged'].' WHERE id='.$pun_user['id']) or error('Unable to update user visit data', __FILE__, __LINE__, $db->error());

	pun_setcookie(1, pun_hash(uniqid(rand(), true)), time() + 31536000);
	
	cas_logout();
	
	redirect('index.php', $lang_login['Logout redirect']);
}

if (!$pun_user['is_guest'])
{
	header('Location: index.php');
	exit;
}

$page_title = array(pun_htmlspecialchars($pun_config['o_board_title']), $lang_common['Login']);
$required_fields = array('req_username' => $lang_common['Username'], 'req_password' => $lang_common['Password']);
$focus_element = array('login', 'req_username');
define('PUN_ACTIVE_PAGE', 'login');
require PUN_ROOT.'header.php';

?>
<div class="blockform">
	<h2><span><?php echo $lang_common['Login'] ?></span></h2>
	<div class="box">
		<form id="login" method="post" action="login.php?action=in" onsubmit="return process_form(this)">
			<div class="inform">
				<fieldset>
					<legend><?php echo $lang_login['Login legend'] ?></legend>
					<div class="infldset">
						<input type="hidden" name="form_sent" value="1" />
						<input type="hidden" name="redirect_url" value="<?php echo pun_htmlspecialchars($redirect_url) ?>" />
						<label class="conl required"><strong><?php echo $lang_common['Username'] ?> <span><?php echo $lang_common['Required'] ?></span></strong><br /><input type="text" name="req_username" size="25" maxlength="25" tabindex="1" /><br /></label>
						<label class="conl required"><strong><?php echo $lang_common['Password'] ?> <span><?php echo $lang_common['Required'] ?></span></strong><br /><input type="password" name="req_password" size="25" tabindex="2" /><br /></label>

						<div class="rbox clearb">
							<label><input type="checkbox" name="save_pass" value="1" tabindex="3" /><?php echo $lang_login['Remember me'] ?><br /></label>
						</div>

						<p class="clearb"><?php echo $lang_login['Login info'] ?></p>
						<p class="actions"><span><a href="register.php" tabindex="5"><?php echo $lang_login['Not registered'] ?></a></span> <span><a href="login.php?action=forget" tabindex="6"><?php echo $lang_login['Forgotten pass'] ?></a></span></p>
					</div>
				</fieldset>
			</div>
			<p class="buttons"><input type="submit" name="login" value="<?php echo $lang_common['Login'] ?>" tabindex="4" /></p>
		</form>
	</div>
</div>
<?php

require PUN_ROOT.'footer.php';
