define(['vent','marionette','templates','views/VariableView'],
function(vent,Marionette,templates,VariableView){
  'use strict';

  return Marionette.Layout.extend({

    tagName: 'tr',
    className: '',
    template: templates.variableRowView,

    ui: {
      tooltip: '.tooltip_trigger',
      error: '.alert-error',
      warning: '.alert-warning'
    },

    regions: {
      view: '.view',
    },

    initialize: function(){
      this.bindTo(this.model, 'error', this.error, this);
      this.bindTo(this.model, 'error:cancel', this.errorCancel, this);
    },

    onRender: function(){
      this.ui.tooltip.tooltip();
      this.ui.error.hide();
      if(typeof VariableView === 'undefined') VariableView = require('views/VariableView');
      this.view.show(new VariableView(_.extend(this.options, { model: this.model })));
    },

    error: function(msg){
      this.ui.error.show();
      this.ui.error.find('.msg').text(msg);
    },

    errorCancel: function(msg){
      this.ui.error.find('.msg').empty();
      this.ui.error.hide();
    },

    serializeData: function(){
      return _.extend(Marionette.View.prototype.serializeData.call(this), {
        breadcrumbs: this.options.breadcrumbs || false,
        debug: this.options.debug
      });
    },

    templateHelpers: {
      getMode: function(){
        switch(this.mode){
          case 'basic': return 'B'; break;
          case 'normal': return 'N'; break;
          case 'expert': return 'E'; break;
          default: return 'N';
        }
      }
    }
  });
});
