define(['vent','marionette','templates'],
function(vent,Marionette,templates){
  'use strict';

  return Marionette.ItemView.extend({

    tagName: 'div',
    className: 'modal hide fade small',
    template: templates.errorView,

    events: {
      'click .reload'      : 'reload',
      'click .closeDialog' : 'closeDialog'
    },

    initialize: function(){
      var html = this.model.get('responseText').replace(/\n/g, "<br />");
      this.model.set('responseText', html);
    },

    reload: function(){
      this.$el.modal('hide');
      window.location.reload();
    }, 

    closeDialog: function(){
      this.$el.modal('hide');
      this.remove();
    }
  });
});
