import json
from flask import make_response, request


def make_json_response(body, status_code=200):
    resp = make_response(json.dumps(body))
    resp.status_code = status_code
    resp.mimetype = 'application/json'
    return resp


def make_error_response(msg, status_code=500, to_json=False):
    if(to_json): msg = json.dumps(msg)
    resp = make_response(msg)
    resp.status_code = status_code
    resp.mimetype = ('application/json','text/plain')[to_json]
    return resp


def bad_id_response():
    return make_error_response("Invalid ID", 400)


