<?php


/**
 * Base class that represents a row from the 'edt_semaines' table.
 *
 * Liste des semaines de l'annee scolaire courante - 53 enregistrements obligatoires (pas 52!), pour lesquel on assigne un type (A ou B par exemple)
 *
 * @package    propel.generator.gepi.om
 */
abstract class BaseEdtSemaine extends BaseObject  implements Persistent
{

	/**
	 * Peer class name
	 */
	const PEER = 'EdtSemainePeer';

	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        EdtSemainePeer
	 */
	protected static $peer;

	/**
	 * The flag var to prevent infinit loop in deep copy
	 * @var       boolean
	 */
	protected $startCopy = false;

	/**
	 * The value for the id_edt_semaine field.
	 * @var        int
	 */
	protected $id_edt_semaine;

	/**
	 * The value for the num_edt_semaine field.
	 * @var        int
	 */
	protected $num_edt_semaine;

	/**
	 * The value for the type_edt_semaine field.
	 * @var        string
	 */
	protected $type_edt_semaine;

	/**
	 * The value for the num_semaines_etab field.
	 * @var        int
	 */
	protected $num_semaines_etab;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Get the [id_edt_semaine] column value.
	 * cle primaire
	 * @return     int
	 */
	public function getIdEdtSemaine()
	{
		return $this->id_edt_semaine;
	}

	/**
	 * Get the [num_edt_semaine] column value.
	 * numero de la semaine dans l'annee civile
	 * @return     int
	 */
	public function getNumEdtSemaine()
	{
		return $this->num_edt_semaine;
	}

	/**
	 * Get the [type_edt_semaine] column value.
	 * typiquement, champ egal a 'A' ou 'B' pour l'alternance des semaines
	 * @return     string
	 */
	public function getTypeEdtSemaine()
	{
		return $this->type_edt_semaine;
	}

	/**
	 * Get the [num_semaines_etab] column value.
	 * numero de la semaine propre a l'etablissement
	 * @return     int
	 */
	public function getNumSemainesEtab()
	{
		return $this->num_semaines_etab;
	}

	/**
	 * Set the value of [id_edt_semaine] column.
	 * cle primaire
	 * @param      int $v new value
	 * @return     EdtSemaine The current object (for fluent API support)
	 */
	public function setIdEdtSemaine($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->id_edt_semaine !== $v) {
			$this->id_edt_semaine = $v;
			$this->modifiedColumns[] = EdtSemainePeer::ID_EDT_SEMAINE;
		}

		return $this;
	} // setIdEdtSemaine()

	/**
	 * Set the value of [num_edt_semaine] column.
	 * numero de la semaine dans l'annee civile
	 * @param      int $v new value
	 * @return     EdtSemaine The current object (for fluent API support)
	 */
	public function setNumEdtSemaine($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->num_edt_semaine !== $v) {
			$this->num_edt_semaine = $v;
			$this->modifiedColumns[] = EdtSemainePeer::NUM_EDT_SEMAINE;
		}

		return $this;
	} // setNumEdtSemaine()

	/**
	 * Set the value of [type_edt_semaine] column.
	 * typiquement, champ egal a 'A' ou 'B' pour l'alternance des semaines
	 * @param      string $v new value
	 * @return     EdtSemaine The current object (for fluent API support)
	 */
	public function setTypeEdtSemaine($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->type_edt_semaine !== $v) {
			$this->type_edt_semaine = $v;
			$this->modifiedColumns[] = EdtSemainePeer::TYPE_EDT_SEMAINE;
		}

		return $this;
	} // setTypeEdtSemaine()

	/**
	 * Set the value of [num_semaines_etab] column.
	 * numero de la semaine propre a l'etablissement
	 * @param      int $v new value
	 * @return     EdtSemaine The current object (for fluent API support)
	 */
	public function setNumSemainesEtab($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->num_semaines_etab !== $v) {
			$this->num_semaines_etab = $v;
			$this->modifiedColumns[] = EdtSemainePeer::NUM_SEMAINES_ETAB;
		}

		return $this;
	} // setNumSemainesEtab()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->id_edt_semaine = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->num_edt_semaine = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->type_edt_semaine = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->num_semaines_etab = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			return $startcol + 4; // 4 = EdtSemainePeer::NUM_HYDRATE_COLUMNS.

		} catch (Exception $e) {
			throw new PropelException("Error populating EdtSemaine object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(EdtSemainePeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = EdtSemainePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(EdtSemainePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}

		$con->beginTransaction();
		try {
			$deleteQuery = EdtSemaineQuery::create()
				->filterByPrimaryKey($this->getPrimaryKey());
			$ret = $this->preDelete($con);
			if ($ret) {
				$deleteQuery->delete($con);
				$this->postDelete($con);
				$con->commit();
				$this->setDeleted(true);
			} else {
				$con->commit();
			}
		} catch (Exception $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(EdtSemainePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}

		$con->beginTransaction();
		$isInsert = $this->isNew();
		try {
			$ret = $this->preSave($con);
			if ($isInsert) {
				$ret = $ret && $this->preInsert($con);
			} else {
				$ret = $ret && $this->preUpdate($con);
			}
			if ($ret) {
				$affectedRows = $this->doSave($con);
				if ($isInsert) {
					$this->postInsert($con);
				} else {
					$this->postUpdate($con);
				}
				$this->postSave($con);
				EdtSemainePeer::addInstanceToPool($this);
			} else {
				$affectedRows = 0;
			}
			$con->commit();
			return $affectedRows;
		} catch (Exception $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			if ($this->isNew() || $this->isModified()) {
				// persist changes
				if ($this->isNew()) {
					$this->doInsert($con);
				} else {
					$this->doUpdate($con);
				}
				$affectedRows += 1;
				$this->resetModified();
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Insert the row in the database.
	 *
	 * @param      PropelPDO $con
	 *
	 * @throws     PropelException
	 * @see        doSave()
	 */
	protected function doInsert(PropelPDO $con)
	{
		$modifiedColumns = array();
		$index = 0;


		 // check the columns in natural order for more readable SQL queries
		if ($this->isColumnModified(EdtSemainePeer::ID_EDT_SEMAINE)) {
			$modifiedColumns[':p' . $index++]  = 'ID_EDT_SEMAINE';
		}
		if ($this->isColumnModified(EdtSemainePeer::NUM_EDT_SEMAINE)) {
			$modifiedColumns[':p' . $index++]  = 'NUM_EDT_SEMAINE';
		}
		if ($this->isColumnModified(EdtSemainePeer::TYPE_EDT_SEMAINE)) {
			$modifiedColumns[':p' . $index++]  = 'TYPE_EDT_SEMAINE';
		}
		if ($this->isColumnModified(EdtSemainePeer::NUM_SEMAINES_ETAB)) {
			$modifiedColumns[':p' . $index++]  = 'NUM_SEMAINES_ETAB';
		}

		$sql = sprintf(
			'INSERT INTO edt_semaines (%s) VALUES (%s)',
			implode(', ', $modifiedColumns),
			implode(', ', array_keys($modifiedColumns))
		);

		try {
			$stmt = $con->prepare($sql);
			foreach ($modifiedColumns as $identifier => $columnName) {
				switch ($columnName) {
					case 'ID_EDT_SEMAINE':
						$stmt->bindValue($identifier, $this->id_edt_semaine, PDO::PARAM_INT);
						break;
					case 'NUM_EDT_SEMAINE':
						$stmt->bindValue($identifier, $this->num_edt_semaine, PDO::PARAM_INT);
						break;
					case 'TYPE_EDT_SEMAINE':
						$stmt->bindValue($identifier, $this->type_edt_semaine, PDO::PARAM_STR);
						break;
					case 'NUM_SEMAINES_ETAB':
						$stmt->bindValue($identifier, $this->num_semaines_etab, PDO::PARAM_INT);
						break;
				}
			}
			$stmt->execute();
		} catch (Exception $e) {
			Propel::log($e->getMessage(), Propel::LOG_ERR);
			throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
		}

		$this->setNew(false);
	}

	/**
	 * Update the row in the database.
	 *
	 * @param      PropelPDO $con
	 *
	 * @see        doSave()
	 */
	protected function doUpdate(PropelPDO $con)
	{
		$selectCriteria = $this->buildPkeyCriteria();
		$valuesCriteria = $this->buildCriteria();
		BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
	}

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = EdtSemainePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = EdtSemainePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getIdEdtSemaine();
				break;
			case 1:
				return $this->getNumEdtSemaine();
				break;
			case 2:
				return $this->getTypeEdtSemaine();
				break;
			case 3:
				return $this->getNumSemainesEtab();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 *                    Defaults to BasePeer::TYPE_PHPNAME.
	 * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
	 * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
	 *
	 * @return    array an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array())
	{
		if (isset($alreadyDumpedObjects['EdtSemaine'][$this->getPrimaryKey()])) {
			return '*RECURSION*';
		}
		$alreadyDumpedObjects['EdtSemaine'][$this->getPrimaryKey()] = true;
		$keys = EdtSemainePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getIdEdtSemaine(),
			$keys[1] => $this->getNumEdtSemaine(),
			$keys[2] => $this->getTypeEdtSemaine(),
			$keys[3] => $this->getNumSemainesEtab(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = EdtSemainePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setIdEdtSemaine($value);
				break;
			case 1:
				$this->setNumEdtSemaine($value);
				break;
			case 2:
				$this->setTypeEdtSemaine($value);
				break;
			case 3:
				$this->setNumSemainesEtab($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = EdtSemainePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setIdEdtSemaine($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setNumEdtSemaine($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setTypeEdtSemaine($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setNumSemainesEtab($arr[$keys[3]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(EdtSemainePeer::DATABASE_NAME);

		if ($this->isColumnModified(EdtSemainePeer::ID_EDT_SEMAINE)) $criteria->add(EdtSemainePeer::ID_EDT_SEMAINE, $this->id_edt_semaine);
		if ($this->isColumnModified(EdtSemainePeer::NUM_EDT_SEMAINE)) $criteria->add(EdtSemainePeer::NUM_EDT_SEMAINE, $this->num_edt_semaine);
		if ($this->isColumnModified(EdtSemainePeer::TYPE_EDT_SEMAINE)) $criteria->add(EdtSemainePeer::TYPE_EDT_SEMAINE, $this->type_edt_semaine);
		if ($this->isColumnModified(EdtSemainePeer::NUM_SEMAINES_ETAB)) $criteria->add(EdtSemainePeer::NUM_SEMAINES_ETAB, $this->num_semaines_etab);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(EdtSemainePeer::DATABASE_NAME);
		$criteria->add(EdtSemainePeer::ID_EDT_SEMAINE, $this->id_edt_semaine);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getIdEdtSemaine();
	}

	/**
	 * Generic method to set the primary key (id_edt_semaine column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setIdEdtSemaine($key);
	}

	/**
	 * Returns true if the primary key for this object is null.
	 * @return     boolean
	 */
	public function isPrimaryKeyNull()
	{
		return null === $this->getIdEdtSemaine();
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of EdtSemaine (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
	{
		$copyObj->setNumEdtSemaine($this->getNumEdtSemaine());
		$copyObj->setTypeEdtSemaine($this->getTypeEdtSemaine());
		$copyObj->setNumSemainesEtab($this->getNumSemainesEtab());
		if ($makeNew) {
			$copyObj->setNew(true);
			$copyObj->setIdEdtSemaine(NULL); // this is a auto-increment column, so set to default value
		}
	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     EdtSemaine Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     EdtSemainePeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new EdtSemainePeer();
		}
		return self::$peer;
	}

	/**
	 * Clears the current object and sets all attributes to their default values
	 */
	public function clear()
	{
		$this->id_edt_semaine = null;
		$this->num_edt_semaine = null;
		$this->type_edt_semaine = null;
		$this->num_semaines_etab = null;
		$this->alreadyInSave = false;
		$this->alreadyInValidation = false;
		$this->clearAllReferences();
		$this->resetModified();
		$this->setNew(true);
		$this->setDeleted(false);
	}

	/**
	 * Resets all references to other model objects or collections of model objects.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect
	 * objects with circular references (even in PHP 5.3). This is currently necessary
	 * when using Propel in certain daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all referrer objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
		} // if ($deep)

	}

	/**
	 * Return the string representation of this object
	 *
	 * @return string
	 */
	public function __toString()
	{
		return (string) $this->exportTo(EdtSemainePeer::DEFAULT_STRING_FORMAT);
	}

} // BaseEdtSemaine
