<?php


/**
 * Base class that represents a query for the 'etablissements' table.
 *
 * Liste des etablissements precedents des eleves
 *
 * @method     AncienEtablissementQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     AncienEtablissementQuery orderByNom($order = Criteria::ASC) Order by the nom column
 * @method     AncienEtablissementQuery orderByNiveau($order = Criteria::ASC) Order by the niveau column
 * @method     AncienEtablissementQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method     AncienEtablissementQuery orderByCp($order = Criteria::ASC) Order by the cp column
 * @method     AncienEtablissementQuery orderByVille($order = Criteria::ASC) Order by the ville column
 *
 * @method     AncienEtablissementQuery groupById() Group by the id column
 * @method     AncienEtablissementQuery groupByNom() Group by the nom column
 * @method     AncienEtablissementQuery groupByNiveau() Group by the niveau column
 * @method     AncienEtablissementQuery groupByType() Group by the type column
 * @method     AncienEtablissementQuery groupByCp() Group by the cp column
 * @method     AncienEtablissementQuery groupByVille() Group by the ville column
 *
 * @method     AncienEtablissementQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     AncienEtablissementQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     AncienEtablissementQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     AncienEtablissementQuery leftJoinJEleveAncienEtablissement($relationAlias = null) Adds a LEFT JOIN clause to the query using the JEleveAncienEtablissement relation
 * @method     AncienEtablissementQuery rightJoinJEleveAncienEtablissement($relationAlias = null) Adds a RIGHT JOIN clause to the query using the JEleveAncienEtablissement relation
 * @method     AncienEtablissementQuery innerJoinJEleveAncienEtablissement($relationAlias = null) Adds a INNER JOIN clause to the query using the JEleveAncienEtablissement relation
 *
 * @method     AncienEtablissement findOne(PropelPDO $con = null) Return the first AncienEtablissement matching the query
 * @method     AncienEtablissement findOneOrCreate(PropelPDO $con = null) Return the first AncienEtablissement matching the query, or a new AncienEtablissement object populated from the query conditions when no match is found
 *
 * @method     AncienEtablissement findOneById(int $id) Return the first AncienEtablissement filtered by the id column
 * @method     AncienEtablissement findOneByNom(string $nom) Return the first AncienEtablissement filtered by the nom column
 * @method     AncienEtablissement findOneByNiveau(string $niveau) Return the first AncienEtablissement filtered by the niveau column
 * @method     AncienEtablissement findOneByType(string $type) Return the first AncienEtablissement filtered by the type column
 * @method     AncienEtablissement findOneByCp(int $cp) Return the first AncienEtablissement filtered by the cp column
 * @method     AncienEtablissement findOneByVille(string $ville) Return the first AncienEtablissement filtered by the ville column
 *
 * @method     array findById(int $id) Return AncienEtablissement objects filtered by the id column
 * @method     array findByNom(string $nom) Return AncienEtablissement objects filtered by the nom column
 * @method     array findByNiveau(string $niveau) Return AncienEtablissement objects filtered by the niveau column
 * @method     array findByType(string $type) Return AncienEtablissement objects filtered by the type column
 * @method     array findByCp(int $cp) Return AncienEtablissement objects filtered by the cp column
 * @method     array findByVille(string $ville) Return AncienEtablissement objects filtered by the ville column
 *
 * @package    propel.generator.gepi.om
 */
abstract class BaseAncienEtablissementQuery extends ModelCriteria
{
	
	/**
	 * Initializes internal state of BaseAncienEtablissementQuery object.
	 *
	 * @param     string $dbName The dabase name
	 * @param     string $modelName The phpName of a model, e.g. 'Book'
	 * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
	 */
	public function __construct($dbName = 'gepi', $modelName = 'AncienEtablissement', $modelAlias = null)
	{
		parent::__construct($dbName, $modelName, $modelAlias);
	}

	/**
	 * Returns a new AncienEtablissementQuery object.
	 *
	 * @param     string $modelAlias The alias of a model in the query
	 * @param     Criteria $criteria Optional Criteria to build the query from
	 *
	 * @return    AncienEtablissementQuery
	 */
	public static function create($modelAlias = null, $criteria = null)
	{
		if ($criteria instanceof AncienEtablissementQuery) {
			return $criteria;
		}
		$query = new AncienEtablissementQuery();
		if (null !== $modelAlias) {
			$query->setModelAlias($modelAlias);
		}
		if ($criteria instanceof Criteria) {
			$query->mergeWith($criteria);
		}
		return $query;
	}

	/**
	 * Find object by primary key.
	 * Propel uses the instance pool to skip the database if the object exists.
	 * Go fast if the query is untouched.
	 *
	 * <code>
	 * $obj  = $c->findPk(12, $con);
	 * </code>
	 *
	 * @param     mixed $key Primary key to use for the query
	 * @param     PropelPDO $con an optional connection object
	 *
	 * @return    AncienEtablissement|array|mixed the result, formatted by the current formatter
	 */
	public function findPk($key, $con = null)
	{
		if ($key === null) {
			return null;
		}
		if ((null !== ($obj = AncienEtablissementPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
			// the object is alredy in the instance pool
			return $obj;
		}
		if ($con === null) {
			$con = Propel::getConnection(AncienEtablissementPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}
		$this->basePreSelect($con);
		if ($this->formatter || $this->modelAlias || $this->with || $this->select
		 || $this->selectColumns || $this->asColumns || $this->selectModifiers
		 || $this->map || $this->having || $this->joins) {
			return $this->findPkComplex($key, $con);
		} else {
			return $this->findPkSimple($key, $con);
		}
	}

	/**
	 * Find object by primary key using raw SQL to go fast.
	 * Bypass doSelect() and the object formatter by using generated code.
	 *
	 * @param     mixed $key Primary key to use for the query
	 * @param     PropelPDO $con A connection object
	 *
	 * @return    AncienEtablissement A model object, or null if the key is not found
	 */
	protected function findPkSimple($key, $con)
	{
		$sql = 'SELECT ID, NOM, NIVEAU, TYPE, CP, VILLE FROM etablissements WHERE ID = :p0';
		try {
			$stmt = $con->prepare($sql);
			$stmt->bindValue(':p0', $key, PDO::PARAM_INT);
			$stmt->execute();
		} catch (Exception $e) {
			Propel::log($e->getMessage(), Propel::LOG_ERR);
			throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
		}
		$obj = null;
		if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
			$obj = new AncienEtablissement();
			$obj->hydrate($row);
			AncienEtablissementPeer::addInstanceToPool($obj, (string) $key);
		}
		$stmt->closeCursor();

		return $obj;
	}

	/**
	 * Find object by primary key.
	 *
	 * @param     mixed $key Primary key to use for the query
	 * @param     PropelPDO $con A connection object
	 *
	 * @return    AncienEtablissement|array|mixed the result, formatted by the current formatter
	 */
	protected function findPkComplex($key, $con)
	{
		// As the query uses a PK condition, no limit(1) is necessary.
		$criteria = $this->isKeepQuery() ? clone $this : $this;
		$stmt = $criteria
			->filterByPrimaryKey($key)
			->doSelect($con);
		return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
	}

	/**
	 * Find objects by primary key
	 * <code>
	 * $objs = $c->findPks(array(12, 56, 832), $con);
	 * </code>
	 * @param     array $keys Primary keys to use for the query
	 * @param     PropelPDO $con an optional connection object
	 *
	 * @return    PropelObjectCollection|array|mixed the list of results, formatted by the current formatter
	 */
	public function findPks($keys, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
		}
		$this->basePreSelect($con);
		$criteria = $this->isKeepQuery() ? clone $this : $this;
		$stmt = $criteria
			->filterByPrimaryKeys($keys)
			->doSelect($con);
		return $criteria->getFormatter()->init($criteria)->format($stmt);
	}

	/**
	 * Filter the query by primary key
	 *
	 * @param     mixed $key Primary key to use for the query
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByPrimaryKey($key)
	{
		return $this->addUsingAlias(AncienEtablissementPeer::ID, $key, Criteria::EQUAL);
	}

	/**
	 * Filter the query by a list of primary keys
	 *
	 * @param     array $keys The list of primary key to use for the query
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByPrimaryKeys($keys)
	{
		return $this->addUsingAlias(AncienEtablissementPeer::ID, $keys, Criteria::IN);
	}

	/**
	 * Filter the query on the id column
	 *
	 * Example usage:
	 * <code>
	 * $query->filterById(1234); // WHERE id = 1234
	 * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
	 * $query->filterById(array('min' => 12)); // WHERE id > 12
	 * </code>
	 *
	 * @param     mixed $id The value to use as filter.
	 *              Use scalar values for equality.
	 *              Use array values for in_array() equivalent.
	 *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
	 * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterById($id = null, $comparison = null)
	{
		if (is_array($id) && null === $comparison) {
			$comparison = Criteria::IN;
		}
		return $this->addUsingAlias(AncienEtablissementPeer::ID, $id, $comparison);
	}

	/**
	 * Filter the query on the nom column
	 *
	 * Example usage:
	 * <code>
	 * $query->filterByNom('fooValue');   // WHERE nom = 'fooValue'
	 * $query->filterByNom('%fooValue%'); // WHERE nom LIKE '%fooValue%'
	 * </code>
	 *
	 * @param     string $nom The value to use as filter.
	 *              Accepts wildcards (* and % trigger a LIKE)
	 * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByNom($nom = null, $comparison = null)
	{
		if (null === $comparison) {
			if (is_array($nom)) {
				$comparison = Criteria::IN;
			} elseif (preg_match('/[\%\*]/', $nom)) {
				$nom = str_replace('*', '%', $nom);
				$comparison = Criteria::LIKE;
			}
		}
		return $this->addUsingAlias(AncienEtablissementPeer::NOM, $nom, $comparison);
	}

	/**
	 * Filter the query on the niveau column
	 *
	 * Example usage:
	 * <code>
	 * $query->filterByNiveau('fooValue');   // WHERE niveau = 'fooValue'
	 * $query->filterByNiveau('%fooValue%'); // WHERE niveau LIKE '%fooValue%'
	 * </code>
	 *
	 * @param     string $niveau The value to use as filter.
	 *              Accepts wildcards (* and % trigger a LIKE)
	 * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByNiveau($niveau = null, $comparison = null)
	{
		if (null === $comparison) {
			if (is_array($niveau)) {
				$comparison = Criteria::IN;
			} elseif (preg_match('/[\%\*]/', $niveau)) {
				$niveau = str_replace('*', '%', $niveau);
				$comparison = Criteria::LIKE;
			}
		}
		return $this->addUsingAlias(AncienEtablissementPeer::NIVEAU, $niveau, $comparison);
	}

	/**
	 * Filter the query on the type column
	 *
	 * Example usage:
	 * <code>
	 * $query->filterByType('fooValue');   // WHERE type = 'fooValue'
	 * $query->filterByType('%fooValue%'); // WHERE type LIKE '%fooValue%'
	 * </code>
	 *
	 * @param     string $type The value to use as filter.
	 *              Accepts wildcards (* and % trigger a LIKE)
	 * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByType($type = null, $comparison = null)
	{
		if (null === $comparison) {
			if (is_array($type)) {
				$comparison = Criteria::IN;
			} elseif (preg_match('/[\%\*]/', $type)) {
				$type = str_replace('*', '%', $type);
				$comparison = Criteria::LIKE;
			}
		}
		return $this->addUsingAlias(AncienEtablissementPeer::TYPE, $type, $comparison);
	}

	/**
	 * Filter the query on the cp column
	 *
	 * Example usage:
	 * <code>
	 * $query->filterByCp(1234); // WHERE cp = 1234
	 * $query->filterByCp(array(12, 34)); // WHERE cp IN (12, 34)
	 * $query->filterByCp(array('min' => 12)); // WHERE cp > 12
	 * </code>
	 *
	 * @param     mixed $cp The value to use as filter.
	 *              Use scalar values for equality.
	 *              Use array values for in_array() equivalent.
	 *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
	 * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByCp($cp = null, $comparison = null)
	{
		if (is_array($cp)) {
			$useMinMax = false;
			if (isset($cp['min'])) {
				$this->addUsingAlias(AncienEtablissementPeer::CP, $cp['min'], Criteria::GREATER_EQUAL);
				$useMinMax = true;
			}
			if (isset($cp['max'])) {
				$this->addUsingAlias(AncienEtablissementPeer::CP, $cp['max'], Criteria::LESS_EQUAL);
				$useMinMax = true;
			}
			if ($useMinMax) {
				return $this;
			}
			if (null === $comparison) {
				$comparison = Criteria::IN;
			}
		}
		return $this->addUsingAlias(AncienEtablissementPeer::CP, $cp, $comparison);
	}

	/**
	 * Filter the query on the ville column
	 *
	 * Example usage:
	 * <code>
	 * $query->filterByVille('fooValue');   // WHERE ville = 'fooValue'
	 * $query->filterByVille('%fooValue%'); // WHERE ville LIKE '%fooValue%'
	 * </code>
	 *
	 * @param     string $ville The value to use as filter.
	 *              Accepts wildcards (* and % trigger a LIKE)
	 * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByVille($ville = null, $comparison = null)
	{
		if (null === $comparison) {
			if (is_array($ville)) {
				$comparison = Criteria::IN;
			} elseif (preg_match('/[\%\*]/', $ville)) {
				$ville = str_replace('*', '%', $ville);
				$comparison = Criteria::LIKE;
			}
		}
		return $this->addUsingAlias(AncienEtablissementPeer::VILLE, $ville, $comparison);
	}

	/**
	 * Filter the query by a related JEleveAncienEtablissement object
	 *
	 * @param     JEleveAncienEtablissement $jEleveAncienEtablissement  the related object to use as filter
	 * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByJEleveAncienEtablissement($jEleveAncienEtablissement, $comparison = null)
	{
		if ($jEleveAncienEtablissement instanceof JEleveAncienEtablissement) {
			return $this
				->addUsingAlias(AncienEtablissementPeer::ID, $jEleveAncienEtablissement->getIdEtablissement(), $comparison);
		} elseif ($jEleveAncienEtablissement instanceof PropelCollection) {
			return $this
				->useJEleveAncienEtablissementQuery()
				->filterByPrimaryKeys($jEleveAncienEtablissement->getPrimaryKeys())
				->endUse();
		} else {
			throw new PropelException('filterByJEleveAncienEtablissement() only accepts arguments of type JEleveAncienEtablissement or PropelCollection');
		}
	}

	/**
	 * Adds a JOIN clause to the query using the JEleveAncienEtablissement relation
	 *
	 * @param     string $relationAlias optional alias for the relation
	 * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function joinJEleveAncienEtablissement($relationAlias = null, $joinType = Criteria::INNER_JOIN)
	{
		$tableMap = $this->getTableMap();
		$relationMap = $tableMap->getRelation('JEleveAncienEtablissement');

		// create a ModelJoin object for this join
		$join = new ModelJoin();
		$join->setJoinType($joinType);
		$join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
		if ($previousJoin = $this->getPreviousJoin()) {
			$join->setPreviousJoin($previousJoin);
		}

		// add the ModelJoin to the current object
		if($relationAlias) {
			$this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
			$this->addJoinObject($join, $relationAlias);
		} else {
			$this->addJoinObject($join, 'JEleveAncienEtablissement');
		}

		return $this;
	}

	/**
	 * Use the JEleveAncienEtablissement relation JEleveAncienEtablissement object
	 *
	 * @see       useQuery()
	 *
	 * @param     string $relationAlias optional alias for the relation,
	 *                                   to be used as main alias in the secondary query
	 * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
	 *
	 * @return    JEleveAncienEtablissementQuery A secondary query class using the current class as primary query
	 */
	public function useJEleveAncienEtablissementQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
	{
		return $this
			->joinJEleveAncienEtablissement($relationAlias, $joinType)
			->useQuery($relationAlias ? $relationAlias : 'JEleveAncienEtablissement', 'JEleveAncienEtablissementQuery');
	}

	/**
	 * Filter the query by a related Eleve object
	 * using the j_eleves_etablissements table as cross reference
	 *
	 * @param     Eleve $eleve the related object to use as filter
	 * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function filterByEleve($eleve, $comparison = Criteria::EQUAL)
	{
		return $this
			->useJEleveAncienEtablissementQuery()
			->filterByEleve($eleve, $comparison)
			->endUse();
	}

	/**
	 * Exclude object from result
	 *
	 * @param     AncienEtablissement $ancienEtablissement Object to remove from the list of results
	 *
	 * @return    AncienEtablissementQuery The current query, for fluid interface
	 */
	public function prune($ancienEtablissement = null)
	{
		if ($ancienEtablissement) {
			$this->addUsingAlias(AncienEtablissementPeer::ID, $ancienEtablissement->getId(), Criteria::NOT_EQUAL);
		}

		return $this;
	}

} // BaseAncienEtablissementQuery