#!/bin/bash

#
# Instance automatique
#

source ./context.sh
BOOT_LOG_FILE="/var/log/hapy-deploy-$(date +'%d%m%Y').log"
INST=$(CreoleGet module_instancie non)
FBFILE=/etc/eole/firstboot

function lgmsg() {
  echo "$(date +%d%m%y-%H%M%S):${@}" | tee -a ${BOOT_LOG_FILE}
}

function updateInstance() {
    cmd=$(which instance-unattended)
    if [[ $? -ne 0 ]]
    then
        yes oui | Query-Auto -D -i
        apt-eole install eole-modele-vm
        Query-Auto
    fi
    return 0
}

function is_registred(){
  ot=$(enregistrement_zephir -c)
  return $?
}

[[ -e ${FBFILE} ]] && exit 0

if [[ ${INST} == "non" ]]
then

    is_registred
    if [[ $? -ne 0 ]]
    then
        lgmsg "INSTANCE:FAILED:Server is not zephir registred"
        exit 2
    fi

    updateInstance | tee -a ${BOOT_LOG_FILE}

    sleep 1
    # Wait for config.eol
    cnt=0
    while [[ ! -f "/etc/eole/config.eol" ]]
    do
        sleep 1
        [[ ${cnt} == 10 ]] && break
        cnt=$((cnt+1))
    done
    sleep 1

    /usr/share/eole/sbin/instance-unattended --store-passwords | tee -a ${BOOT_LOG_FILE}
    if [[ ${?} -eq 0 ]]
    then
        lgmsg "INSTANCE:DONE:OK"
        halt -p
        exit ${?}
    fi
    lgmsg "INSTANCE:FAILED:KO"
    exit 1
fi
exit 0