#!/bin/bash
##########################################
# Restauration EOLE
# - Hâpy -
##########################################

. /usr/lib/eole/ihm.sh
. /etc/eole/one_backup_env.conf

Lock="sauvegarde"
Excl="maj"

backup_dir=/var/lib/hapy_backups

if [ ! -d $backup_dir ]
then
    echo -e "${RED} Erreur, répertoire des sauvegardes non trouvé ${DEFAULT}"
    exit 1
fi
pushd $backup_dir &>/dev/null 2>&1

if [ ! -z $1 ]
then
    archive=$1
    basename=`echo -e $archive | sed -e s/"\.tar\.gz"/""/`
else
    archive=/tmp
fi

while [ ! -f $archive ]
do
    # pas de fichier passé en paramètre
    save_files=`ls *.tar.gz | sed -e s/".tar.gz"/""/`
    echo -e "     Utilitaire de restauration Hâpy"
    echo -e
    EchoRouge "!!Attention : toutes les modifications effectuées après la sauvegarde restaurée seront perdues!!"
    echo -e
    EchoCyan "list des sauvegardes présentes :"
    echo -e
    echo -e "$save_files"
    echo -e
    read -p "sauvegarde à restaurer (rien pour sortir): " basename
    if [ -z $basename ]
    then
        exit 0
    fi
    if [ -f $basename.tar.gz ]
    then
        archive=$basename.tar.gz
    else
        echo -e "fichier invalide : $basename.tar.gz"
    fi
done

echo -e "vérification des données..."

tar tf $archive $basename/{one.db,var_lib_one_one.tar,conf_eole.tar,root_ssh.tar} 2>/dev/null >/dev/null
if [ $? -ne 0 ]
then
    EchoRouge "Archive incomplète"
    exit 1
fi

# restauration des données

tar xf $archive
pushd $basename

CURRENT_EOLE_VERSION=$(dpkg -s creole | grep Version)
CURRENT_EOLE_VERSION=$(echo $CURRENT_EOLE_VERSION | sed -e 's/^Version: \([0-9]*\.[0-9]*\.[0-9]\).*/\1/')

tar -C /tmp/ -xpf conf_eole.tar etc/eole/config.eol >/dev/null 2>&1
read FIRST_LINE < /tmp/etc/eole/config.eol
echo $FIRST_LINE | grep -qe "^\["
if [ $? -eq 0 ]
then
    SVG_EOLE_VERSION="2.3"
else
    echo $FIRST_LINE | grep -qe "^{"
    if [[ $? -eq 0 ]]
    then
        VERSION_LINE=$(grep -e "___version___" /tmp/etc/eole/config.eol)
        if [[ $? -eq 0 ]]
        then
            SVG_EOLE_VERSION=$(echo $VERSION_LINE | sed -e 's/^.*___version___":[ ]*"\([0-9]*\.[0-9]*\.[0-9]*\).*$/\1/')
        else
            SVG_EOLE_VERSION="2.4.0"
        fi
    else
        SVG_EOLE_VERSION="INCONNUE"
    fi
fi
echo -e "Restauration d'une sauvegarde $SVG_EOLE_VERSION sur $CURRENT_EOLE_VERSION"

echo -e

EchoGras "Restauration système"

# restauration des répertoires et fichiers importants
# /root/.ssh
echo -e " - clés de connexion"
rm -rf /root/.ssh
tar -C /root -xpf root_ssh.tar >/dev/null 2>&1

echo -e " - configuration eole"
if [ -f /etc/eole/config.eol ]
then
    mv -f /etc/eole/config.eol /etc/eole/config.eol.bak
fi

# vérification du dictionnaire
if [ "$SVG_EOLE_VERSION" == "$CURRENT_EOLE_VERSION" ]
then
    if [ -f /etc/eole/config.eol.bak ] && [ -f /etc/eole/.instance ]
    then
        diff -q /etc/eole/config.eol.bak /tmp/etc/eole/config.eol &>/dev/null
        if [ ! $? -eq 0 ]
        then
            EchoCyan "Le fichier /etc/eole/config.eol est différent de la version restaurée"
            EchoCyan "Le fichier présent actuellement a été renommé en /etc/eole/config.eol.bak"
            EchoCyan
            EchoCyan "  - Renommez éventuellement /etc/eole/config.eol.bak en /etc/eole/config.eol auparavant"
            EchoCyan "  - Lancez 'reconfigure'"
            EchoCyan
        else
            EchoCyan "Lancez 'reconfigure'"
        fi
    else
        EchoCyan "Après la fin de la restauration :"
        EchoCyan "  - Lancez 'instance'"
    fi

    # Restauration dicos, patchs, ssl
    rm -rf /usr/share/eole/creole/dicos/local /usr/share/eole/creole/patch /etc/ssl/*
    tar -C / -xpf conf_eole.tar >/dev/null 2>&1
else
    EchoCyan "Après la fin de la restauration :"
    EchoCyan "  - Lancez 'gen_config' et enregistrez la configuration"
    if [ -f /etc/eole/config.eol.bak ] && [ -f /etc/eole/.instance ]
    then
        EchoCyan "  - Lancez 'reconfigure'"
    else
        EchoCyan "  - Lancez 'instance'"
        EchoCyan "    Attention à ne PAS réinitialiser la base ARV pendant l'instance !!!"
    fi
    # Si version EOLE de la sauvegarde différente, restaure config.eol uniquement
    tar -C / -xpf conf_eole.tar etc/eole/config.eol >/dev/null 2>&1
fi

Question_ouinon "Restaurer les données ONE (implique l’arrêt du service) ?" "True" "non"
if [ $? -eq 0 ];then
    EchoGras "Restauration ONE"
    ARCHIVED_DB_BACKEND=$(head -n 1 one.db)
    DB_BACKEND=$(CreoleGet one_database_type)
    if [ "$DB_BACKEND" = "${ARCHIVED_DB_BACKEND#\#}" ]
    then
        systemctl stop opennebula
        echo -e " - secrets ONE"
        tar xpf var_lib_one_one.tar -C /
        echo -e " - base de données ONE"
        onedb restore -f one.db
        systemctl start opennebula
    else # should not happen as config.eol and one.db are restored from same archive
        EchoRouge "La base ${ARCHIVED_DB_BACKEND#\#} peut pas être restaurée du fait du type différent attendu ($DB_BACKEND)"
        EchoRouge "Les données ONE ne seront pas restaurées automatiquement"
        EchoCyan "Convertissez la base de données au bon format ou adapter la valeur de la variable one_database_type pour que les deux correspondent."
    fi
fi
echo -e

echo -e "Suppression du répertoire temporaire..."
rm -f /tmp/etc/eole/config.eol
rm -rf $backup_dir/$basename
echo -e
EchoVert "Système restauré"
echo -e
# retour au répertoire d'origine
popd >/dev/null 2>&1
