# -*- coding: utf-8 -*-
#!/usr/bin/env python
from creole.loader import creole_loader, config_save_values
from pyeole.process import system_out
from py.test import raises

config = creole_loader(rw=True)
default_port = u'eole'
option_type = {'tag': unicode}


def get_option(option, port=default_port):
    cmd = ['ovs-vsctl', 'list', 'port', port]
    ret, out, err = system_out(cmd)
    if ret != 0:
        raise Exception('erreur a la commande {} : {} - {}'.format(' '.join(cmd), out, err))
    for line in out.split('\n'):
        sline = line.split(':')
        if sline[0].strip() == option:
            value = sline[1].strip().replace('"','')
            if option in option_type:
                value = option_type[option](value)
            print(value)
            return value

def reconfigure(config):
    config_save_values(config, 'creole')
    cmd = ['/usr/share/eole/postservice/29-ovs-mng', 'reconfigure']
    ret, out, err = system_out(cmd)
    if ret != 0:
        raise Exception('erreur a la commande {} : {} - {}'.format(' '.join(cmd), out, err))


def test_change_tag():
    assert config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_vlan_tag == [u'10']
    assert get_option('tag') == u'10'
    config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_vlan_tag[0] = u'11'
    reconfigure(config)
    assert get_option('tag') == u'11'

    #remet la valeur par defaut
    config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_vlan_tag[0] = u'10'
    reconfigure(config)


def test_change_name():
    assert config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_zones == [default_port]
    assert get_option('name') == default_port
    raises(Exception, "get_option('name', u'eth1')")
    config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_zones = [u'eth1']
    reconfigure(config)
    raises(Exception, "get_option('name', '{}')".format(default_port))
    assert get_option('name', u'eth1') == u'eth1'

    #remet la valeur par defaut
    config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_zones = [default_port]
    reconfigure(config)


def test_change_mode():
    assert config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_tag_mode == [None]
    assert get_option('tag') == u'10'
    assert get_option('trunks') == '[]'
    assert get_option('vlan_mode') == '[]'

    config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_tag_mode[0] = 'trunk'
    reconfigure(config)
    assert get_option('tag') == '[]'
    assert get_option('trunks') == '[10]'
    assert get_option('vlan_mode') == 'trunk'

    config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_tag_mode[0] = 'native-tagged'
    reconfigure(config)
    assert get_option('tag') == u'10'
    assert get_option('trunks') == '[]'
    assert get_option('vlan_mode') == 'native-tagged'

    #remet la valeur par defaut
    config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_tag_mode[0] = None
    reconfigure(config)
    assert config.creole.commutateur_virtuel.ovs_sw_zones.ovs_sw_tag_mode == [None]
    assert get_option('tag') == u'10'
    assert get_option('trunks') == '[]'
    assert get_option('vlan_mode') == '[]'
