#!/usr/bin/python3
# -*- coding: utf-8 -*-
"""Module postgresql"""
from os.path import join, isfile, basename
from os import listdir, unlink
import re
import sys
import shutil
import tempfile
#from subprocess import check_call, check_output
sys.path.append('/usr/share/eole/sbin')
from pyeole.bareosrestore import bareos_restore_one_folder, \
 bareos_restore_one_file, exit_if_running_jobs
from pyeole.process import system_out
from creole.client import CreoleClient

PGSQLSAVDIR = '/home/backup/postgresql'
PGSQL_HOST = CreoleClient().get_creole('container_ip_postgresql')
PGSQL_PATH = CreoleClient().get_creole('container_path_postgresql')
PGSQL_HOST_OPTION = "-h {}".format(PGSQL_HOST) if PGSQL_HOST != '127.0.0.1' else ""
BACKUP_RE = re.compile(r'(?P<database>.*?).backup'.format(PGSQLSAVDIR))
PGDM_MAGIC = b'PGDM'


def load_file_into_pg_db(filename, clean=False, create=False):
    """
    Load given file in database to restore content.
    :param filename: database dump to restore
    :type filename: str
    :param database: target database
    :type database: str
    :param clean: flag for clean option to drop database before loading
    :type clean: boolean
    :param create: flag for create option to create database before loading
    :type create: boolean
    """
    temp_dir = join('/', PGSQL_PATH, 'tmp')
    temp_filename = tempfile.mktemp(dir=temp_dir)
    inside_filename = join('/tmp', basename(temp_filename))
    shutil.copy(filename, temp_filename)
    system_out(['chgrp', 'postgres', inside_filename], container='postgresql')
    system_out(['chmod', '640', inside_filename], container='postgresql')
    with open(filename, 'rb') as bin_file:
        magic_number = bin_file.read(4)
    if magic_number == PGDM_MAGIC:
        options = []
        options.append('-c' if clean else '')
        options.append('-C' if create else '')
        options = ' '.join(options)
        database_name = basename(filename).rsplit('.', 1)[0]
        cmd = ['su', '-', 'postgres', '-c', 'pg_restore {0} {1} -d {2}'.format(options, inside_filename, database_name)]
        ret, result, err = system_out(cmd, container='postgresql')
        unlink(temp_filename)
        if ret != 0:
            print(f'impossible de restaurer le fichier {temp_filename} : {result} : {err}')
            sys.exit(1)
        with open(temp_filename, 'w') as sql:
            sql.write(result)
    cmd = ["su", "-", "postgres", '-c', "psql -f {0}".format(inside_filename)]
    ret, result, err = system_out(cmd, container='postgresql')
    unlink(temp_filename)
    if ret != 0:
        print(f'impossible de restaurer le fichier {temp_filename} : {result} : {err}')
        sys.exit(1)


def execute(option, opt_str, value, parser, jobid, test_jobs=True):
    """ldap helper"""
    if len(parser.rargs) > 0:
        option = parser.rargs[0]
        if option == 'pre':
            pre()
        elif option == 'post':
            post()
    else:
        if test_jobs:
            exit_if_running_jobs()
        job(jobid)


def pre():
    print("pre postgresql")


def post(databases=None):
    """
    Load backup into database cluster
    :param databases: list of databases to restore (all if none listed)
    :type databases: list
    """
    print("post postgresql")
    if databases is None:
        databases = [backup for backup in listdir(PGSQLSAVDIR)
                     if isfile(join(PGSQLSAVDIR, backup)) and
                     BACKUP_RE.match(backup)]
        databases.sort()
    for backup in [join(PGSQLSAVDIR, database) for database in databases if database not in ['bareos.backup', 'postgres.backup']]:
        print("restauration de {0}".format(backup))
        load_file_into_pg_db(backup, clean=True, create=True)


def job(jobid):
    print("Restauration postgressql")
    # restauration des dumps sql
    bareos_restore_one_folder(PGSQLSAVDIR, jobid)

priority = 30
