<?php
require_once('config/main.inc.php');

if ((isset($_SERVER['PHP_AUTH_USER']) && !empty($_SERVER['PHP_AUTH_USER']))
  &&(isset($_SERVER['PHP_AUTH_PW']) && !empty($_SERVER['PHP_AUTH_PW']))) {

    $ldap_host = $rcmail_config['ldap_public']['Local']['hosts'][0];
    $ldap_port = $rcmail_config['ldap_public']['Local']['port'];
    $ldap_basedn = $rcmail_config['ldap_public']['Local']['base_dn'];

    $ds = ldap_connect($ldap_host, $ldap_port) or die("Impossible de se connecter au serveur LDAP.");
    if($ds) {
        $ldapbind = ldap_bind($ds);
        $ret = ldap_search($ds, $ldap_basedn, "uid=".$_SERVER['PHP_AUTH_USER']."");
        $info = ldap_get_entries($ds, $ret);
        $dn = $info[0]["dn"];
        $ldapbind = ldap_bind($ds, $dn, $_SERVER['PHP_AUTH_PW']);

        if($ldapbind) {
            require_once('config/db.inc.php');

            //Traitement de la string dsnw qui est sous la forme mysql://user:pwd@host/database pour extraire les paramètres
            $dsn = explode("@", $rcmail_config['db_dsnw']);
            $dsn_userpwd = explode(":", substr($dsn[0], 8));
            $dsn_hostdatabase = explode("/", $dsn[1]);

            $user = $dsn_userpwd[0];
            $pwd = $dsn_userpwd[1];
            $host = $dsn_hostdatabase[0];
            $database = $dsn_hostdatabase[1];

            //Connexion databse
            try{
                $pdo_options[PDO::ATTR_ERRMODE] = PDO::ERRMODE_EXCEPTION;
                $pdo_options[PDO::MYSQL_ATTR_INIT_COMMAND] = "SET NAMES utf8";

                $bdd = new PDO('mysql:host='.$host.';dbname='.$database.'',$user,$pwd,$pdo_options);

                $contacts = array();
                //Recuperation des vcard (contacts) de l'utilisateur connecté
                try{
                    $reponse = $bdd->prepare("SELECT vcard FROM users,contacts
                                              WHERE users.user_id = contacts.user_id
                                              AND username = ?
                                              AND del = ?");
                    $reponse -> execute(array($_SERVER['PHP_AUTH_USER'],"0"));
                    while ($donnees = $reponse->fetch())
                    {
                         $contacts[] = $donnees[0];
                    }
                    $reponse -> closeCursor();
                }catch (Exception $e)
                {
                    die('Erreur : ' . $e->getMessage());
                }
            }
            catch (Exception $e){
                die('Erreur : ' . $e->getMessage());
            }

            //Construction du vcf contenant toutes les vcard
            if(!empty($contacts)) {
                header('Content-Type: text/x-vcard; charset=utf-8');
                header('Content-Disposition: attachment; filename="'.$_SERVER['PHP_AUTH_USER'].'.vcf"');
                foreach($contacts as $contact) {
                    echo $contact."\n";
                }
            } else {
                echo "<script>alert('Votre carnet d\'adresses \"Adresses personnelles\" sur roundcube est vide.')</script>";
            }

        } else {
            unset($_SERVER['PHP_AUTH_USER']);
            unset($_SERVER['PHP_AUTH_PW']);
            header('WWW-Authenticate: Basic realm="Bonjour"');
            header('HTTP/1.0 401 Unauthorized');
        }
    }
} else {
    header('WWW-Authenticate: Basic realm="Bonjour"');
    header('HTTP/1.0 401 Unauthorized');
}