<?php
/**
 * Plugin Authentification CAS
 * Copyright (c) Christophe IMBERTI
 */

if (!defined("_ECRIRE_INC_VERSION")) return;    #securite

/**
 * Declenchement de l'authentification CAS puis redirection
 */

include_spip('inc/headers');
include_spip('inc/session');
include_spip('inc/cookie');
include_spip('inc/texte');
include_spip('base/abstract_sql');
include_spip('inc/headers');

// import phpCAS lib
#include_spip('CAS');
include_once("configCAS/cas.inc.php");
include_once('CAS-1.3.1/eoleCAS.php');
define('__CAS_URL', "");

include_spip('inc/eolecas_commun');


// redirection par defaut
$ciredirect = generer_url_public('');


// lire la configuration du plugin
eolecas_lire_meta();


// phpCAS::setDebug();

// Dterminer l'origine de l'appel (intranet, internet, ...)
// .i2 ou .ader.gouv.fr ou .gouv.fr ou .agri
//$ciurlcas=eolecas_url_serveur_cas();

// initialise phpCAS
$cirep='';
$ciport=intval($GLOBALS['ciconfig']['eolecasport']);
if (isset($GLOBALS['ciconfig']['eolecasrepertoire'])) $cirep=$GLOBALS['ciconfig']['eolecasrepertoire'];
#phpCAS::client(CAS_VERSION_2_0,$ciurlcas,$ciport,$cirep);
EolephpCAS::client(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,"",false);
////if (isset($_GET['lang'])) {
    ////$cilangphpcas=eolecas_lang_phpcas($_GET['lang']);
////} else {
    ////$cilangphpcas='french';
////}
////EolephpCAS::setLang($cilangphpcas);

// enlever le pied de page de CAS
EolephpCAS::SetHTMLFooter('<hr>');

// Maj pour phpCAS 1.3.1
if (__CAS_VALIDER_CA) {
    EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vrification par rapport  la CA
} else {
    if (method_exists("EolephpCAS", "setNoCasServerValidation")){
	EolephpCAS::setNoCasServerValidation();
    }
}

// forcer l'authentication CAS
EolephpCAS::forceAuthentication();

// A ce stade, l'utilisateur a ete authentifie par le serveur CAS
// et l'identifiant de l'utilisateur renvoye par CAS peut etre lu avec phpCAS::getUser().

$ci_cas_userid = '';

if ($ci_cas_userid=EolephpCAS::getUser()) {
//	$ci_cas_userid = $ci_cas_userid[0];
//TODO : changement du eoleCas getUser return String
	$ci_cas_userid = $ci_cas_userid;
	$auteur = array();
	$auteur = eolecas_verifier_identifiant($ci_cas_userid);

	// compatibilit avec les anciennes adresses email
	if (!isset($auteur['id_auteur'])) {
		if ($GLOBALS['ciconfig']['eolecasuid']!="login") {
			if ($ci_cas_userid) {
				$ci_pos = strpos($ci_cas_userid, '@');
				if ($ci_pos AND $ci_pos > 0) {
					$ci_tableau_email = explode('@',$ci_cas_userid);
					if (strtolower($ci_tableau_email[1])=="developpement-durable.gouv.fr") {
						$ci_cas_userid = $ci_tableau_email[0].'@equipement.gouv.fr';
						$auteur = eolecas_verifier_identifiant($ci_cas_userid);
					}
				}
			}
		}
	}
	if (isset($auteur['id_auteur'])) {

		// URL cible de l'operation de connexion
        $cible = eolecas_url_cible();


		//  bloquer ici le visiteur qui tente d'abuser de ses droits
		if (isset($auteur['statut'])) {
			if (eolecas_is_url_prive($cible)) {
				if ($auteur['statut']=='6forum'){
					$ciredirect = generer_url_public('');
					// plus de redirection immdiate, les visiteurs sont autoriss
					//redirige_par_entete($ciredirect);
					$cible = '';
				}
			}
		}

		// on a ete authentifie, construire la session
		// en gerant la duree demandee pour son cookie
		if ($session_remember !== NULL)
			$auteur['cookie'] = $session_remember;
		$session = charger_fonction('session', 'inc');
		$session($auteur);
		$p = ($auteur['prefs']) ? unserialize($auteur['prefs']) : array();
		$p['cnx'] = ($session_remember == 'oui') ? 'perma' : '';
		$p = array('prefs' => serialize($p));
		sql_updateq('spip_auteurs', $p, "id_auteur=" . $auteur['id_auteur']);


		// Si on est admin, poser le cookie de correspondance
		if ($GLOBALS['auteur_session']['statut'] == '0minirezo') {
			include_spip('inc/cookie');
			spip_setcookie('spip_admin', '@'.$GLOBALS['auteur_session']['login'],time() + 7 * 24 * 3600);
		}

		// Si on est connecte, envoyer vers la destination
		if ($cible){
            $ciredirect = $cible;
        }

	} else {
		include_spip('auth/ldap');
		$ldap = spip_connect_ldap();
		$ldap_link = $ldap['link'];
		$ldap_base = $ldap['base'];
 		$search=@ldap_search($ldap_link, $GLOBALS["ldap_base"], '(&(uid='.$ci_cas_userid.')(objectClass=*))', array("dn","cn","mail"));
		ldap_sort($ldap_link,$search,"cn"); // Tri des données sur le cn
		$entreesLdap = @ldap_get_entries($ldap_link,$search);
		$dn = $entreesLdap[0]["dn"];
		if ($GLOBALS['meta']["ldap_statut_import"]
			        AND $desc = auth_ldap_retrouver($dn, array('login' => 'uid', 'nom' => 'cn', 'email' => 'mail'))) {
		// rajouter le statut indique  a l'install
		$desc['statut'] = $GLOBALS['meta']["ldap_statut_import"];
		$desc['source'] = 'cas';
		$desc['pass'] = '';

		sql_insertq('spip_auteurs', $desc);
	    }
	}

} else {
	$ciredirect = generer_url_public("eolecas_erreur1");
}
$ciredirect=preg_replace("#^\./\?#","index.php?",$ciredirect);

redirige_par_entete($ciredirect);


?>
