<?php
class readCDT
	{
	/**
	 * Valeur du profil envoyé par le serveur CAS
	 * Si élève non reconnu, on cherche un emploi du temps "prof"
	 *
	 * @var string
	 * @access private
	 */
	private $profil_eleve = "National_1";

	/**
	 * Chemin d'accès au cahier de textes
	 *
	 * @var string
	 * @access private
	 */
	private $path = '../cdt/';

	/**
	 * Fichier de connexion MySQL
	 *
	 * @var string
	 * @access private
	 */
	private $file_connexion = '../cdt/Connections/conn_cahier_de_texte.php';

	/**
	 * Libellé des jours
	 *
	 * @var array
	 * @access private
	 */
	private $jours = array(0=>"Dimanche",1=>"Lundi",2=>"Mardi",3=>"Mercredi",4=>"Jeudi",5=>"Vendredi",6=>"Samedi");

	/**
	 * Connexion MySQL
	 *
	 * @var resource
	 * @access private
	 */
	private $link = false;

	/**
	 * Témoin que la lecture du cahier de textes est possible
	 *
	 * @var boolean
	 * @access private
	 */
	public $is_ok = false;

	/**
	 * Identifiant utilisé pour les popups 
	 *
	 * @var int
	 * @access private
	 */
	private $popup_id = 0;

	/**
	 * Les périodes de vacances du cahier de textes
	 * Pour ne rien afficher si jour de vacances
	 *
	 * @var array
	 * @access private
	 */
	private $vacances = array();

	/**
	 * Les semaines A/B du cahier de textes
	 *
	 * @var array
	 * @access private
	 */
	private $alternances = array();

	/**
	 * Les plages horaires du cahier de textes
	 *
	 * @var array
	 * @access private
	 */
	private $horaires = array();

	/**
	 * Format de date jj/mm/aaaa pour l'accès à une séance précise dans le cdt
	 *
	 * @var string
	 * @access private
	 */
	private $consult_date = "";

	/**
	 * Format de date Ymd pour la recherche d'évènements
	 *
	 * @var string
	 * @access private
	 */
	private $date = "";

	/**
	 * Quel type de vue ? classe ou prof ?
	 *
	 * @var string
	 * @access private
	 */
	private $view = "";

	/**
	 * Valeur à rechercher
	 * Nom de la classe ou login du prof selon $view
	 *
	 * @var string
	 * @access private
	 */
	private $valeur = "";

	/**
	 * Identifiant à considérer
	 * Id de la classe ou id du prof selon $view
	 *
	 * @var int
	 * @access private
	 */
	private	$id_cdt = 0;

	/**
	 * Complément de requête
	 * Liste des regroupements concernés, utilisée si vue "classe"
	 *
	 * @var string
	 * @access private
	 */
	private $gics_list = "";

	/**
	 * Nombre de cours récupérés
	 * 
	 * @var int
	 * @access private
	 */
	private $total_cours = 0;

	/**
	 * Nombre de devoirs récupérés
	 * 
	 * @var int
	 * @access private
	 */
	private $total_devoirs = 0;

	/**
	 * Format de la vue WebCalendar à afficher
	 * day(1)/week(2)/month(3)
	 * 
	 * @var int
	 * @access private
	 */
	private $format = 0;

	/**
	 * Périodes de vacances à afficher dans le bilan
	 * 
	 * @var array
	 * @access private
	 */
	private $displayVacances = array();

	/**
	 * Constructeur
	 */
	public function __construct()
		{
		$this->is_ok = $this->mysqlConnexion(); //connexion MySQL
		$this->search_vacances(); //périodes de vacances
		$this->search_alternances(); //lundis de semaines A ou B
		$this->search_plages_horaires(); //plages horaires des cours
		$this->make_access(); //ajout d'une fonction javascript pour l'utilisation des liens
		}

	/**
	 * Traitements à faire en fin d'exécution ou arrêt du script
	 */
	public function __destruct()
		{
		$this->bilan();
		@mysql_close($this->link);
		}

	/**
	 * Affichage d'un résumé de ce que le plugin a détecté
	 */
	public function bilan()
		{
		if($this->format!==0) //sinon cela signifie qu'aucune recherche n'a été effectué
			{
			$total = $this->total_cours+$this->total_devoirs;
			$output = "<div style=\"padding-left:5px; margin:0px; font-size:12px;\">";
			
			//légende pour la vue semaine
			if($this->format==2) $output .= "<b>L&eacute;gende (Importation du cahier de textes) :</b> C -> Cours  ,  D -> Devoirs  ,  (GrA) -> Groupe A  , (GrB) -> Groupe B  ,  (Gr) -> Autres Groupes<br/>";
			
			//récapitulatif de ce qui a été lu par le plugin
			$output .= "<b>Lecture du cahier de textes :</b> ";
			if($total==0) $output .= "Aucun &eacute;v&egrave;nement d&eacute;tect&eacute;.";
			else
				{
				if($this->total_devoirs>1) $s = "s";
				$output .= ($this->total_cours>0 ? $this->total_cours : "aucun")." cours";
				$output .= " / ";
				$output .= ($this->total_devoirs>0 ? $this->total_devoirs : "aucun")." devoir".$s;
				}
			if($this->format==3) $output .= " (cours non affich&eacute;s en vue mensuelle)";
			$output .= "<br/>";
			
			//affichage éventuelle des vacances
			foreach($this->displayVacances as $id)
				{
				if(!array_key_exists($id,$this->vacances)) continue;
				$debut = date("d/m/Y",$this->vacances[$id][0]);
				$fin = date("d/m/Y",$this->vacances[$id][1]);
				$output .= "<b>Vacances :</b> ".$this->vacances[$id][2]." (du ".$debut." au ".$fin." inclus)<br/>";
				}
			
			$output .= "</div>";
			echo $output;
			}
		}

	/**
	 * Connexion et sélection de la base de données
	 * 
	 * @return boolean true si connexion réussie
	 */	
	public function mysqlConnexion()
		{
		//connexion mysql
		if(!is_file($this->file_connexion)) return false;
		@include($this->file_connexion);
		$this->link = $conn_cahier_de_texte;	
		if(!@mysql_select_db($database_conn_cahier_de_texte,$this->link)) return false;
		else return true;
		}

	/**
	 * Traitement des infos du cdt selon deux vues : "classe" et "prof"
	 */
	public function search_view()
		{
		global $login,$user;
		
		if(!$this->is_ok || !empty($this->view)) return false;
		
		if(isset($user) && !empty($user)) //l'existence de $user montre la demande pour afficher un calque
			{
			$classe = search_classe($user); //fonction présente dans user-cas.php
			if($classe)
				{
				if($classe!="autre") //élève ou meta_classe
					{
					$this->view = "classe";
					$this->valeur = $classe;
					}
				else //autres donc prof...
					{
					$this->view = "prof";
					$this->valeur = $user;				
					}
				}
			}
		elseif($_SESSION["webcalendar_profil"]==$this->profil_eleve)
			{
			$this->view = "classe";
			$this->valeur = $_SESSION["webcalendar_classe"];
			}
		else
			{
			$this->view = "prof";
			$this->valeur = $login;
			}
		}

	/**
	 * Recherche de l'id de l'enseignant ou de la classe concerné sur le cdt
	 */
	public function search_id_cdt()
		{
		if(!$this->is_ok || $this->id_cdt!==0) return false;
		
		//si classe, priorité à trouver $this->valeur dans le champ code_classe
		if($this->view=="classe")
			{
			$query_search = "SELECT `ID_".$this->view."` FROM `cdt_".$this->view."` WHERE `code_".$this->view."`='".$this->valeur."' LIMIT 1;";
			$result_search = @mysql_query($query_search,$this->link);
			$row_search = @mysql_fetch_row($result_search);
			if($row_search) $this->id_cdt = $row_search[0];
			}
		
		//recherche de $this->valeur dans le champ nom_xxxxx
		if($this->id_cdt===0)
			{
			$query_search = "SELECT `ID_".$this->view."` FROM `cdt_".$this->view."` WHERE `nom_".$this->view."`='".$this->valeur."' LIMIT 1;";
			$result_search = @mysql_query($query_search,$this->link);
			$row_search = @mysql_fetch_row($result_search);
			if(!$row_search) return false;
			$this->id_cdt = $row_search[0];
			}
			
		//si classe : recherche des groupements éventuels dont elle fait partie
		if($this->id_cdt>0 && $this->view=="classe")
			{
			$query_gic = "SELECT `gic_ID` FROM `cdt_groupe_interclasses_classe` WHERE `classe_ID`='".$this->id_cdt."';";
			$result_gic = @mysql_query($query_gic,$this->link);
			if(mysql_num_rows($result_gic)>0)
				{
				$this->gics_list .= "OR `e`.`gic_ID` IN (";
				while($row_gic = @mysql_fetch_row($result_gic))	$this->gics_list .= $row_gic[0].",";
				$this->gics_list = substr($this->gics_list,0,-1);
				$this->gics_list .= ")";
				}
			}
		
		//le cdt nécessite des variables de session pour y accéder en consultation
		if($this->view=="classe") $_SESSION["consultation"] = $this->id_cdt; //pour lire.php et consulter.php, il faut $_SESSION["consultation"] == $_GET['classe_ID']
		elseif(!isset($_SESSION['nom_prof'])) $_SESSION['nom_prof'] = "#"; //la simple existence suffit si vue "prof" pour lequel le "classe_ID" varie (voir début de lire.php)
		}

	/**
	 * Recherche des périodes de vacances indiquées dans le cahier de textes
	 *
	 * La requête est reprise du script "administration/even_ajout.php".
	 */
	public function search_vacances()
		{
		if(!$this->is_ok) return false;
		$query_vacances = "SELECT `heure_debut`,`heure_fin`,`theme_activ` FROM `cdt_agenda` WHERE `classe_ID`=0 AND `theme_activ`<>'Remplacement' ORDER BY `code_date`;";
		$result_vacances = @mysql_query($query_vacances,$this->link);
		while($row_vacances = @mysql_fetch_row($result_vacances))
			{
			list($day,$month,$year) = explode("/",trim($row_vacances[0]));
			$date_debut = mktime(0,0,0,$month,$day,$year);
			list($day,$month,$year) = explode("/",trim($row_vacances[1]));
			$date_fin = mktime(23,59,59,$month,$day,$year);
			$this->vacances[] = array($date_debut,$date_fin,$row_vacances[2]);
			}	
		}

	/**
	 * Recherche des alternances indiquées dans le cahier de textes
	 *
	 * Les dates récupérées sont des lundis.
	 */
	public function search_alternances()
		{
		if(!$this->is_ok) return false;
		$query_alternances = "SELECT `semaine`,`s_code_date` FROM `cdt_semaine_ab`;";
		$result_alternances = @mysql_query($query_alternances,$this->link);
		while($row_alternances = @mysql_fetch_assoc($result_alternances))
			{
			extract($row_alternances);
			$this->alternances[$s_code_date] = $semaine;
			}	
		}

	/**
	 * Recherche des plages horaires indiquées dans le cahier de textes
	 */
	public function search_plages_horaires()
		{
		if(!$this->is_ok) return false;
		$query_horaires = "SELECT * FROM `cdt_plages_horaires`;";
		$result_horaires = @mysql_query($query_horaires,$this->link);
		while($row_horaires = @mysql_fetch_assoc($result_horaires))
			{
			extract($row_horaires);
			$id = intval($ID_plage);
			$this->horaires[$id]["debut"] = $h1."h".$mn1;
			$this->horaires[$id]["fin"] = $h2."h".$mn2;
			}
		}

	/**
	 * Appellation courte d'un groupe
	 * 
	 * @param  string $group nom complet du groupe
	 * @return string diminutif (GrX)
	 */
	public function short_group_name($group)
		{
		$group = str_replace(" ","",strtolower($group));
		if($group=="inconnu") $value = "";
		elseif(preg_match("/^classeenti/i",$group)) $value = ""; //pour repérer "Classe entière" et éviter les problèmes de présence d'accent ou d'encodage...
		elseif(preg_match("/^groupe([0-9a-z]{1})$/i",$group,$matches)) $value = "Gr".strtoupper($matches[1]); //groupe A,B,C,1,2,3...
		else $value = "Gr";
		return $value;
		}

	/**
	 * Si le cdt est installé et les semaines A/B renseignées, affiche A ou B
	 * Sinon comportement normal
	 * Utilisée par la fonction "display_navigation" dans includes/functions.php
	 *
	 * @param  string $wkstart timestamp considéré comme dimanche ou lundi
	 * @return string A/B si possible, numéro de la semaine sinon
	 */
	public function week_number($wkstart)
		{
		$format_calendar = date('W',$wkstart+86400);
		$jour = date("w",$wkstart);
		if(!$this->is_ok || $jour>1) return $format_calendar;
		if($jour==0) $wkstart += 24*60*60; //le dimanche devient lundi...
		$row = false;
		$query = "SELECT `semaine` FROM `cdt_semaine_ab` WHERE `s_code_date`='".date("Ymd",$wkstart)."' LIMIT 1;";
		$result = @mysql_query($query,$this->link);
		$row = @mysql_fetch_row($result);
		if($row) return $row[0]; //résultat du cdt
		return $format_calendar; //comportement classique
		}

	/**
	 * Si le cdt est installé, lit l'emploi du temps au format attendu
	 * Pour le mois, on ne recherche que les devoirs
	 *
	 * @param  string $date timestamp ou forme "Ymd"
	 * @param  int    $format 1 pour day, 2 pour week et 3 pour month
	 */
	public function cdt_events($date,$format=2)
		{
		//données de session spécifiques envole et nécessaires (voir user_cas_auth)
		if(!$this->is_ok || !isset($_SESSION["webcalendar_profil"]) || ($_SESSION["webcalendar_profil"]==$this->profil_eleve && !isset($_SESSION["webcalendar_classe"])) || !$this->setFormat($format)) return false;

		//ici car on est sûr que la session est démarrée à cet appel, la recherche n'est faite qu'une fois
		$this->search_view();
		$this->search_id_cdt();
		
		//inutile de poursuivre si pas de vue identifiée ou pas d'identifiant prof/classe retrouvé
		if(empty($this->view) || empty($this->id_cdt)) return false;
		
		if(strlen($date)==8) //forme "Ymd"
			{
			$day = substr($date,6,2);
			$month = substr($date,4,2);
			$year = substr($date,0,4);
			$this->date = $date;
			$this->consult_date = $day."/".$month."/".$year;
			$date = mktime(0,0,0,intval($month),intval($day),intval($year));
			}
		else
			{
			$this->date = date("Ymd",$date);
			$this->consult_date = date("d/m/Y",$date);
			}
		$num_jour = date('w',$date);
		$jour = $this->jours[$num_jour]; //jour demandé au format cdt
		$lundi = ($num_jour==0) ? $date-6*60*60*24 : $date-($num_jour-1)*60*60*24;
		$lundi = date("Ymd",$lundi); //pour vérifier l'alternance des semaines

		//jour de vacances scolaires éventuellement renseignées dans le cdt
		foreach($this->vacances as $i=>$periodes)
			{
			$date_debut = $periodes[0]; //premier jour de vacances et non le dernier jour d'école
			$date_fin = $periodes[1]; //dernier jour de vacances et non le premier jour d'école
			if($date>=$date_debut && $date<=$date_fin)
				{
				if(!in_array($i,$this->displayVacances)) $this->displayVacances[] = $i;
				return false;
				}
			}

		//emploi du temps seulement pour les vues day/week (un ou moins des id vaut 0 dans 'cdt_emploi_du_temps')
		//trop chargé sinon dans le vue month pour laquelle, on se contentera du compteur...
		$query_cours = "SELECT `e`.*,`m`.`nom_matiere`,`c`.`nom_classe`,`gi`.`nom_gic`,`p`.`nom_prof`,`p`.`identite` FROM `cdt_emploi_du_temps` AS `e` 
						LEFT JOIN `cdt_matiere` AS `m` ON `m`.`ID_matiere`=`e`.`matiere_ID` 
						LEFT JOIN `cdt_classe` AS `c` ON `c`.`ID_classe`=`e`.`classe_ID` 
						LEFT JOIN `cdt_groupe_interclasses` AS `gi` ON `gi`.`ID_gic`=`e`.`gic_ID` 
						LEFT JOIN `cdt_prof` AS `p` ON `p`.`ID_prof`=`e`.`prof_ID` 
						WHERE (`e`.`".$this->view."_ID`='".$this->id_cdt."' ".$this->gics_list.") AND `jour_semaine`='".$jour."';";
		//echo "<h3>".$query_cours."</h3>";
		$result_cours = @mysql_query($query_cours,$this->link);
		while($row_cours = @mysql_fetch_assoc($result_cours))
			{
			extract($row_cours);
		
			//est-on dans la bonne semaine ?
			if($semaine!="A et B" && isset($this->alternances[$lundi]) && $this->alternances[$lundi]!=$semaine) continue;

			//est-on dans la bonne période ?
			$edt_exist_debut = str_replace("-","",$edt_exist_debut); //forme Ymd
			$edt_exist_fin = str_replace("-","",$edt_exist_fin); //forme Ymd
			$Ymd_date = date("Ymd",$date);
			if($Ymd_date<$edt_exist_debut || $Ymd_date>$edt_exist_fin) continue;
			
			//cours valide, on le comptabilise pour vérifier que l'affichage est complet et on sort si vue mensuelle demandée
			$this->total_cours++;
			if($this->format==3) continue;
			
			//pour un regroupement, il faut retrouver une/la classe pour générer un lien valide vers le cdt
			$this->gic_id = intval($gic_ID);
			if($this->view=="classe") $this->classe_id = intval($this->id_cdt);
			elseif(intval($classe_ID)>0) $this->classe_id = intval($classe_ID);
			else
				{
				//c'est un enseignant pour un regroupement, on cherche une classe au hasard faisant partie de ce regroupement (affichage séance identique)
				$query_classe = "SELECT `classe_ID` FROM `cdt_groupe_interclasses_classe` WHERE `gic_ID`=".$this->gic_id." LIMIT 1;";
				$result_classe = @mysql_query($query_classe,$this->link);
				$row_classe = @mysql_fetch_row($result_classe);
				$this->classe_id = ( $row_classe ? intval($row_classe[0]) : 0 );
				}

			//mise en place des variables
			$this->type = "cours";
			/*
			//il s'agissait de ne pas avoir des heures incohérentes (finir à 8h55 et cours d'après à 9h00)
			//mais si on prend les horaires servant de base à la création des cours dans le cahier de textes,
			//cela pose le problème notamment des cours d'1h30 donc un enseignant qui aura précisé une plage horaire
			$horaire = intval($heure);
			$this->heure_debut = array_key_exists($horaire,$this->horaires) ? $this->horaires[$horaire]["debut"] : $heure_debut;
			$this->heure_fin = array_key_exists($horaire,$this->horaires) ? $this->horaires[$horaire]["fin"] : $heure_fin;
			*/
			$this->heure_debut = $heure_debut;
			$this->heure_fin = $heure_fin;
			$this->classe = ( empty($nom_gic) ? ( empty($nom_classe) ? 'Inconnue' : $nom_classe ) : $nom_gic );
			if($this->view=="classe" && !empty($nom_gic)) $this->show_classe = true;
			else $this->show_classe = false;
			$this->matiere = ( empty($nom_matiere) ? 'Inconnue' : $nom_matiere );
			$this->enseignant = ( empty($identite) ? ( empty($nom_prof) ? 'Inconnu' : $nom_prof ) : $identite );
			$this->group = ( empty($groupe) ? 'Inconnu' : $groupe );
			$this->devoir = "";
			$this->alternance = $semaine;
			$this->matiere_id = intval($matiere_ID);
			
			//génération du code
			$this->make_event();
			$this->make_popup();
			}
		
		//devoirs (classe_ID jamais nul dans 'cdt_travail' car si regroupement, le travail est copié pour chaque classe concernée)
		$query_devoirs = "SELECT `t`.*,`a`.`heure_debut`,`m`.`nom_matiere`,`c`.`nom_classe`,`gi`.`nom_gic`,`p`.`nom_prof`,`p`.`identite` FROM `cdt_travail` AS `t` 
						LEFT JOIN `cdt_agenda` AS `a` ON `a`.`ID_agenda`=`t`.`agenda_ID` 
						LEFT JOIN `cdt_matiere` AS `m` ON `m`.`ID_matiere`=`t`.`matiere_ID` 
						LEFT JOIN `cdt_classe` AS `c` ON `c`.`ID_classe`=`t`.`classe_ID` 
						LEFT JOIN `cdt_groupe_interclasses` AS `gi` ON `gi`.`ID_gic`=`t`.`gic_ID` 
						LEFT JOIN `cdt_prof` AS `p` ON `p`.`ID_prof`=`t`.`prof_ID` 
						WHERE `t`.`".$this->view."_ID`='".$this->id_cdt	."' AND `t_code_date`='".date("d-m-Y",$date)."' 
						ORDER BY `t`.`gic_ID`;";
		$result_devoirs = @mysql_query($query_devoirs,$this->link);
		$travaux = array();
		while($row_devoirs = @mysql_fetch_assoc($result_devoirs))
			{
			extract($row_devoirs);

			//on ne traite pas les devoirs liés à une séance de cours qui n'a pas encore eu lieu !
			$hour = substr($heure_debut,0,2);
			$minute = substr($heure_debut,3,2);
			$day = substr($code_date,6,2);
			$month = substr($code_date,4,2);
			$year = substr($code_date,0,4);
			$seance = mktime(intval($hour),intval($minute),0,intval($month),intval($day),intval($year));
			$now = time();
			if($now<$seance) continue;
			

			$this->classe_id = intval($classe_ID);
			$this->gic_id = intval($gic_ID);
			$this->matiere_id = intval($matiere_ID);
			
			//pour un prof, attention à ne pas afficher 3 fois le travail donnée si regroupement de 3 classes...
			//sur une même journée, le critère de non affichage est de retrouver le même travail pour un même regroupement
			if($this->view=="prof")
				{
				if($this->gic_id>0)
					{
					if(is_array($travaux[$gic_ID]) && in_array($travail,$travaux[$gic_ID])) continue;
					$travaux[$gic_ID][] = $travail;
					}
				}
			
			//devoir valide, on le comptabilise pour vérifier que l'affichage est complet
			$this->total_devoirs++;
				
			//retrouver une séance ce jour-là pour l'heure à laquelle rendre ce devoir sinon 8h00-9h00 par défaut
			if($this->gic_id>0) $search = "`gic_ID`='".$this->gic_id."'"; //si vue classe, c'est obligatoirement un regroupement auquel elle appartient
			else $search = "`classe_ID`='".$this->classe_id."'"; //jamais nul
			$query_seance = "SELECT `heure_debut`,`heure_fin` FROM `cdt_emploi_du_temps` 
							WHERE `prof_ID`='".$prof_ID."' AND ".$search." AND `matiere_ID`='".$this->matiere_id."' AND `jour_semaine`='".$jour."' 
							ORDER BY `heure_debut`;";
			$result_seance = @mysql_query($query_seance,$this->link);
			$row_seance = @mysql_fetch_row($result_seance);

			//mise en place des variables
			$this->type = "devoir";
			$this->heure_debut = ( $row_seance ? $row_seance[0] : $this->horaires[1]["debut"] );
			$this->heure_fin = ( $row_seance ? $row_seance[1] : $this->horaires[1]["fin"] );
			$this->classe = ( empty($nom_gic) ? ( empty($nom_classe) ? 'Inconnue' : $nom_classe ) : $nom_gic );
			if($this->view=="classe" && !empty($nom_gic)) $this->show_classe = true;
			else $this->show_classe = false;
			$this->matiere = ( empty($nom_matiere) ? 'Inconnue' : $nom_matiere );
			$this->enseignant = ( empty($identite) ? ( empty($nom_prof) ? 'Inconnu' : $nom_prof ) : $identite );
			$this->group = ( empty($t_groupe) ? 'Inconnu' : $t_groupe );
			$this->devoir = ( empty($travail) ? 'Inconnu' : $travail );
			$this->alternance = "";
					
			//génération du code
			$this->make_event();
			$this->make_popup();
			}
		}

	/**
	 * Mémorise le format de vue WebCalendar demandée
	 * Le même à chaque fois pour un même objet instancié (par demande)
	 *
	 * @return boolean true si enregistrement effectué
	 */
	public function setFormat($format)
		{
		$format = intval($format);
		$set = true;
		if($format<1 || $format>3) $set = false;
		elseif($this->format===0) $this->format = $format; //non encore affecté, on enregistre la valeur
		elseif($this->format!=$format) $set = false; //le type a changé, problème	
		return $set;
		}

	/**
	 * Pour générer un évènement type day(1)/week(2)/month(3)
	 * Traitement inspiré de la fonction html_for_event_week_at_a_glance()
	 */
	public function make_event()
		{
		global $hour_arr,$rowspan_arr,$first_slot,$last_slot,$TIME_SPACER,$DISPLAY_END_TIMES,$ret;
		
		$class = ($this->type=="cours") ? "entry_c" : "entry_d";
		$gr = $this->short_group_name($this->group);
		$prefix = ($this->type=="cours") ? "Cours - " : "Devoirs - ";
		
		if($this->format==3) //traitement particulier pour l'affichage "month"
			{
			$img = '<img src="images/event.gif" class="bullet" width="5" height="7"/>';
			$ret .= '<span id="popcdt-'.$this->popup_id.'" class="'.$class.'">'.$img.$prefix;
			$ret .= ($this->view=="classe") ? $this->matiere.($this->show_classe ? ' - '.$this->classe : '') : $this->classe;
			if(!empty($gr)) $ret .= ' ('.$gr.')';
			$ret .= '</span><br/>';
			}
		else
			{
			$time = str_replace("h",":",$this->heure_debut) . (($DISPLAY_END_TIMES=='Y') ? "-".str_replace("h",":",$this->heure_fin) : "");
			if($this->format==1) $time = "[".$time."] ";
			elseif($this->format==2)
				{
				$time .= $TIME_SPACER;
				$prefix = ($this->type=="cours") ? "C - " : "D - "; //moins de place, donc plus court...
				}
			$debut = str_replace("h","",$this->heure_debut)."00"; //13h00 devient 130000
			$fin = str_replace("h","",$this->heure_fin)."00"; //13h00 devient 130000
			$ind = calc_time_slot($debut); //exemple : 13h00 correspond à 26 si affichage par créneau d'une demi-heure
			if($ind<$first_slot) $first_slot = $ind; //pour adapter l'affichage min
			if($ind>$last_slot) $last_slot = $ind; //pour adapter l'affichage max
			if(empty($rowspan_arr[$ind])) $rowspan_arr[$ind] = 0; //pour être défini la première fois
			if(empty($hour_arr[$ind])) $hour_arr[$ind] = '';
			$endind = calc_time_slot($fin,true);
			$rowspan = ($endind==$ind ? 0 : $endind - $ind + 1 );			
			if ($rowspan>$rowspan_arr[$ind] && $rowspan>1) $rowspan_arr[$ind] = $rowspan; //10-13h gagne sur 10-11h et 1 devient 3 (taille du bloc évènement)
			$text = $time.$prefix;
			$text .= ($this->view=="classe") ? $this->matiere.($this->show_classe ? ' - '.$this->classe : '') : $this->classe;
			if(!empty($gr)) $text .= ' ('.$gr.')';
			$text = '<span id="popcdt-'.$this->popup_id.'" class="'.$class.'">'.$text.'</span>';
			if($this->classe_id>0 && $this->matiere_id>0)
				{
				if($this->type=="cours")
					{
					//ne proposer le lien que si une séance existe à cette date, pour cette classe et cette matiere (ou regroupement)
					$query_seance = "SELECT count(*) FROM `cdt_agenda` WHERE `matiere_ID`='".$this->matiere_id."' AND `code_date` LIKE '".$this->date."%'";
					if($this->gic_id>0) $query_seance .= " AND `gic_ID`='".$this->gic_id."';";
					else $query_seance .= " AND `classe_ID`='".$this->classe_id."';";
					$result_seance = @mysql_query($query_seance,$this->link);
					$row_seance = @mysql_fetch_row($result_seance);
					if($row_seance[0]>0)
						{
						$link = $this->path.'lire.php?matiere_ID='.$this->matiere_id.'&classe_ID='.$this->classe_id;
						if($this->gic_id>0) $link .= "&gic_ID=".$this->gic_id;
						$text = '<a href="#" onclick="goToCdt(\''.$link.'\',\''.$this->consult_date.'\');" title="Acc&eacute;der &agrave; cette s&eacute;ance">'.$text.'</a>';
						}
					else $text = '<a href="#" title="Aucune s&eacute;ance enregistr&eacute;e &agrave; cette date pour ce cours">'.$text.'</a>';
					}
				else
					{
					if($this->view=="classe") $link = $this->path.'consulter.php?tri=date&classe_ID='.$this->classe_id; //vue de consultation des devoirs
					else $link = $this->path.'lire.php?matiere_ID='.$this->matiere_id.'&classe_ID='.$this->classe_id; //vue lecture complète pour le prof (vue consultation non prévue)
					$text = '<a href="'.$link.'" target="_blank" title="Acc&eacute;der aux devoirs du Cahier de textes">'.$text.'</a>';
					}
				}
			$hour_arr[$ind] .= $text.'<br/>';
			}
		}

	/**
	 * Pour générer un popup
	 * (activation des popups pour les balises html concernées : voir variable javascript entries dans includes/js/popups.php)
	 */
	public function make_popup()
		{
		global $DISPLAY_END_TIMES;
		
		$time = str_replace("h",":",$this->heure_debut) . (($DISPLAY_END_TIMES=='Y') ? "-".str_replace("h",":",$this->heure_fin) : "");
		$popup = '<dl id="eventinfo-popcdt-'.$this->popup_id.'" class="popup">' . "\n";
		$popup .= '<dt>Heure :</dt>' . "\n";
		$popup .= '<dd>'.$time.'</dd>' . "\n";
		$popup .= '<dt>Enseignant :</dt>' . "\n";
		$popup .= '<dd>'.$this->enseignant.'</dd>' . "\n";
		$popup .= '<dt>Mati&egrave;re :</dt>' . "\n";
		$popup .= '<dd>'.$this->matiere.'</dd>' . "\n";
		$popup .= '<dt>Classe :</dt>' . "\n";
		$popup .= '<dd>'.$this->classe.'</dd>' . "\n";
		$popup .= '<dt>Groupe :</dt>' . "\n";
		$popup .= '<dd>'.$this->group.'</dd>' . "\n";
		if($this->type=="cours")
			{
			$popup .= '<dt>Semaine :</dt>' . "\n";
			$popup .= '<dd>'.$this->alternance.'</dd>' . "\n";
			}
		else
			{
			$popup .= '<dt>&Agrave; faire :</dt>' . "\n";
			$popup .= '<dd>'.$this->devoir.'</dd>' . "\n";
			}
		$popup .= '</dl>' . "\n";
		$this->add_eventinfo($popup);
		$this->popup_id++;
		}

	/**
	 * Pour accéder au cdt (à une séance précise) par envoi automatique d'un formulaire
	 * (placer dans la variable $eventinfo affichée en fin de page)
	 */
	public function make_access()
		{
		$this->add_eventinfo('
		<script type="text/javascript">
		function goToCdt(link,date)
			{
			var form = document.getElementById("cdt_form");
			form.action = link;
			form.date1.value = date;
			form.date2.value = date;
			//alert (form.action+"-"+form.date1.value+"-"+form.date2.value);
			form.submit();
			form.action = "";
			form.date1.value = "";
			form.date2.value = "";
			}
		</script>
		');
		
		$this->add_eventinfo('
		<form id="cdt_form" action="" method="post" target="_blank">
		<input type="hidden" name="date1" value=""/>
		<input type="hidden" name="date2" value=""/>
		</form>
		');
		}

	/**
	 * Pour ajouter du texte à la variable $eventinfo utilisée par WebCalendar
	 * Cette variable est affichée en fin de script et contient les popups préparés par WebCalendar
	 * 
	 * @param string $text chaîne de caractères à ajouter
	 */
	public function add_eventinfo($text)
		{
		global $eventinfo;
		$eventinfo .= $text;
		}
	}
?>
