CREATE TABLE WEBCAL_ENTRY
(
   CAL_ID INTEGER NOT NULL,
   CAL_GROUP_ID INTEGER,
   CAL_CREATE_BY VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_DATE INTEGER NOT NULL,
   CAL_EXT_FOR_ID INTEGER,
   CAL_TIME INTEGER,
   CAL_MOD_DATE INTEGER,
   CAL_MOD_TIME INTEGER,
   CAL_DURATION INTEGER NOT NULL,
   CAL_DUE_DATE INTEGER,
   CAL_DUE_TIME INTEGER,
   CAL_PRIORITY INTEGER DEFAULT 2,
   CAL_TYPE CHAR(1) CHARACTER SET WIN1252 DEFAULT 'E',
   CAL_ACCESS CHAR(1) CHARACTER SET WIN1252 DEFAULT 'P',
   CAL_NAME VARCHAR(80) CHARACTER SET WIN1252 NOT NULL,
   CAL_LOCATION VARCHAR(100)CHARACTER SET WIN1252,
   CAL_URL VARCHAR(100)CHARACTER SET WIN1252,
   CAL_COMPLETED INTEGER DEFAULT NULL,
   CAL_DESCRIPTION VARCHAR(1024) CHARACTER SET WIN1252
);
CREATE TABLE WEBCAL_USER
(
   CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_PASSWD VARCHAR(32) CHARACTER SET WIN1252,
   CAL_LASTNAME VARCHAR(25) CHARACTER SET WIN1252,
   CAL_FIRSTNAME VARCHAR(25) CHARACTER SET WIN1252,
   CAL_IS_ADMIN CHAR(1) CHARACTER SET WIN1252 DEFAULT 'N',
   CAL_EMAIL VARCHAR(75) CHARACTER SET WIN1252,
   CAL_ENABLED CHAR(1) CHARACTER SET WIN1252 DEFAULT 'Y',
   CAL_TELEPHONE VARCHAR(50) CHARACTER SET WIN1252 DEFAULT NULL,
   CAL_ADDRESS VARCHAR(75) CHARACTER SET WIN1252 DEFAULT NULL,
   CAL_TITLE VARCHAR(75) CHARACTER SET WIN1252 DEFAULT NULL,
   CAL_BIRTHDAY INTEGER DEFAULT NULL
   CAL_LAST_LOGIN INTEGER DEFAULT NULL
);
CREATE TABLE WEBCAL_ENTRY_REPEATS
(
   CAL_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_TYPE VARCHAR(20) CHARACTER SET WIN1252,
   CAL_END INTEGER,
   CAL_ENDTIME INTEGER DEFAULT NULL,
   CAL_FREQUENCY INTEGER DEFAULT 1 NOT NULL,
   CAL_DAYS CHAR(7) CHARACTER SET WIN1252,
   CAL_BYMONTH VARCHAR(50) CHARACTER SET WIN1252,
   CAL_BYMONTHDAY VARCHAR(100) CHARACTER SET WIN1252,
   CAL_BYDAY VARCHAR(100) CHARACTER SET WIN1252,
   CAL_BYSETPOS VARCHAR(50) CHARACTER SET WIN1252,
   CAL_BYWEEKNO VARCHAR(50) CHARACTER SET WIN1252,
   CAL_BYYEARDAY VARCHAR(50) CHARACTER SET WIN1252,
   CAL_WKST CHAR(2) CHARACTER SET WIN1252 DEFAULT 'MO',
   CAL_COUNT INTEGER
);
CREATE TABLE WEBCAL_ENTRY_REPEATS_NOT
(
   CAL_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_DATE INTEGER NOT NULL,
   CAL_EXDATE INTEGER DEFAULT 1 NOT NULL
);
CREATE TABLE WEBCAL_ENTRY_USER
(
   CAL_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252  NOT NULL,
   CAL_STATUS VARCHAR(1) CHARACTER SET WIN1252 DEFAULT 'A',
   CAL_CATEGORY INTEGER,
   CAL_PERCENT INTEGER DEFAULT 0 NOT NULL
);
CREATE TABLE WEBCAL_ENTRY_EXT_USER
(
   CAL_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_FULLNAME VARCHAR(50) CHARACTER SET WIN1252 NOT NULL,
   CAL_EMAIL VARCHAR(75) CHARACTER SET WIN1252
);
CREATE TABLE WEBCAL_REMINDERS (
  CAL_ID INTEGER DEFAULT 0 NOT NULL,
  CAL_DATE INTEGER DEFAULT 0 NOT NULL,
  CAL_OFFSET INTEGER DEFAULT 0 NOT NULL,
  CAL_RELATED CHAR(1) CHARACTER SET WIN1252 DEFAULT 'S' NOT NULL,
  CAL_BEFORE CHAR(1) CHARACTER SET WIN1252 DEFAULT 'Y' NOT NULL,
  CAL_LAST_SENT INTEGER DEFAULT 0 NOT NULL,
  CAL_REPEATS INTEGER DEFAULT 0 NOT NULL,
  CAL_DURATION INTEGER DEFAULT 0 NOT NULL,
  CAL_TIMES_SENT INTEGER DEFAULT 0 NOT NULL,
  CAL_ACTION VARCHAR(12) CHARACTER SET WIN1252 DEFAULT 'EMAIL' NOT NULL
);
CREATE TABLE WEBCAL_SITE_EXTRAS
(
   CAL_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_NAME VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_TYPE INTEGER NOT NULL,
   CAL_DATE INTEGER DEFAULT 0,
   CAL_REMIND INTEGER DEFAULT 0,
   CAL_DATA VARCHAR(500) CHARACTER SET WIN1252
);
CREATE TABLE WEBCAL_USER_LAYERS
(
   CAL_LAYERID INTEGER DEFAULT 0 NOT NULL,
   CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_LAYERUSER VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_COLOR VARCHAR(25) CHARACTER SET WIN1252,
   CAL_DUPS CHAR(1) CHARACTER SET WIN1252 DEFAULT 'N'
);
CREATE TABLE WEBCAL_USER_PREF
(
   CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_SETTING VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_VALUE VARCHAR(100) CHARACTER SET WIN1252
);
CREATE TABLE WEBCAL_GROUP
(
   CAL_GROUP_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_OWNER VARCHAR(25) CHARACTER SET WIN1252,
   CAL_NAME VARCHAR(50) CHARACTER SET WIN1252 NOT NULL,
   CAL_LAST_UPDATE INTEGER DEFAULT 0 NOT NULL
);
CREATE TABLE WEBCAL_GROUP_USER
(
   CAL_GROUP_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL
);
CREATE TABLE WEBCAL_VIEW
(
   CAL_VIEW_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_OWNER VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_NAME VARCHAR(50) CHARACTER SET WIN1252 NOT NULL,
   CAL_VIEW_TYPE VARCHAR(1) CHARACTER SET WIN1252 NOT NULL,
   CAL_IS_GLOBAL CHAR(1) CHARACTER SET WIN1252 DEFAULT 'N' NOT NULL
);
CREATE TABLE WEBCAL_VIEW_USER
(
   CAL_VIEW_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL
);
CREATE TABLE WEBCAL_CONFIG
(
   CAL_SETTING VARCHAR(50) CHARACTER SET WIN1252 NOT NULL,
   CAL_VALUE VARCHAR(100) CHARACTER SET WIN1252
);
CREATE TABLE WEBCAL_ENTRY_LOG
(
   CAL_LOG_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_ENTRY_ID INTEGER DEFAULT 0 NOT NULL,
   CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
   CAL_USER_CAL VARCHAR(25) CHARACTER SET WIN1252,
   CAL_TYPE VARCHAR(1) CHARACTER SET WIN1252 NOT NULL,
   CAL_DATE INTEGER,
   CAL_TIME INTEGER,
   CAL_TEXT VARCHAR(500) CHARACTER SET WIN1252
);
CREATE TABLE WEBCAL_CATEGORIES
(
   CAT_ID INTEGER DEFAULT 0 NOT NULL,
   CAT_OWNER VARCHAR(25) CHARACTER SET WIN1252,
   CAT_NAME VARCHAR(80) CHARACTER SET WIN1252 NOT NULL,
   CAT_COLOR VARCHAR(8) CHARACTER SET WIN1252 DEFAULT NULL
);
CREATE TABLE WEBCAL_ASST
(
  CAL_BOSS VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  CAL_ASSISTANT  VARCHAR(25) CHARACTER SET WIN1252 NOT NULL
);
CREATE TABLE WEBCAL_NONUSER_CALS
(
  CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  CAL_LASTNAME VARCHAR(25) CHARACTER SET WIN1252,
  CAL_FIRSTNAME VARCHAR(25) CHARACTER SET WIN1252,
  CAL_ADMIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  CAL_URL VARCHAR(255) CHARACTER SET WIN1252 DEFAULT NULL,
  CAL_IS_PUBLIC VARCHAR(1) CHARACTER SET WIN1252 DEFAULT 'N' NOT NULL
);
CREATE TABLE WEBCAL_IMPORT
(
  CAL_IMPORT_ID INTEGER DEFAULT 0 NOT NULL,
  CAL_NAME VARCHAR(50) CHARACTER SET WIN1252,
  CAL_DATE INTEGER DEFAULT 0 NOT NULL,
  CAL_TYPE VARCHAR(10) CHARACTER SET WIN1252 NOT NULL,
  CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL
);
CREATE TABLE WEBCAL_IMPORT_DATA
 (
  CAL_IMPORT_ID INTEGER DEFAULT 0 NOT NULL,
  CAL_ID INTEGER DEFAULT 0 NOT NULL,
  CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  CAL_IMPORT_TYPE VARCHAR(15) CHARACTER SET WIN1252 NOT NULL,
  CAL_EXTERNAL_ID VARCHAR(200) CHARACTER SET WIN1252
);
CREATE TABLE WEBCAL_REPORT
 (
  CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  CAL_REPORT_ID INTEGER DEFAULT 0 NOT NULL,
  CAL_IS_GLOBAL VARCHAR(1) CHARACTER SET WIN1252 DEFAULT 'N'  NOT NULL,
  CAL_REPORT_TYPE VARCHAR(20) CHARACTER SET WIN1252 NOT NULL,
  CAL_INCLUDE_HEADER VARCHAR(1) CHARACTER SET WIN1252 DEFAULT 'Y'  NOT NULL,
  CAL_REPORT_NAME VARCHAR(50) CHARACTER SET WIN1252 NOT NULL,
  CAL_TIME_RANGE INTEGER DEFAULT 0 NOT NULL,
  CAL_USER VARCHAR(25) CHARACTER SET WIN1252,
  CAL_ALLOW_NAV VARCHAR(1) CHARACTER SET WIN1252 DEFAULT 'Y' NOT NULL,
  CAL_CAT_ID INTEGER,
  CAL_INCLUDE_EMPTY VARCHAR(1) CHARACTER SET WIN1252 DEFAULT 'N' NOT NULL,
  CAL_SHOW_IN_TRAILER VARCHAR(1) CHARACTER SET WIN1252 DEFAULT 'N' NOT NULL,
  CAL_UPDATE_DATE INTEGER DEFAULT 0 NOT NULL
);
CREATE TABLE WEBCAL_REPORT_TEMPLATE
 (
  CAL_REPORT_ID INTEGER DEFAULT 0 NOT NULL,
  CAL_TEMPLATE_TYPE VARCHAR(1) CHARACTER SET WIN1252 NOT NULL,
  CAL_TEMPLATE_TEXT VARCHAR(1024) CHARACTER SET WIN1252 NOT NULL
);
CREATE TABLE WEBCAL_ACCESS_USER
 (
  cal_login VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  cal_other_user VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  CAL_CAN_VIEW INTEGER DEFAULT '0' NOT NULL,
  CAL_CAN_EDIT INTEGER DEFAULT '0' NOT NULL,
  CAL_CAN_APPROVE INTEGER DEFAULT '0' NOT NULL,
  CAL_CAN_INVITE CHAR(1) CHARACTER SET WIN1252 DEFAULT 'Y' NOT NULL,
  CAL_CAN_EMAIL CHAR(1) CHARACTER SET WIN1252 DEFAULT 'Y' NOT NULL,
  CAL_SEE_TIMES_ONLY CHAR(1) CHARACTER SET WIN1252 DEFAULT 'N' NOT NULL
);
CREATE TABLE WEBCAL_ACCESS_FUNCTION
 (
  cal_login VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  CAL_PERMISSIONS VARCHAR(64) CHARACTER SET WIN1252 NOT NULL
);
CREATE TABLE WEBCAL_USER_TEMPLATE
 (
  CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 NOT NULL,
  CAL_TYPE VARCHAR(1) CHARACTER SET WIN1252 NOT NULL,
  CAL_TEMPLATE_TEXT VARCHAR(1024) CHARACTER SET WIN1252 NOT NULL
);
CREATE TABLE WEBCAL_ENTRY_CATEGORIES
 (
  CAL_ID INTEGER DEFAULT 0 NOT NULL,
  CAT_ID INTEGER DEFAULT 0 NOT NULL,
  CAT_ORDER INTEGER DEFAULT 0 NOT NULL,
  CAT_OWNER VARCHAR(25)CHARACTER SET WIN1252 DEFAULT NULL
);
CREATE TABLE WEBCAL_BLOB
 (
  CAL_BLOB_ID INTEGER NOT NULL,
  CAL_ID INTEGER DEFAULT NULL,
  CAL_LOGIN VARCHAR(25) CHARACTER SET WIN1252 DEFAULT NULL,
  CAL_NAME VARCHAR(30) CHARACTER SET WIN1252 DEFAULT NULL,
  CAL_DESCRIPTION VARCHAR(128) CHARACTER SET WIN1252 DEFAULT NULL,
  CAL_SIZE INTEGER DEFAULT NULL,
  CAL_MIME_TYPE VARCHAR(50) CHARACTER SET WIN1252 DEFAULT NULL,
  CAL_TYPE CHAR(1) CHARACTER SET WIN1252 NOT NULL,
  CAL_MOD_DATE INTEGER NOT NULL,
  CAL_MOD_TIME INTEGER NOT NULL,
  CAL_BLOB BLOB
);
CREATE TABLE webcal_TIMEZONES (
  TZID VARCHAR(100) CHARACTER SET WIN1252 DEFAULT '' NOT NULL,
  DTSTART VARCHAR(25) CHARACTER SET WIN1252 DEFAULT NULL,
  DTEND VARCHAR(25) CHARACTER SET WIN1252 DEFAULT NULL,
  VTIMEZONE VARCHAR(500) CHARACTER SET WIN1252
);
CREATE INDEX IWEBCAL_ENTRYNEWINDEX ON WEBCAL_ENTRY(CAL_ID);
CREATE INDEX IWEBCAL_ENTRY_REPEATSNEWINDEX ON WEBCAL_ENTRY_REPEATS(CAL_ID);
CREATE INDEX IWEBCAL_ENTRY_REP_NOTNEWINDEX ON WEBCAL_ENTRY_REPEATS_NOT(CAL_ID, CAL_DATE);
CREATE INDEX IWEBCAL_ENTRY_USERNEWINDEX ON WEBCAL_ENTRY_USER(CAL_ID, CAL_LOGIN);
CREATE INDEX IWEBCAL_ENTRY_EXTUSERNEWINDEX ON WEBCAL_ENTRY_EXT_USER(CAL_ID, CAL_FULLNAME);
CREATE INDEX IWEBCAL_REMINDERSNEWINDEX ON WEBCAL_REMINDERS(CAL_ID);
CREATE INDEX IWEBCAL_USERNEWINDEX ON WEBCAL_USER(CAL_LOGIN);
CREATE INDEX IWEBCAL_USER_LAYERSNEWINDEX ON WEBCAL_USER_LAYERS(CAL_LOGIN, CAL_LAYERUSER);
CREATE INDEX IWEBCAL_USER_PREFNEWINDEX ON WEBCAL_USER_PREF(CAL_LOGIN, CAL_SETTING);
CREATE INDEX IWEBCAL_GROUPNEWINDEX ON WEBCAL_GROUP(CAL_GROUP_ID);
CREATE INDEX IWEBCAL_GROUPUSERNEWINDEX ON WEBCAL_GROUP_USER(CAL_GROUP_ID, CAL_LOGIN);
CREATE INDEX IWEBCAL_VIEWNEWINDEX ON WEBCAL_VIEW(CAL_VIEW_ID);
CREATE INDEX IWEBCAL_VIEWUSERNEWINDEX ON WEBCAL_VIEW_USER(CAL_VIEW_ID, CAL_LOGIN);
CREATE INDEX IWEBCAL_CONFIGNEWINDEX ON WEBCAL_CONFIG(CAL_SETTING);
CREATE INDEX IWEBCAL_ENTRYLOGINDEX ON WEBCAL_ENTRY_LOG(CAL_LOG_ID);
CREATE INDEX IWEBCAL_CATEGORIESINDEX ON WEBCAL_CATEGORIES(CAT_ID);
CREATE INDEX IWEBCAL_BOSSINDEX ON WEBCAL_ASST(CAL_BOSS, CAL_ASSISTANT);
CREATE INDEX IWEBCAL_NONUSERCALSINDEX ON WEBCAL_NONUSER_CALS(CAL_LOGIN);
CREATE INDEX IWEBCAL_IMPORT2INDEX ON WEBCAL_IMPORT(CAL_IMPORT_ID);
CREATE INDEX IWEBCAL_IMPORTINDEX ON WEBCAL_IMPORT_DATA(CAL_LOGIN, CAL_ID);
CREATE INDEX IWEBCAL_REPORTINDEX ON WEBCAL_REPORT(CAL_REPORT_ID);
CREATE INDEX IWEBCAL_REPORTTEMPLATEINDEX ON WEBCAL_REPORT_TEMPLATE(CAL_REPORT_ID, CAL_TEMPLATE_TYPE);
CREATE INDEX IWEBCAL_ACCESSUSERINDEX ON WEBCAL_ACCESS_USER(CAL_LOGIN, CAL_OTHER_USER);
CREATE INDEX IWEBCAL_ACCESSFUNCTIONINDEX ON WEBCAL_ACCESS_FUNCTION(CAL_LOGIN);
CREATE INDEX IWEBCAL_USERTEMPLATE ON WEBCAL_USER_TEMPLATE(CAL_LOGIN,CAL_TYPE);
CREATE INDEX IWEBCAL_BLOB ON WEBCAL_BLOB(CAL_BLOB_ID);
CREATE INDEX IWEBCAL_TIMEZONESNEWINDEX ON WEBCAL_TIMEZONES(TZID);

