# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2012
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
""" EoleDB Parent Class. This class manage the initialisation of EoleDB
    database objects.

"""


class EoleDb:
    """ Parent class for Database Manipulation
    """

    def __init__(self, obj):
        if hasattr(obj, 'dbcliconf') and \
           hasattr(obj, 'dbroot') and \
           hasattr(obj, 'dbhost') and \
           hasattr(obj, 'dbrootpwd'):
            if hasattr(obj, "dbport"):
                self.dbport = obj.dbport
            else:
                self.dbport = None
            self.dbroot = obj.dbroot
            self.dbhost = obj.dbhost
            self.dbrootpwd = obj.dbrootpwd
            self.dbport = obj.dbport
            self.dbcliconf = None
        else:
            if hasattr(obj, 'dbcliconf'):
                self.dbcliconf = obj.dbcliconf
                if hasattr(obj, "dbport"):
                    self.dbport = obj.dbport
                else:
                    self.dbport = None

                self.dbroot = None

                if hasattr(obj, "dbhost"):
                    self.dbhost = obj.dbhost
                else:
                    self.dbhost = "127.0.0.1"

                if hasattr(obj, "dbrootpwd"):
                    self.dbrootpwd = obj.dbrootpwd
                else:
                    self.dbrootpwd = None

                if hasattr(obj, 'dbroot'):
                    self.dbport = obj.dbport
                else:
                    self.dbport = None
            else:
                if hasattr(obj, 'container'):
                    self.container = obj.container
                    self.dbroot = 'root'
                    self.dbrootpwd = None
                else:
                    if hasattr(obj, 'dbroot'):
                        self.dbroot = obj.dbroot
                    else:
                        msg = "[ERROR] No database root user provided\n"
                        msg += "Please check your configuration"
                        raise Exception(msg)

                    if hasattr(obj, 'dbrootpwd'):
                        self.dbrootpwd = obj.dbrootpwd
                    else:
                        msg = "[ERROR] No database root user password provided\n"
                        msg += "Please check your configuration"
                        raise Exception(msg)

                if hasattr(obj, 'dbhost'):
                    self.dbhost = obj.dbhost
                else:
                    raise Exception("[ERROR] No database host provided\n \
                            Please check your configuration")

                if hasattr(obj, 'dbport'):
                    self.dbport = obj.dbport
                else:
                    if hasattr(obj, 'container'):
                        self.dbport = None
                    else:
                        raise Exception("[ERROR] No database port provided\n \
                                Please check your configuration")

        if hasattr(obj, 'dbtype'):
            self.dbtype = obj.dbtype
        else:
            raise Exception("[ERROR] No database type provided\n \
                    Please check your configuration")

        if hasattr(obj, 'pwd_files'):
            self.pwd_files = obj.pwd_files
        else:
            self.pwd_files = None

        if hasattr(obj, 'sqlscripts'):
            self.sqlscripts = obj.sqlscripts
        else:
            self.sqlscripts = []
        if hasattr(obj, 'updatescripts'):
            self.updatescripts = obj.updatescripts
        else:
            self.updatescripts = []

        if hasattr(obj, "client_hosts"):
            self.client_hosts = obj.client_hosts
        else:
            self.client_hosts = []

        self.dbuser = obj.dbuser
        self.dbpass = obj.dbpass
        self.dbname = obj.dbname
        self.createscript = obj.createscript
        self.rtpwdChanged = False

    def get_statements(self, path):
        """
        Transforme les instructions SQL d'un script en tableau
        """
        statements = []
        comment = False
        collect = False
        statement = None
        delim = ';'

        fd = open(path, "r")
        for line in fd:
            line = line.strip()
            if line.startswith("/*"):
                comment = True

            if comment and line.endswith("*/") or line.endswith('*/;'):
                comment = False
                continue

            if line.startswith("--") or len(line) == 0:
                continue

            if line.startswith("\\r"):
                line = line.replace("\\r", "USE")
                if not line.endswith(delim):
                    line += delim

            if not comment:
                if line.startswith('DELIMITER') or line.startswith('delimiter'):
                    delim = line[-1:]
                else:
                    if statement is None:
                        statement = line
                    else:
                        statement += line + " "

                    if line.endswith(delim) and statement is not None and \
                            len(statement) != 0:
                                if delim is not ';':
                                    statement = statement.replace(delim, ';')
                                statements.append(statement)
                                statement = None

        fd.close()
        return statements

    def run(self, statement):
        """
        FIXME Execute une commande SQL
        """
        print "[NOT IMPLEMENTED YET] Run MySql Statement : \n\t" + statement

    def close(self):
        """
        Ferme le curseur et la connection si ils sont ouverts
        """
        if self.cursor:
            self.cursor.close()
        if self.connection:
            self.connection.close()
