# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2012
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""Création de base de données et instanciation des structures
 # - MySQL
 # - Postgresql
 # - Sqlite3
"""

import os.path
import yaml
from eoledberrors import UnsupportedDatabase

DBS = {}

try:
    from eoledbsqlite import EoleDbSqlite
    DBS.update(sqlite=EoleDbSqlite)
except ImportError:
    pass

try:
    from eoledbpg import EoleDbPg
    DBS.update(postgres=EoleDbPg)
except ImportError:
    pass

try:
    from eoledbmysql import EoleDbMy
    DBS.update(mysql=EoleDbMy)
except ImportError:
    pass


class EoleDbConnector(object):
    def __init__(self, params, config=""):
        self.connections = DBS
        if params['dbcont']:
            self.container = params['dbcont']
        if params['dbroot']:
            self.dbroot =  params['dbroot']
        if params['dbrootpwd']:
            if os.path.isfile(params['dbrootpwd']):
                self.dbrootpwd = open(params['dbrootpwd'], 'r').read().rstrip()
            else:
                self.dbrootpwd = params['dbrootpwd']
        if params['dbhost']:
            self.dbhost = params['dbhost']
        if params['dbport']:
            self.dbport = params['dbport']
        if params['dbtype']:
            self.dbtype = params['dbtype']
        if params['dbcliconf']:
            self.dbcliconf = params['dbcliconf']
        if params['client_hosts']:
            self.client_hosts = params['client_hosts']

        self.from_yaml(config)

    def from_yaml(self, path):
        dico = yaml.load(file(path))
        for key, value in dico.items():
            if key == 'dbroot':
                if hasattr(self, 'dbroot'):
                    self.dbroot = value
                else:
                    setattr(self, key, value)
            elif key == 'dbrootpwd':
                if os.path.isfile(value):
                    pwd = open(value, 'r').read().rstrip()
                else:
                    pwd = value

                if hasattr(self, 'dbrootpwd'):
                    self.dbrootpwd = pwd
                else:
                    setattr(self, key, pwd)
            elif key == 'dbhost':
                if hasattr(self, 'dbhost'):
                    self.dbhost = value
                else:
                    setattr(self, key, value)
            elif key == 'dbport':
                if hasattr(self, 'dbport'):
                    self.dbport = value
                else:
                    setattr(self, key, value)
            elif key == 'dbtype':
                if hasattr(self, 'dbtype'):
                    self.dbtype = value
                else:
                    setattr(self, key, value)
            else:
                setattr(self, key, value)

    def __call__(self):
        if self.dbtype in DBS:
            return self.connections[self.dbtype](self)
        else:
            message = 'Unsupported "{0}" database type.\n'.format(self.dbtype)
            message += "\nPlease check if this database is supported by EoleDB"
            message += "\nIf it's supported please install the missing python \
                    libaries\n"
            raise UnsupportedDatabase(message)
