# -*- coding: utf-8 -*-
#
##########################################################################
# eoleauth
# Copyright © 2013 Pôle de compétences EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
##########################################################################
# Import eoleauth as app
# You can log with: app.logger.info()
from eoleauth import app
from eoleauthlib.authclient import login_required, init_authentication
from eoleauthlib.i18n import _

from flask import session
from markupsafe import escape

######################### Start coding here ####################################

init_authentication(app)

@app.route('/', methods=["GET", "POST"])
@login_required
def index():
    if 'username' in session:
        # auth ok, rediriger sur l'application appelante si définie
        return _('Logged in as {0}').format(escape(session['username']))
    return _('You are not logged in')
