#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""Module d'authentification Zephir / PAM"""

import PAM

from flask import request, redirect, current_app, escape, render_template, flash, g, session

from eoleauthlib.client import BaseClient
from eoleauthlib.i18n import _
from eoleauthlib.errors import AuthenticationNeeded, UnauthorizedError

class ZephirPAMClient(BaseClient):
    """Zephir Client"""

    available = False
    server_ip = None
    server_id = -1

    #def __init__(self):
    #    super(ZephirPAMClient, self).__init__()
    #    self.init_zephir()

    def zephir_dict(self, provide, registered=True):
        return {
                'registered': self.available  if registered else False,
                'available' : self.available  if provide else False,
                'server_id' : self.server_id  if provide else None,
                'server_ip' : self.server_ip  if provide else None,
            }

    def _init_client(self, active=True):
        """Initialize plugin with configured options"""
        self.init_zephir()
        if len(self.allowed_users) == 1 and self.allowed_users[0] and not self.available:
            self.user = self.allowed_users[0]
        else:
            self.user = ''

    def init_zephir(self):
        try:
            from zephir.zephir_conf.zephir_conf import adresse_zephir as server_ip, id_serveur as server_id
            self.available = True
            self.server_ip = server_ip
            self.server_id = server_id
        except: pass

    def check_authsource(self):
        """Checks that authentication source is available (PAM)"""
        return True

    def check_allowed_users(self, user_data):
        """checks if current user is in the list of allowed users for this app
         ( if ALLOWED_USERS is defined in application configuration)
        """
        pass

    def pam_conv(self, auth, query_list, userData):
        """Manages lib_pam prompts and messages"""
        resp = []
        for i in range(len(query_list)):
            query, type = query_list[i]
            if type == PAM.PAM_PROMPT_ECHO_ON:
                val = raw_input(query)
                resp.append((val, 0))
            elif type == PAM.PAM_PROMPT_ECHO_OFF:
                resp.append((self.passwd, 0))
            elif type == PAM.PAM_PROMPT_ERROR_MSG or type == PAM.PAM_PROMPT_TEXT_INFO:
                print(query)
                calProxy(get_db)
                resp.append(('', 0))
            else:
                return None
        return resp

    def _authenticate(self):
        """Asks for username/password"""
        return render_template('login.html',
                user=self.user,
                current_app=current_app,
                zephir_available=self.available,
                zephir_server_ip=self.server_ip,
                zephir_server_id=self.server_id)

    def _check_authentication(self):
        """Checks credentials against PAM service"""
        if 'password' in request.form:
            return self._validate()
        return None

    def _validate(self):
        """Performs Zephir/PAM authentication"""
        username = request.form.get('username', self.user)
        password = request.form.get('password','')
        sync     = request.form.get('sync', None) != None

        # Zephir Authentication
        # =====================

        if self.available:
            from zephir.lib_zephir import EoleProxy, TransportEole
            proxy = EoleProxy('https://%s:%s@%s:7080' % (username, password, self.server_ip), transport = TransportEole())
            try:
                data = proxy.modules.get_module()
                assert data[0] == 1
            except:
                flash(_(u'L\'authentification distante (Zéphir) a échoué') , 'error')
            else:
                g.zephir = self.zephir_dict(sync)
                g.zephir['proxy'] = proxy
                return { 'username': username, 'zephir': self.zephir_dict(sync) }

        # PAM Authentication (if zephir failed)
        # =====================================

        auth = PAM.pam()
        if username:
            try:
                auth.start('passwd')
                auth.set_item(PAM.PAM_USER, username)
                auth.set_item(PAM.PAM_CONV, self.pam_conv)
                self.passwd = password
                auth.authenticate()
                auth.acct_mgmt()
                if len(self.allowed_users) > 0 and username not in self.allowed_users:
                    current_app.logger.error(_("Access denied to {0} (check configuration for allowed users)").format(current_app.name))
                    raise UnauthorizedError(_("Vous n'êtes pas autorisé à vous connecter avec cet utilisateur"))
                g.zephir = self.zephir_dict(False, False)
                return { 'username': username, 'zephir': self.zephir_dict(False, False) }
            except PAM.error as resp:
                current_app.logger.error(_('Authentication failed for user {0}').format(username))
                flash(_(u'L\'authentification locale (PAM) a échoué'), 'error')
                pass
            except Exception as e:
                current_app.logger.error(_('Internal error during PAM Authentication : {0}').format(e))
                flash(_(u'Erreur : {0}').format(e) , 'error')
            finally:
                self.passwd = None

        return None
