# -*- coding: utf-8 -*-
#
##########################################################################
# eoleauth plugins
# Copyright © 2013 Pôle de compétences EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
##########################################################################
"""authentication plugins for eoleauth
Loads authentication clients derived from eoleauth.authclient.BaseClient
"""

import os
import importlib
from glob import glob
from eoleauthlib.client import BaseClient

def load_source(name, module_path):
    spec = importlib.util.spec_from_file_location(name, module_path)
    module = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(module)
    return module

plugin_modules = glob(os.path.join(os.path.dirname(__file__),'*.py'))
PLUGINS = {}
for plugin_module in plugin_modules:
    if not plugin_module.endswith('__init__.py'):
        current_plugin = load_source('current_plugin', plugin_module)
        for obj_name in dir(current_plugin):
            obj = getattr(current_plugin, obj_name)
            if not obj_name.startswith('_') and obj_name != 'BaseClient':
                try:
                    assert issubclass(obj, BaseClient)
                    PLUGINS[obj_name] = obj
                except:
                    pass
