try:
    from . import custom
except:
    custom = None


from os.path import dirname, abspath, join, basename, isfile
from creole.loader import creole_loader

here = dirname(abspath(__file__))
modname = basename(here)
ewtapp = basename(dirname(here))

MAX_SIZE = 10485760

def read_file(filename, language, *args, **kwargs):
    """Retrieves the tiramisu's options informations
    and converts it in the tiramisu web format
    """
    if not isfile(filename):
        return {'message': {'text': 'File does not exist: {}'.format(filename), 'type': 'error'}}
    with open(filename)as f:
        return {'filename': filename, 'language': language, 'content': f.read(MAX_SIZE).rsplit('\n', 1)[0]}

def read(*args, **kwargs):
    try:
        config = creole_loader(load_extra=True, rw=True, owner=modname)
        filename = getattr(config, modname).options.filename
        try:
            language = getattr(config, modname).options.language
        except:
            language = ""
        if custom is not None and hasattr(custom, 'read'):
            custom.__salt__ = __salt__
            return custom.read(filename, language, *args, **kwargs)
        else:
            return read_file(filename, language, *args, **kwargs)

    except Exception as err:
        return {'message': {'text': 'An error occured: {}'.format(err), 'type': 'error'}}


__all__ = ('read',)
