"""automatically loads all submodules
with some magic in the `__init__` files

puts in the __init__.py something like

from shutdown import describe, submit as shutdown_describe, shubdown_submit

"""
from os.path import (isdir as _isdir, abspath as _abspath, dirname as _dirname, join as _join,
                     basename as _basename)
from os import listdir as _listdir
from importlib import import_module as _import_module

ABS_FOLDER = _abspath(__file__)
FOLDER = _dirname(ABS_FOLDER)
MODULE_NAME = _basename(FOLDER)

def _list_subfolders(folder=FOLDER):
    actions = []
    folders = _listdir(folder)
    for subfolder in folders:
        module = _join(folder, subfolder)
        if _isdir(module):
            actions.append(subfolder)
    return actions

def _add_imports():
    actions = _list_subfolders()
    imports = {}
    for action_name in actions:
        action_pkg = _import_module(MODULE_NAME + '.' + action_name)
        if "__all__" in dir(action_pkg):
            functions = action_pkg.__all__
            filter_functions = False
        else:
            functions = dir(action_pkg)
            filter_functions = True
        for function in functions:
            if filter_functions and function.startswith('_'):
                continue
            imports[action_name + '_' + function] = wrapper_func(action_pkg, function)
    return imports

def _popupate_glob(globenv):
    imps = _add_imports()
    for imp_name, func in imps.items():
        globenv[imp_name] = func
    return imps.keys()

def wrapper_func(module, function):
    def func(*args, **kwargs):
        module.__salt__ = __salt__
        module.__utils__ = __utils__
        return getattr(module, function)(*args, **kwargs)
    return func

GLOBENV = globals()
__all__ = _popupate_glob(GLOBENV)
