from . import action
import traceback

try:
    from . import custom
except:
    custom = None

def describe(*args, **kwargs):
    try:
        action.__salt__ = __salt__
        if custom is not None and hasattr(custom, 'describe'):
            custom.__salt__ = __salt__
            custom.__action__ = action
            return custom.describe(*args, **kwargs)
        else:
            return action.describe(*args, **kwargs)
    except Exception as err:
        traceback.print_exc()
        return {'message': {'text': 'An error occured: {}'.format(err), 'type': 'error'}}


def submit(*args, **kwargs):
    try:
        action.__salt__ = __salt__
        if custom is not None and hasattr(custom, 'submit'):
            custom.__salt__ = __salt__
            custom.__action__ = action
            return custom.submit(*args, **kwargs)
        else:
            return action.submit(*args, **kwargs)
    except Exception as err:
        traceback.print_exc()
        return {'message': {'text': 'An error occured: {}'.format(err), 'type': 'error'}}

_modules = ['submit', 'describe']

if custom:
    if hasattr(custom, '__CUSTOM_MODULES__'):
        for function in custom.__CUSTOM_MODULES__:
            if not function.startswith("_"):
                _modules.append(function)
                globals()[function] = getattr(custom, function)

__all__ = tuple(_modules)
