# -*- coding: UTF-8 -*-

"internationalisation utilities"
import gettext
import os
import sys
import locale

# Application Name
APP_NAME = 'pyeole'

# Traduction dir
APP_DIR = os.path.join(sys.prefix, 'share')
LOCALE_DIR = os.path.join(APP_DIR, 'locale')

# Default Lanugage
DEFAULT_LANG = os.environ.get('LANG', '').split(':')
DEFAULT_LANG += ['en_US']

languages = []
lc, encoding = locale.getlocale()
if lc:
    languages = [lc]

languages += DEFAULT_LANG
mo_location = LOCALE_DIR

gettext.find(APP_NAME, mo_location)
gettext.textdomain(APP_NAME)

t = gettext.translation(APP_NAME, fallback=True)

def _(msg):
    return t.gettext(msg)
